/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.inference.InferenceResults;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.EmbeddingInt;
import org.elasticsearch.xpack.core.inference.results.LegacyTextEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbedding;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.inference.results.ErrorInferenceResults;
import org.elasticsearch.xpack.core.ml.inference.results.MlTextEmbeddingResults;

public record InferenceTextEmbeddingFloatResults(List<InferenceFloatEmbedding> embeddings) implements InferenceServiceResults,
TextEmbedding
{
    public static final String NAME = "text_embedding_service_results";
    public static final String TEXT_EMBEDDING = TaskType.TEXT_EMBEDDING.toString();

    public InferenceTextEmbeddingFloatResults(StreamInput in) throws IOException {
        this(in.readCollectionAsList(InferenceFloatEmbedding::new));
    }

    InferenceTextEmbeddingFloatResults(LegacyTextEmbeddingResults legacyTextEmbeddingResults) {
        this(legacyTextEmbeddingResults.embeddings().stream().map(embedding -> new InferenceFloatEmbedding(embedding.values())).collect(Collectors.toList()));
    }

    public static InferenceTextEmbeddingFloatResults of(List<? extends InferenceResults> results) {
        ArrayList<InferenceFloatEmbedding> embeddings = new ArrayList<InferenceFloatEmbedding>(results.size());
        for (InferenceResults inferenceResults : results) {
            if (inferenceResults instanceof MlTextEmbeddingResults) {
                MlTextEmbeddingResults embeddingResult = (MlTextEmbeddingResults)inferenceResults;
                embeddings.add(InferenceFloatEmbedding.of(embeddingResult));
                continue;
            }
            if (inferenceResults instanceof ErrorInferenceResults) {
                ErrorInferenceResults errorResult = (ErrorInferenceResults)inferenceResults;
                Exception exception = errorResult.getException();
                if (exception instanceof ElasticsearchStatusException) {
                    ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
                    throw statusException;
                }
                throw new ElasticsearchStatusException("Received error inference result.", RestStatus.INTERNAL_SERVER_ERROR, errorResult.getException(), new Object[0]);
            }
            throw new IllegalArgumentException("Received invalid inference result, of type " + inferenceResults.getClass().getName() + " but expected TextEmbeddingResults.");
        }
        return new InferenceTextEmbeddingFloatResults(embeddings);
    }

    @Override
    public int getFirstEmbeddingSize() {
        return TextEmbeddingUtils.getFirstEmbeddingSize(new ArrayList<EmbeddingInt>(this.embeddings));
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return ChunkedToXContentHelper.array(TEXT_EMBEDDING, this.embeddings.iterator());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.embeddings);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public List<? extends InferenceResults> transformToCoordinationFormat() {
        return this.embeddings.stream().map(embedding -> new MlTextEmbeddingResults(TEXT_EMBEDDING, embedding.asDoubleArray(), false)).toList();
    }

    @Override
    public List<? extends InferenceResults> transformToLegacyFormat() {
        LegacyTextEmbeddingResults legacyEmbedding = new LegacyTextEmbeddingResults(this.embeddings.stream().map(embedding -> new LegacyTextEmbeddingResults.Embedding(embedding.values)).toList());
        return List.of(legacyEmbedding);
    }

    @Override
    public Map<String, Object> asMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(TEXT_EMBEDDING, this.embeddings);
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InferenceTextEmbeddingFloatResults that = (InferenceTextEmbeddingFloatResults)o;
        return Objects.equals(this.embeddings, that.embeddings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.embeddings);
    }

    public record InferenceFloatEmbedding(float[] values) implements Writeable,
    ToXContentObject,
    EmbeddingInt
    {
        public static final String EMBEDDING = "embedding";

        public InferenceFloatEmbedding(StreamInput in) throws IOException {
            this(in.readFloatArray());
        }

        public static InferenceFloatEmbedding of(MlTextEmbeddingResults embeddingResult) {
            float[] embeddingAsArray = embeddingResult.getInferenceAsFloat();
            return new InferenceFloatEmbedding(embeddingAsArray);
        }

        public static InferenceFloatEmbedding of(List<Float> embeddingValuesList) {
            float[] embeddingValues = new float[embeddingValuesList.size()];
            for (int i = 0; i < embeddingValuesList.size(); ++i) {
                embeddingValues[i] = embeddingValuesList.get(i).floatValue();
            }
            return new InferenceFloatEmbedding(embeddingValues);
        }

        @Override
        public int getSize() {
            return this.values.length;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeFloatArray(this.values);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(EMBEDDING);
            for (float value : this.values) {
                builder.value(value);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }

        private double[] asDoubleArray() {
            double[] doubles = new double[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                doubles[i] = this.values[i];
            }
            return doubles;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InferenceFloatEmbedding embedding = (InferenceFloatEmbedding)o;
            return Arrays.equals(this.values, embedding.values);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.values);
        }
    }
}

