/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.SparseEmbeddingResults;
import org.elasticsearch.xpack.core.inference.results.TextEmbeddingUtils;
import org.elasticsearch.xpack.core.ml.search.WeightedToken;

public record ChunkedInferenceEmbeddingSparse(List<SparseEmbeddingChunk> chunks) implements ChunkedInference
{
    public static List<ChunkedInference> listOf(List<String> inputs, SparseEmbeddingResults sparseEmbeddingResults) {
        TextEmbeddingUtils.validateInputSizeAgainstEmbeddings(inputs, sparseEmbeddingResults.embeddings().size());
        ArrayList<ChunkedInference> results = new ArrayList<ChunkedInference>(inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            results.add(new ChunkedInferenceEmbeddingSparse(List.of(new SparseEmbeddingChunk(sparseEmbeddingResults.embeddings().get(i).tokens(), inputs.get(i), new ChunkedInference.TextOffset(0, inputs.get(i).length())))));
        }
        return results;
    }

    @Override
    public Iterator<ChunkedInference.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) throws IOException {
        ArrayList<ChunkedInference.Chunk> asChunk = new ArrayList<ChunkedInference.Chunk>();
        for (SparseEmbeddingChunk chunk : this.chunks) {
            asChunk.add(new ChunkedInference.Chunk(chunk.matchedText(), chunk.offset(), ChunkedInferenceEmbeddingSparse.toBytesReference(xcontent, chunk.weightedTokens())));
        }
        return asChunk.iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, List<WeightedToken> tokens) throws IOException {
        XContentBuilder b = XContentBuilder.builder(xContent);
        b.startObject();
        for (WeightedToken weightedToken : tokens) {
            weightedToken.toXContent(b, ToXContent.EMPTY_PARAMS);
        }
        b.endObject();
        return BytesReference.bytes(b);
    }

    public record SparseEmbeddingChunk(List<WeightedToken> weightedTokens, String matchedText, ChunkedInference.TextOffset offset) {
    }
}

