/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.inference.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.inference.ChunkedInference;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;

public record ChunkedInferenceEmbeddingFloat(List<FloatEmbeddingChunk> chunks) implements ChunkedInference
{
    @Override
    public Iterator<ChunkedInference.Chunk> chunksAsMatchedTextAndByteReference(XContent xcontent) throws IOException {
        ArrayList<ChunkedInference.Chunk> asChunk = new ArrayList<ChunkedInference.Chunk>();
        for (FloatEmbeddingChunk chunk : this.chunks) {
            asChunk.add(new ChunkedInference.Chunk(chunk.matchedText(), chunk.offset(), ChunkedInferenceEmbeddingFloat.toBytesReference(xcontent, chunk.embedding())));
        }
        return asChunk.iterator();
    }

    private static BytesReference toBytesReference(XContent xContent, float[] value) throws IOException {
        XContentBuilder b = XContentBuilder.builder(xContent);
        b.startArray();
        for (float v : value) {
            b.value(v);
        }
        b.endArray();
        return BytesReference.bytes(b);
    }

    public record FloatEmbeddingChunk(float[] embedding, String matchedText, ChunkedInference.TextOffset offset) {
    }
}

