/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ItemUsage;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.template.resources.TemplateResources;

public class LifecyclePolicyUtils {
    private LifecyclePolicyUtils() {
    }

    public static LifecyclePolicy loadPolicy(String name, String resource, Map<String, String> variables, NamedXContentRegistry xContentRegistry) {
        try {
            String source = TemplateResources.load(resource);
            source = LifecyclePolicyUtils.replaceVariables(source, variables);
            LifecyclePolicyUtils.validate(source);
            return LifecyclePolicyUtils.parsePolicy(source, name, xContentRegistry, XContentType.JSON);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("unable to load policy [" + name + "] from [" + resource + "]", e);
        }
    }

    public static LifecyclePolicy parsePolicy(String rawPolicy, String name, NamedXContentRegistry xContentRegistry, XContentType contentType) throws IOException {
        try (XContentParser parser = contentType.xContent().createParser(XContentParserConfiguration.EMPTY.withRegistry(xContentRegistry), rawPolicy);){
            LifecyclePolicy policy = LifecyclePolicy.parse(parser, name);
            policy.validate();
            LifecyclePolicy lifecyclePolicy = policy;
            return lifecyclePolicy;
        }
    }

    private static String replaceVariables(String template, Map<String, String> variables) {
        for (Map.Entry<String, String> variable : variables.entrySet()) {
            template = LifecyclePolicyUtils.replaceVariable(template, variable.getKey(), variable.getValue());
        }
        return template;
    }

    public static String replaceVariable(String input, String variable, String value) {
        return input.replace("${" + variable + "}", value);
    }

    private static void validate(String source) {
        if (source == null) {
            throw new ElasticsearchParseException("policy must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap(new BytesArray(source), false, XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("policy must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("invalid policy", (Throwable)e, new Object[0]);
        }
    }

    public static ItemUsage calculateUsage(IndexNameExpressionResolver indexNameExpressionResolver, ClusterState state, String policyName) {
        List<String> indices = state.metadata().indices().values().stream().filter(indexMetadata -> policyName.equals(indexMetadata.getLifecyclePolicyName())).map(indexMetadata -> indexMetadata.getIndex().getName()).toList();
        List<String> allDataStreams = indexNameExpressionResolver.dataStreamNames(state, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED_HIDDEN_NO_SELECTOR, new String[0]);
        List<String> dataStreams = allDataStreams.stream().filter(dsName -> {
            String indexTemplate = MetadataIndexTemplateService.findV2Template(state.metadata(), dsName, false);
            if (indexTemplate != null) {
                Settings settings = MetadataIndexTemplateService.resolveSettings(state.metadata(), indexTemplate);
                return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
            }
            return false;
        }).toList();
        List<String> composableTemplates = state.metadata().templatesV2().keySet().stream().filter(templateName -> {
            Settings settings = MetadataIndexTemplateService.resolveSettings(state.metadata(), templateName);
            return policyName.equals(LifecycleSettings.LIFECYCLE_NAME_SETTING.get(settings));
        }).toList();
        return new ItemUsage(indices, dataStreams, composableTemplates);
    }
}

