/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.ProfileScorer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.elasticsearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final QueryProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, QueryProfileBreakdown profile) {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final Timer timer = this.profile.getNewTimer(QueryTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        ProfileWeight weight = this;
        return new ScorerSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    ProfileScorer profileScorer = new ProfileScorer(subQueryScorerSupplier.get(loadCost), ProfileWeight.this.profile);
                    return profileScorer;
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public BulkScorer bulkScorer() throws IOException {
                return super.bulkScorer();
            }

            @Override
            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public void setTopLevelScoringClause() throws IOException {
                subQueryScorerSupplier.setTopLevelScoringClause();
            }
        };
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(LeafReaderContext context) throws IOException {
        Timer timer = this.profile.getNewTimer(QueryTimingType.COUNT_WEIGHT);
        timer.start();
        try {
            int n = this.subQueryWeight.count(context);
            return n;
        }
        finally {
            timer.stop();
        }
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.matches(context, doc);
    }
}

