/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;

public class VariableWidthHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final VariableWidthHistogramAggregatorSupplier aggregatorSupplier;
    private final int numBuckets;
    private final int shardSize;
    private final int initialBuffer;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(VariableWidthHistogramAggregationBuilder.REGISTRY_KEY, List.of(CoreValuesSourceType.NUMERIC, TimeSeriesValuesSourceType.COUNTER), VariableWidthHistogramAggregator::new, true);
    }

    VariableWidthHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, int shardSize, int initialBuffer, AggregationContext context, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata, VariableWidthHistogramAggregatorSupplier aggregatorSupplier) throws IOException {
        super(name, config, context, parent, subFactoriesBuilder, metadata);
        this.aggregatorSupplier = aggregatorSupplier;
        this.numBuckets = numBuckets;
        this.shardSize = shardSize;
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected Aggregator doCreateInternal(Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new IllegalArgumentException("[variable_width_histogram] cannot be nested inside an aggregation that collects more than a single bucket.");
        }
        return this.aggregatorSupplier.build(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, this.context, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new VariableWidthHistogramAggregator(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, this.context, parent, metadata);
    }
}

