/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.jdk.JarHell;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class PluginDescriptor
implements Writeable,
ToXContentObject {
    public static final String INTERNAL_DESCRIPTOR_FILENAME = "plugin-descriptor.properties";
    public static final String STABLE_DESCRIPTOR_FILENAME = "stable-plugin-descriptor.properties";
    public static final String NAMED_COMPONENTS_FILENAME = "named_components.json";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private static final TransportVersion LICENSED_PLUGINS_SUPPORT = TransportVersions.V_7_11_0;
    private static final TransportVersion MODULE_NAME_SUPPORT = TransportVersions.V_8_3_0;
    private static final TransportVersion BOOTSTRAP_SUPPORT_REMOVED = TransportVersions.V_8_4_0;
    private final String name;
    private final String description;
    private final String version;
    private final String elasticsearchVersion;
    private final String javaVersion;
    private final String classname;
    private final String moduleName;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final boolean isLicensed;
    private final boolean isModular;
    private final boolean isStable;

    public PluginDescriptor(String name, String description, String version, String elasticsearchVersion, String javaVersion, String classname, String moduleName, List<String> extendedPlugins, boolean hasNativeController, boolean isLicensed, boolean isModular, boolean isStable) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.elasticsearchVersion = elasticsearchVersion;
        this.javaVersion = javaVersion;
        this.classname = classname;
        this.moduleName = moduleName;
        this.extendedPlugins = Collections.unmodifiableList(extendedPlugins);
        this.hasNativeController = hasNativeController;
        this.isLicensed = isLicensed;
        this.isModular = isModular;
        this.isStable = isStable;
        this.ensureCorrectArgumentsForPluginType();
    }

    public PluginDescriptor(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        this.elasticsearchVersion = in.getTransportVersion().before(TransportVersions.V_8_12_0) ? Version.readVersion(in).toString() : in.readString();
        this.javaVersion = in.readString();
        this.classname = in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0) ? in.readOptionalString() : in.readString();
        this.moduleName = in.getTransportVersion().onOrAfter(MODULE_NAME_SUPPORT) ? in.readOptionalString() : null;
        this.extendedPlugins = in.readStringCollectionAsList();
        this.hasNativeController = in.readBoolean();
        if (in.getTransportVersion().onOrAfter(LICENSED_PLUGINS_SUPPORT)) {
            if (in.getTransportVersion().before(BOOTSTRAP_SUPPORT_REMOVED)) {
                in.readString();
                in.readOptionalString();
            }
            this.isLicensed = in.readBoolean();
        } else {
            this.isLicensed = false;
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            this.isModular = in.readBoolean();
            this.isStable = in.readBoolean();
        } else {
            this.isModular = this.moduleName != null;
            this.isStable = false;
        }
        this.ensureCorrectArgumentsForPluginType();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        if (out.getTransportVersion().before(TransportVersions.V_8_12_0)) {
            Version.writeVersion(Version.fromString(this.elasticsearchVersion), out);
        } else {
            out.writeString(this.elasticsearchVersion);
        }
        out.writeString(this.javaVersion);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeOptionalString(this.classname);
        } else {
            out.writeString(this.classname);
        }
        if (out.getTransportVersion().onOrAfter(MODULE_NAME_SUPPORT)) {
            out.writeOptionalString(this.moduleName);
        }
        out.writeStringCollection(this.extendedPlugins);
        out.writeBoolean(this.hasNativeController);
        if (out.getTransportVersion().onOrAfter(LICENSED_PLUGINS_SUPPORT)) {
            if (out.getTransportVersion().before(BOOTSTRAP_SUPPORT_REMOVED)) {
                out.writeString("ISOLATED");
                out.writeOptionalString(null);
            }
            out.writeBoolean(this.isLicensed);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeBoolean(this.isModular);
            out.writeBoolean(this.isStable);
        }
    }

    private void ensureCorrectArgumentsForPluginType() {
        if (this.classname == null && !this.isStable) {
            throw new IllegalArgumentException("Classname must be provided for classic plugins");
        }
        if (this.classname != null && this.isStable) {
            throw new IllegalArgumentException("Classname is not needed for stable plugins");
        }
        if (this.moduleName != null && this.isStable) {
            throw new IllegalArgumentException("ModuleName is not needed for stable plugins");
        }
    }

    public static PluginDescriptor readFromProperties(Path pluginDir) throws IOException {
        BiFunction<Map, String, PluginDescriptor> reader;
        Path descriptorFile;
        Path internalDescriptorFile = pluginDir.resolve(INTERNAL_DESCRIPTOR_FILENAME);
        Path stableDescriptorFile = pluginDir.resolve(STABLE_DESCRIPTOR_FILENAME);
        boolean internalDescriptorExists = Files.exists(internalDescriptorFile, new LinkOption[0]);
        boolean stableDescriptorExists = Files.exists(stableDescriptorFile, new LinkOption[0]);
        String name = pluginDir.getFileName().toString();
        if (internalDescriptorExists && stableDescriptorExists) {
            throw new IllegalStateException("Plugin [" + name + "] has both stable and internal descriptor properties. Only one may exist.");
        }
        if (!internalDescriptorExists && !stableDescriptorExists) {
            throw new IllegalStateException("Plugin [" + name + "] is missing a descriptor properties file.");
        }
        if (internalDescriptorExists) {
            descriptorFile = internalDescriptorFile;
            reader = PluginDescriptor::readerInternalDescriptor;
        } else {
            descriptorFile = stableDescriptorFile;
            reader = PluginDescriptor::readerStableDescriptor;
        }
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptorFile, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        PluginDescriptor descriptor = reader.apply(propsMap, descriptorFile.getFileName().toString());
        name = descriptor.getName();
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties for plugin [" + name + "] in plugin descriptor: " + String.valueOf(propsMap.keySet()));
        }
        return descriptor;
    }

    private static PluginDescriptor readerInternalDescriptor(Map<String, String> propsMap, String filename) {
        String name = PluginDescriptor.readNonEmptyString(propsMap, filename, "name");
        String desc = PluginDescriptor.readString(propsMap, name, "description");
        String ver = PluginDescriptor.readString(propsMap, name, "version");
        String esVer = PluginDescriptor.readElasticsearchVersion(propsMap, name);
        String javaVer = PluginDescriptor.readJavaVersion(propsMap, name);
        String extendedString = propsMap.remove("extended.plugins");
        List<String> extended = List.of();
        if (extendedString != null) {
            extended = List.of(Strings.delimitedListToStringArray(extendedString, ","));
        }
        boolean nativeCont = PluginDescriptor.readBoolean(propsMap, name, "has.native.controller");
        String classname = PluginDescriptor.readNonEmptyString(propsMap, name, "classname");
        String module = propsMap.remove("modulename");
        if (module != null && module.isBlank()) {
            module = null;
        }
        boolean isLicensed = PluginDescriptor.readBoolean(propsMap, name, "licensed");
        boolean modular = module != null;
        return new PluginDescriptor(name, desc, ver, esVer, javaVer, classname, module, extended, nativeCont, isLicensed, modular, false);
    }

    private static PluginDescriptor readerStableDescriptor(Map<String, String> propsMap, String filename) {
        String name = PluginDescriptor.readNonEmptyString(propsMap, filename, "name");
        String desc = PluginDescriptor.readString(propsMap, name, "description");
        String ver = PluginDescriptor.readString(propsMap, name, "version");
        String esVer = PluginDescriptor.readElasticsearchVersion(propsMap, name);
        String javaVer = PluginDescriptor.readJavaVersion(propsMap, name);
        boolean isModular = PluginDescriptor.readBoolean(propsMap, name, "modular");
        return new PluginDescriptor(name, desc, ver, esVer, javaVer, null, null, List.of(), false, false, isModular, true);
    }

    private static String readNonEmptyString(Map<String, String> propsMap, String pluginId, String name) {
        String value = propsMap.remove(name);
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("property [" + name + "] is missing for plugin [" + pluginId + "]");
        }
        return value;
    }

    private static String readString(Map<String, String> propsMap, String pluginId, String name) {
        String value = propsMap.remove(name);
        if (value == null) {
            throw new IllegalArgumentException("property [" + name + "] is missing for plugin [" + pluginId + "]");
        }
        return value;
    }

    private static String readElasticsearchVersion(Map<String, String> propsMap, String pluginId) {
        return PluginDescriptor.readNonEmptyString(propsMap, pluginId, "elasticsearch.version");
    }

    private static String readJavaVersion(Map<String, String> propsMap, String pluginId) {
        String javaVersion = PluginDescriptor.readNonEmptyString(propsMap, pluginId, "java.version");
        JarHell.checkJavaVersion("plugin " + pluginId, javaVersion);
        return javaVersion;
    }

    private static boolean readBoolean(Map<String, String> propsMap, String pluginId, String name) {
        String rawValue = propsMap.remove(name);
        try {
            return Booleans.parseBoolean(rawValue, false);
        }
        catch (IllegalArgumentException e) {
            String message = String.format(Locale.ROOT, "property [%s] must be [true], [false], or unspecified but was [%s] for plugin [%s]", name, rawValue, pluginId);
            throw new IllegalArgumentException(message);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        if (this.isStable) {
            throw new IllegalStateException("Stable plugins do not have an explicit entry point");
        }
        return this.classname;
    }

    public Optional<String> getModuleName() {
        return Optional.ofNullable(this.moduleName);
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public String getVersion() {
        return this.version;
    }

    public String getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    public boolean isLicensed() {
        return this.isLicensed;
    }

    public boolean isModular() {
        return this.isModular;
    }

    public boolean isStable() {
        return this.isStable;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder, params);
        builder.endObject();
        return builder;
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("elasticsearch_version", this.elasticsearchVersion);
        builder.field("java_version", this.javaVersion);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("extended_plugins", (Collection<String>)this.extendedPlugins);
        builder.field("has_native_controller", this.hasNativeController);
        builder.field("licensed", this.isLicensed);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginDescriptor that = (PluginDescriptor)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        PluginDescriptor.appendLine(lines, prefix, "- Plugin information:", "");
        PluginDescriptor.appendLine(lines, prefix, "Name: ", this.name);
        PluginDescriptor.appendLine(lines, prefix, "Description: ", this.description);
        PluginDescriptor.appendLine(lines, prefix, "Version: ", this.version);
        PluginDescriptor.appendLine(lines, prefix, "Elasticsearch Version: ", this.elasticsearchVersion);
        PluginDescriptor.appendLine(lines, prefix, "Java Version: ", this.javaVersion);
        PluginDescriptor.appendLine(lines, prefix, "Native Controller: ", this.hasNativeController);
        PluginDescriptor.appendLine(lines, prefix, "Licensed: ", this.isLicensed);
        PluginDescriptor.appendLine(lines, prefix, "Extended Plugins: ", this.extendedPlugins.toString());
        PluginDescriptor.appendLine(lines, prefix, " * Classname: ", this.classname);
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    private static void appendLine(List<String> builder, String prefix, String field, Object value) {
        builder.add(prefix + field + String.valueOf(value));
    }
}

