/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.rest.RestStatus;

class HttpClient {
    private static final PasswordAuthentication NO_AUTH = new PasswordAuthentication("no_auth", "no_auth_unused".toCharArray());

    HttpClient() {
    }

    PasswordAuthentication auth(String username, String password) {
        return new PasswordAuthentication(username, password.toCharArray());
    }

    byte[] getBytes(String url) throws IOException {
        return this.getBytes(NO_AUTH, url);
    }

    byte[] getBytes(PasswordAuthentication auth, String url) throws IOException {
        return this.get(auth, url).readAllBytes();
    }

    InputStream get(String url) throws IOException {
        return this.get(NO_AUTH, url);
    }

    InputStream get(PasswordAuthentication auth, String url) throws IOException {
        Objects.requireNonNull(auth);
        Objects.requireNonNull(url);
        String originalAuthority = new URL(url).getAuthority();
        return HttpClient.doPrivileged(() -> {
            String innerUrl = url;
            HttpURLConnection conn = HttpClient.createConnection(auth, innerUrl);
            int redirectsCount = 0;
            block5: while (true) {
                switch (conn.getResponseCode()) {
                    case 200: {
                        return HttpClient.getInputStream(conn);
                    }
                    case 301: 
                    case 302: 
                    case 303: {
                        if (redirectsCount++ > 50) {
                            throw new IllegalStateException("too many redirects connection to [" + url + "]");
                        }
                        String location = conn.getHeaderField("Location");
                        URL base = new URL(innerUrl);
                        URL next = new URL(base, location);
                        innerUrl = next.toExternalForm();
                        String nextAuthority = next.getAuthority();
                        if (originalAuthority.equals(nextAuthority)) {
                            conn = HttpClient.createConnection(auth, innerUrl);
                            continue block5;
                        }
                        conn = HttpClient.createConnection(NO_AUTH, innerUrl);
                        continue block5;
                    }
                    case 404: {
                        throw new ResourceNotFoundException("{} not found", url);
                    }
                }
                break;
            }
            int responseCode = conn.getResponseCode();
            throw new ElasticsearchStatusException("error during downloading {}", RestStatus.fromCode(responseCode), url);
        });
    }

    @SuppressForbidden(reason="we need socket connection to download data from internet")
    private static InputStream getInputStream(HttpURLConnection conn) throws IOException {
        return conn.getInputStream();
    }

    private static HttpURLConnection createConnection(final PasswordAuthentication auth, String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        if (auth != NO_AUTH) {
            conn.setAuthenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return auth;
                }
            });
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setDoOutput(false);
        conn.setInstanceFollowRedirects(false);
        return conn;
    }

    private static <R> R doPrivileged(CheckedSupplier<R, IOException> supplier) throws IOException {
        SpecialPermission.check();
        try {
            return (R)AccessController.doPrivileged(supplier::get);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    static final class PasswordAuthenticationHolder
    implements AutoCloseable {
        private PasswordAuthentication auth;

        PasswordAuthenticationHolder(String username, char[] passwordChars) {
            this.auth = new PasswordAuthentication(username, passwordChars);
        }

        public PasswordAuthentication get() {
            Objects.requireNonNull(this.auth);
            return this.auth;
        }

        @Override
        public void close() {
            PasswordAuthentication clear = this.auth;
            this.auth = null;
            Arrays.fill(clear.getPassword(), '\u0000');
        }
    }
}

