/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.ingest.ConditionalProcessor;
import org.elasticsearch.ingest.OnFailureProcessor;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class ConfigurationUtils {
    public static final String TAG_KEY = "tag";
    public static final String DESCRIPTION_KEY = "description";
    public static final String[] VALID_MEDIA_TYPES = new String[]{"application/json", "text/plain", "application/x-www-form-urlencoded"};

    private ConfigurationUtils() {
    }

    public static String readOptionalStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        return ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, null);
    }

    public static String readStringProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readString(processorType, processorTag, propertyName, value);
    }

    private static String readString(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string, but of type [" + value.getClass().getName() + "]");
    }

    public static String readStringOrIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null && defaultValue != null) {
            return defaultValue;
        }
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readStringOrInt(processorType, processorTag, propertyName, value);
    }

    private static String readStringOrInt(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return String.valueOf(integer);
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string or int, but of type [" + value.getClass().getName() + "]");
    }

    public static String readOptionalStringOrIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readStringOrInt(processorType, processorTag, propertyName, value);
    }

    private static String readStringOrLong(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value instanceof Long || value instanceof Integer) {
            return String.valueOf(value);
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a string or long, but of type [" + value.getClass().getName() + "]");
    }

    public static String readOptionalStringOrLongProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readStringOrLong(processorType, processorTag, propertyName, value);
    }

    public static Boolean readBooleanProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, boolean defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        return (boolean)ConfigurationUtils.readBoolean(processorType, processorTag, propertyName, value);
    }

    @Nullable
    public static Boolean readOptionalBooleanProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        return ConfigurationUtils.readBoolean(processorType, processorTag, propertyName, value);
    }

    private static Boolean readBoolean(String processorType, String processorTag, String propertyName, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, Strings.format("property isn't a boolean, but of type [%s]", value.getClass().getName()));
    }

    public static Integer readIntProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, Integer defaultValue) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to an int [" + value.toString() + "]");
        }
    }

    public static Double readDoubleProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property cannot be converted to a double [" + value.toString() + "]");
        }
    }

    public static <T> List<T> readOptionalList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    public static List<String> readOptionalListOrString(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return List.of();
        }
        if (value instanceof String) {
            return List.of(ConfigurationUtils.readString(processorType, processorTag, propertyName, value));
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    public static <T> List<T> readList(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readList(processorType, processorTag, propertyName, value);
    }

    private static <T> List<T> readList(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof List) {
            List stringList = (List)value;
            return stringList;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a list, but of type [" + value.getClass().getName() + "]");
    }

    public static <T> Map<String, T> readMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    public static <T> Map<String, T> readOptionalMap(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            return null;
        }
        return ConfigurationUtils.readMap(processorType, processorTag, propertyName, value);
    }

    private static <T> Map<String, T> readMap(String processorType, String processorTag, String propertyName, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            return map;
        }
        throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property isn't a map, but of type [" + value.getClass().getName() + "]");
    }

    public static Object readObject(String processorType, String processorTag, Map<String, Object> configuration, String propertyName) {
        Object value = configuration.remove(propertyName);
        if (value == null) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "required property is missing");
        }
        return value;
    }

    public static String readMediaTypeProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, String defaultValue) {
        String mediaType = ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, defaultValue);
        if (!List.of(VALID_MEDIA_TYPES).contains(mediaType)) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, "property does not contain a supported media type [" + mediaType + "]");
        }
        return mediaType;
    }

    public static ElasticsearchException newConfigurationException(String processorType, String processorTag, String propertyName, String reason) {
        Object msg = propertyName == null ? reason : "[" + propertyName + "] " + reason;
        ElasticsearchParseException exception = new ElasticsearchParseException((String)msg, new Object[0]);
        ConfigurationUtils.addMetadataToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static ElasticsearchException newConfigurationException(String processorType, String processorTag, String propertyName, Exception cause) {
        ElasticsearchException exception = ExceptionsHelper.convertToElastic(cause);
        ConfigurationUtils.addMetadataToException(exception, processorType, processorTag, propertyName);
        return exception;
    }

    public static List<Processor> readProcessorConfigs(List<Map<String, Object>> processorConfigs, ScriptService scriptService, Map<String, Processor.Factory> processorFactories) throws Exception {
        Exception exception = null;
        ArrayList<Processor> processors = new ArrayList<Processor>();
        if (processorConfigs != null) {
            for (Map<String, Object> processorConfigWithKey : processorConfigs) {
                for (Map.Entry<String, Object> entry : processorConfigWithKey.entrySet()) {
                    try {
                        if (entry.getValue() == null) {
                            throw ConfigurationUtils.newConfigurationException(entry.getKey(), null, null, "processor config cannot be [null]");
                        }
                        processors.add(ConfigurationUtils.readProcessor(processorFactories, scriptService, entry.getKey(), entry.getValue()));
                    }
                    catch (Exception e) {
                        exception = ExceptionsHelper.useOrSuppress(exception, e);
                    }
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        return Collections.unmodifiableList(processors);
    }

    public static TemplateScript.Factory readTemplateProperty(String processorType, String processorTag, Map<String, Object> configuration, String propertyName, ScriptService scriptService) {
        String value = ConfigurationUtils.readStringProperty(processorType, processorTag, configuration, propertyName, null);
        return ConfigurationUtils.compileTemplate(processorType, processorTag, propertyName, value, scriptService);
    }

    public static TemplateScript.Factory compileTemplate(String processorType, String processorTag, String propertyName, String propertyValue, ScriptService scriptService) {
        try {
            if (scriptService.isLangSupported("mustache") && propertyValue.contains("{{")) {
                Script script = new Script(ScriptType.INLINE, "mustache", propertyValue, Map.of());
                return scriptService.compile(script, TemplateScript.CONTEXT);
            }
            return new ConstantTemplateScriptFactory(propertyValue);
        }
        catch (Exception e) {
            throw ConfigurationUtils.newConfigurationException(processorType, processorTag, propertyName, e);
        }
    }

    private static void addMetadataToException(ElasticsearchException exception, String processorType, String processorTag, String propertyName) {
        if (processorType != null) {
            exception.addMetadata("es.processor_type", processorType);
        }
        if (processorTag != null) {
            exception.addMetadata("es.processor_tag", processorTag);
        }
        if (propertyName != null) {
            exception.addMetadata("es.property_name", propertyName);
        }
    }

    public static Processor readProcessor(Map<String, Processor.Factory> processorFactories, ScriptService scriptService, String type, Object config) throws Exception {
        if (config instanceof Map) {
            return ConfigurationUtils.readProcessor(processorFactories, scriptService, type, (Map)config);
        }
        if (config instanceof String && "script".equals(type)) {
            Map<String, Object> normalizedScript = Maps.newMapWithExpectedSize(1);
            normalizedScript.put(ScriptType.INLINE.getParseField().getPreferredName(), config);
            return ConfigurationUtils.readProcessor(processorFactories, scriptService, type, normalizedScript);
        }
        throw ConfigurationUtils.newConfigurationException(type, null, null, "property isn't a map, but of type [" + config.getClass().getName() + "]");
    }

    public static Processor readProcessor(Map<String, Processor.Factory> processorFactories, ScriptService scriptService, String type, Map<String, Object> config) throws Exception {
        String tag = ConfigurationUtils.readOptionalStringProperty(null, null, config, TAG_KEY);
        String description = ConfigurationUtils.readOptionalStringProperty(null, tag, config, DESCRIPTION_KEY);
        Script conditionalScript = ConfigurationUtils.extractConditional(config);
        Processor.Factory factory = processorFactories.get(type);
        if (factory != null) {
            boolean ignoreFailure = ConfigurationUtils.readBooleanProperty(null, null, config, "ignore_failure", false);
            List<Map<String, Object>> onFailureProcessorConfigs = ConfigurationUtils.readOptionalList(null, null, config, "on_failure");
            List<Processor> onFailureProcessors = ConfigurationUtils.readProcessorConfigs(onFailureProcessorConfigs, scriptService, processorFactories);
            if (onFailureProcessorConfigs != null && onFailureProcessors.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException(type, tag, "on_failure", "processors list cannot be empty");
            }
            try {
                Processor processor = factory.create(processorFactories, tag, description, config);
                if (!config.isEmpty()) {
                    throw new ElasticsearchParseException("processor [{}] doesn't support one or more provided configuration parameters {}", type, Arrays.toString(config.keySet().toArray()));
                }
                if (onFailureProcessors.size() > 0 || ignoreFailure) {
                    processor = new OnFailureProcessor(ignoreFailure, processor, onFailureProcessors);
                }
                if (conditionalScript != null) {
                    processor = new ConditionalProcessor(tag, description, conditionalScript, scriptService, processor);
                }
                return processor;
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException(type, tag, null, e);
            }
        }
        throw ConfigurationUtils.newConfigurationException(type, tag, null, "No processor type exists with name [" + type + "]");
    }

    private static Script extractConditional(Map<String, Object> config) throws IOException {
        Object scriptSource = config.remove("if");
        if (scriptSource != null) {
            try (XContentBuilder builder = XContentBuilder.builder(JsonXContent.jsonXContent).map(ConfigurationUtils.normalizeScript(scriptSource));){
                Script script;
                block13: {
                    XContentParser parser = XContentHelper.createParserNotCompressed(LoggingDeprecationHandler.XCONTENT_PARSER_CONFIG, BytesReference.bytes(builder), XContentType.JSON);
                    try {
                        script = Script.parse(parser);
                        if (parser == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return script;
            }
        }
        return null;
    }

    private static Map<String, Object> normalizeScript(Object scriptConfig) {
        if (scriptConfig instanceof Map) {
            return (Map)scriptConfig;
        }
        if (scriptConfig instanceof String) {
            return Map.of("source", scriptConfig);
        }
        throw ConfigurationUtils.newConfigurationException("conditional", null, "script", "property isn't a map or string, but of type [" + scriptConfig.getClass().getName() + "]");
    }

    public static class ConstantTemplateScriptFactory
    implements TemplateScript.Factory {
        final TemplateScript script;

        private ConstantTemplateScriptFactory(final String value) {
            this.script = new TemplateScript(this, Map.of()){

                @Override
                public String execute() {
                    return value;
                }
            };
        }

        @Override
        public TemplateScript newInstance(Map<String, Object> params) {
            return this.script;
        }
    }
}

