/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.sandbox.search.CombinedFieldQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.QueryBuilder;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.query.ZeroTermsQueryOption;
import org.elasticsearch.index.search.QueryParserHelper;
import org.elasticsearch.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.elasticsearch.lucene.similarity.LegacyBM25Similarity;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class CombinedFieldsQueryBuilder
extends AbstractQueryBuilder<CombinedFieldsQueryBuilder> {
    public static final String NAME = "combined_fields";
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);
    private static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField GENERATE_SYNONYMS_PHRASE_QUERY = new ParseField("auto_generate_synonyms_phrase_query", new String[0]);
    private static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    private static final Operator DEFAULT_OPERATOR = Operator.OR;
    private static final ZeroTermsQueryOption DEFAULT_ZERO_TERMS_QUERY = ZeroTermsQueryOption.NONE;
    private static final boolean DEFAULT_GENERATE_SYNONYMS_PHRASE = true;
    private final Object value;
    private final Map<String, Float> fieldsAndBoosts;
    private Operator operator = DEFAULT_OPERATOR;
    private String minimumShouldMatch;
    private ZeroTermsQueryOption zeroTermsQuery = DEFAULT_ZERO_TERMS_QUERY;
    private boolean autoGenerateSynonymsPhraseQuery = true;
    private static final ConstructingObjectParser<CombinedFieldsQueryBuilder, Void> PARSER = new ConstructingObjectParser("combined_fields", a -> new CombinedFieldsQueryBuilder(a[0], new String[0]));

    public CombinedFieldsQueryBuilder(Object value, String ... fields) {
        if (value == null) {
            throw new IllegalArgumentException("[combined_fields] requires query value");
        }
        if (fields == null) {
            throw new IllegalArgumentException("[combined_fields] requires field list");
        }
        this.value = value;
        this.fieldsAndBoosts = new TreeMap<String, Float>();
        for (String field : fields) {
            this.field(field);
        }
    }

    public CombinedFieldsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.value = in.readGenericValue();
        int size = in.readVInt();
        this.fieldsAndBoosts = new TreeMap<String, Float>();
        for (int i = 0; i < size; ++i) {
            String field = in.readString();
            float boost = in.readFloat();
            this.fieldsAndBoosts.put(field, Float.valueOf(boost));
        }
        this.operator = Operator.readFromStream(in);
        this.minimumShouldMatch = in.readOptionalString();
        this.zeroTermsQuery = ZeroTermsQueryOption.readFromStream(in);
        this.autoGenerateSynonymsPhraseQuery = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.value);
        out.writeVInt(this.fieldsAndBoosts.size());
        for (Map.Entry<String, Float> fieldsEntry : this.fieldsAndBoosts.entrySet()) {
            out.writeString(fieldsEntry.getKey());
            out.writeFloat(fieldsEntry.getValue().floatValue());
        }
        this.operator.writeTo(out);
        out.writeOptionalString(this.minimumShouldMatch);
        this.zeroTermsQuery.writeTo(out);
        out.writeBoolean(this.autoGenerateSynonymsPhraseQuery);
    }

    public Object value() {
        return this.value;
    }

    public CombinedFieldsQueryBuilder field(String field) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty.");
        }
        this.fieldsAndBoosts.put(field, Float.valueOf(1.0f));
        return this;
    }

    public CombinedFieldsQueryBuilder field(String field, float boost) {
        if (Strings.isEmpty(field)) {
            throw new IllegalArgumentException("supplied field is null or empty.");
        }
        CombinedFieldsQueryBuilder.validateFieldBoost(boost);
        this.fieldsAndBoosts.put(field, Float.valueOf(boost));
        return this;
    }

    public CombinedFieldsQueryBuilder fields(Map<String, Float> fields) {
        for (float fieldBoost : fields.values()) {
            CombinedFieldsQueryBuilder.validateFieldBoost(fieldBoost);
        }
        this.fieldsAndBoosts.putAll(fields);
        return this;
    }

    public Map<String, Float> fields() {
        return this.fieldsAndBoosts;
    }

    public CombinedFieldsQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[combined_fields] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public CombinedFieldsQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public CombinedFieldsQueryBuilder zeroTermsQuery(ZeroTermsQueryOption zeroTermsQuery) {
        if (zeroTermsQuery == null) {
            throw new IllegalArgumentException("[combined_fields] requires zero terms query to be non-null");
        }
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public CombinedFieldsQueryBuilder autoGenerateSynonymsPhraseQuery(boolean enable) {
        this.autoGenerateSynonymsPhraseQuery = enable;
        return this;
    }

    private static void validateFieldBoost(float boost) {
        if (boost < 1.0f) {
            throw new IllegalArgumentException("[combined_fields] requires field boosts to be >= 1.0");
        }
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName(), this.value);
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry<String, Float> fieldEntry : this.fieldsAndBoosts.entrySet()) {
            builder.value(fieldEntry.getKey() + "^" + String.valueOf(fieldEntry.getValue()));
        }
        builder.endArray();
        if (this.operator != DEFAULT_OPERATOR) {
            builder.field(OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.zeroTermsQuery != DEFAULT_ZERO_TERMS_QUERY) {
            builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery.toString());
        }
        if (!this.autoGenerateSynonymsPhraseQuery) {
            builder.field(GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), this.autoGenerateSynonymsPhraseQuery);
        }
        this.boostAndQueryNameToXContent(builder);
        builder.endObject();
    }

    public static CombinedFieldsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(SearchExecutionContext context) throws IOException {
        if (this.fieldsAndBoosts.isEmpty()) {
            throw new IllegalArgumentException("In [combined_fields] query, at least one field must be provided");
        }
        Map<String, Float> fields = QueryParserHelper.resolveMappingFields(context, this.fieldsAndBoosts);
        boolean hasMappedField = fields.keySet().stream().anyMatch(k -> context.getFieldType((String)k) != null);
        if (!hasMappedField) {
            return Queries.newUnmappedFieldsQuery(fields.keySet());
        }
        CombinedFieldsQueryBuilder.validateSimilarity(context, fields);
        NamedAnalyzer sharedAnalyzer = null;
        ArrayList<FieldAndBoost> fieldsAndBoosts = new ArrayList<FieldAndBoost>();
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            String name = entry.getKey();
            MappedFieldType fieldType = context.getFieldType(name);
            if (fieldType == null) continue;
            if (!fieldType.familyTypeName().equals("text")) {
                throw new IllegalArgumentException("Field [" + fieldType.name() + "] of type [" + fieldType.typeName() + "] does not support [combined_fields] queries");
            }
            float boost = entry.getValue() == null ? 1.0f : entry.getValue().floatValue();
            fieldsAndBoosts.add(new FieldAndBoost(fieldType, boost));
            NamedAnalyzer analyzer = fieldType.getTextSearchInfo().searchAnalyzer();
            if (sharedAnalyzer != null && !((Object)analyzer).equals(sharedAnalyzer)) {
                throw new IllegalArgumentException("All fields in [combined_fields] query must have the same search analyzer");
            }
            sharedAnalyzer = analyzer;
        }
        assert (!fieldsAndBoosts.isEmpty());
        String placeholderFieldName = ((FieldAndBoost)fieldsAndBoosts.get((int)0)).fieldType.name();
        boolean canGenerateSynonymsPhraseQuery = this.autoGenerateSynonymsPhraseQuery;
        for (FieldAndBoost fieldAndBoost : fieldsAndBoosts) {
            TextSearchInfo textSearchInfo = fieldAndBoost.fieldType.getTextSearchInfo();
            canGenerateSynonymsPhraseQuery &= textSearchInfo.hasPositions();
        }
        CombinedFieldsBuilder builder = new CombinedFieldsBuilder(fieldsAndBoosts, sharedAnalyzer, canGenerateSynonymsPhraseQuery, context);
        Query query = builder.createBooleanQuery(placeholderFieldName, this.value.toString(), this.operator.toBooleanClauseOccur());
        if ((query = Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch)) == null) {
            query = this.zeroTermsQuery.asQuery();
        }
        return query;
    }

    private static void validateSimilarity(SearchExecutionContext context, Map<String, Float> fields) {
        for (Map.Entry<String, Float> entry : fields.entrySet()) {
            String name = entry.getKey();
            MappedFieldType fieldType = context.getFieldType(name);
            if (fieldType == null || fieldType.getTextSearchInfo().similarity() == null) continue;
            throw new IllegalArgumentException("[combined_fields] queries cannot be used with per-field similarities");
        }
        Similarity defaultSimilarity = context.getDefaultSimilarity();
        if (!(defaultSimilarity instanceof LegacyBM25Similarity || defaultSimilarity instanceof BM25Similarity)) {
            throw new IllegalArgumentException("[combined_fields] queries can only be used with the [BM25] similarity");
        }
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.value, this.fieldsAndBoosts, this.operator, this.minimumShouldMatch, this.zeroTermsQuery, this.autoGenerateSynonymsPhraseQuery);
    }

    @Override
    protected boolean doEquals(CombinedFieldsQueryBuilder other) {
        return Objects.equals(this.value, other.value) && Objects.equals(this.fieldsAndBoosts, other.fieldsAndBoosts) && Objects.equals(this.operator, other.operator) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery);
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_7_13_0;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        PARSER.declareStringArray((builder, values) -> {
            Map<String, Float> fieldsAndBoosts = QueryParserHelper.parseFieldsAndWeights(values);
            builder.fields(fieldsAndBoosts);
        }, FIELDS_FIELD);
        PARSER.declareString(CombinedFieldsQueryBuilder::operator, Operator::fromString, OPERATOR_FIELD);
        PARSER.declareField(CombinedFieldsQueryBuilder::minimumShouldMatch, XContentParser::textOrNull, MINIMUM_SHOULD_MATCH_FIELD, ObjectParser.ValueType.INT_OR_NULL);
        PARSER.declareBoolean(CombinedFieldsQueryBuilder::autoGenerateSynonymsPhraseQuery, GENERATE_SYNONYMS_PHRASE_QUERY);
        PARSER.declareString(CombinedFieldsQueryBuilder::zeroTermsQuery, value -> {
            if ("none".equalsIgnoreCase((String)value)) {
                return ZeroTermsQueryOption.NONE;
            }
            if ("all".equalsIgnoreCase((String)value)) {
                return ZeroTermsQueryOption.ALL;
            }
            throw new IllegalArgumentException("Unsupported [" + ZERO_TERMS_QUERY_FIELD.getPreferredName() + "] value [" + value + "]");
        }, ZERO_TERMS_QUERY_FIELD);
        PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
        PARSER.declareString(AbstractQueryBuilder::queryName, NAME_FIELD);
    }

    private static final class FieldAndBoost {
        final MappedFieldType fieldType;
        final float boost;

        FieldAndBoost(MappedFieldType fieldType, float boost) {
            this.fieldType = Objects.requireNonNull(fieldType);
            this.boost = boost;
        }
    }

    private static class CombinedFieldsBuilder
    extends QueryBuilder {
        private final List<FieldAndBoost> fields;
        private final SearchExecutionContext context;

        CombinedFieldsBuilder(List<FieldAndBoost> fields, Analyzer analyzer, boolean autoGenerateSynonymsPhraseQuery, SearchExecutionContext context) {
            super(analyzer);
            this.fields = fields;
            this.setAutoGenerateMultiTermSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Query createFieldQuery(TokenStream source, BooleanClause.Occur operator, String field, boolean quoted, int phraseSlop) {
            if (source.hasAttribute(DisableGraphAttribute.class)) {
                this.setEnableGraphQueries(false);
            }
            try {
                Query query = super.createFieldQuery(source, operator, field, quoted, phraseSlop);
                return query;
            }
            finally {
                this.setEnableGraphQueries(true);
            }
        }

        @Override
        public Query createPhraseQuery(String field, String queryText, int phraseSlop) {
            throw new IllegalArgumentException("[combined_fields] queries don't support phrases");
        }

        @Override
        protected Query newSynonymQuery(String field, QueryBuilder.TermAndBoost[] terms) {
            CombinedFieldQuery.Builder query = new CombinedFieldQuery.Builder();
            for (QueryBuilder.TermAndBoost termAndBoost : terms) {
                assert (termAndBoost.boost() == 1.0f);
                BytesRef bytes = termAndBoost.term();
                query.addTerm(bytes);
            }
            for (FieldAndBoost fieldAndBoost : this.fields) {
                MappedFieldType fieldType = fieldAndBoost.fieldType;
                float fieldBoost = fieldAndBoost.boost;
                query.addField(fieldType.name(), fieldBoost);
            }
            return query.build();
        }

        @Override
        protected Query newTermQuery(Term term, float boost) {
            QueryBuilder.TermAndBoost termAndBoost = new QueryBuilder.TermAndBoost(term.bytes(), boost);
            return this.newSynonymQuery(term.field(), new QueryBuilder.TermAndBoost[]{termAndBoost});
        }

        @Override
        protected Query analyzePhrase(String field, TokenStream stream, int slop) throws IOException {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (FieldAndBoost fieldAndBoost : this.fields) {
                Query query = fieldAndBoost.fieldType.phraseQuery(stream, slop, this.enablePositionIncrements, this.context);
                if (fieldAndBoost.boost != 1.0f) {
                    query = new BoostQuery(query, fieldAndBoost.boost);
                }
                builder.add(query, BooleanClause.Occur.SHOULD);
            }
            return builder.build();
        }
    }
}

