/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.vectors;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.KnnByteVectorField;
import org.apache.lucene.document.KnnFloatVectorField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.codec.vectors.ES813FlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES813Int8FlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES814HnswScalarQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.ES815BitFlatVectorFormat;
import org.elasticsearch.index.codec.vectors.ES815HnswBitVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.ES818HnswBinaryQuantizedVectorsFormat;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.ArraySourceValueFetcher;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParser;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.vectors.DenormalizedCosineFloatVectorValues;
import org.elasticsearch.index.mapper.vectors.VectorIndexFieldData;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.vectors.DenseVectorQuery;
import org.elasticsearch.search.vectors.ESDiversifyingChildrenByteKnnVectorQuery;
import org.elasticsearch.search.vectors.ESDiversifyingChildrenFloatKnnVectorQuery;
import org.elasticsearch.search.vectors.ESKnnByteVectorQuery;
import org.elasticsearch.search.vectors.ESKnnFloatVectorQuery;
import org.elasticsearch.search.vectors.QueryProfilerProvider;
import org.elasticsearch.search.vectors.RescoreKnnVectorQuery;
import org.elasticsearch.search.vectors.VectorData;
import org.elasticsearch.search.vectors.VectorSimilarityQuery;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DenseVectorFieldMapper
extends FieldMapper {
    public static final String COSINE_MAGNITUDE_FIELD_SUFFIX = "._magnitude";
    private static final float EPS = 0.001f;
    public static final int BBQ_MIN_DIMS = 64;
    public static final IndexVersion MAGNITUDE_STORED_INDEX_VERSION = IndexVersions.V_7_5_0;
    public static final IndexVersion INDEXED_BY_DEFAULT_INDEX_VERSION = IndexVersions.FIRST_DETACHED_INDEX_VERSION;
    public static final IndexVersion NORMALIZE_COSINE = IndexVersions.NORMALIZED_VECTOR_COSINE;
    public static final IndexVersion DEFAULT_TO_INT8 = IndexVersions.DEFAULT_DENSE_VECTOR_TO_INT8_HNSW;
    public static final IndexVersion LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION = IndexVersions.V_8_9_0;
    public static final String CONTENT_TYPE = "dense_vector";
    public static final short MAX_DIMS_COUNT = 4096;
    public static final int MAX_DIMS_COUNT_BIT = 32768;
    public static final short MIN_DIMS_FOR_DYNAMIC_FLOAT_MAPPING = 128;
    public static final int MAGNITUDE_BYTES = 4;
    public static final int OVERSAMPLE_LIMIT = 10000;
    public static final Map<String, ElementType> namesToElementType = Map.of(ElementType.BYTE.toString(), ElementType.BYTE, ElementType.FLOAT.toString(), ElementType.FLOAT, ElementType.BIT.toString(), ElementType.BIT);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated()), DenseVectorFieldMapper.notInMultiFields("dense_vector"));
    private final IndexOptions indexOptions;
    private final IndexVersion indexCreatedVersion;

    public static boolean isNotUnitVector(float magnitude) {
        return Math.abs(magnitude - 1.0f) > 0.001f;
    }

    private static DenseVectorFieldMapper toType(FieldMapper in) {
        return (DenseVectorFieldMapper)in;
    }

    private DenseVectorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams params, IndexOptions indexOptions, IndexVersion indexCreatedVersion) {
        super(simpleName, mappedFieldType, params);
        this.indexOptions = indexOptions;
        this.indexCreatedVersion = indexCreatedVersion;
    }

    @Override
    public DenseVectorFieldType fieldType() {
        return (DenseVectorFieldType)super.fieldType();
    }

    @Override
    public boolean parsesArrayValue() {
        return true;
    }

    @Override
    public void parse(DocumentParserContext context) throws IOException {
        if (context.doc().getByKey(this.fieldType().name()) != null) {
            throw new IllegalArgumentException("Field [" + this.fullPath() + "] of type [" + this.typeName() + "] doesn't support indexing multiple values for the same field in the same document");
        }
        if (XContentParser.Token.VALUE_NULL == context.parser().currentToken()) {
            return;
        }
        if (this.fieldType().dims == null) {
            int dims = this.fieldType().elementType.parseDimensionCount(context);
            if (this.fieldType().indexOptions != null) {
                this.fieldType().indexOptions.validateDimension(dims);
            }
            DenseVectorFieldType updatedDenseVectorFieldType = new DenseVectorFieldType(this.fieldType().name(), this.indexCreatedVersion, this.fieldType().elementType, dims, this.fieldType().indexed, this.fieldType().similarity, this.fieldType().indexOptions, this.fieldType().meta());
            DenseVectorFieldMapper update = new DenseVectorFieldMapper(this.leafName(), updatedDenseVectorFieldType, this.builderParams, this.indexOptions, this.indexCreatedVersion);
            context.addDynamicMapper(update);
            return;
        }
        if (this.fieldType().indexed) {
            this.parseKnnVectorAndIndex(context);
        } else {
            this.parseBinaryDocValuesVectorAndIndex(context);
        }
    }

    private void parseKnnVectorAndIndex(DocumentParserContext context) throws IOException {
        this.fieldType().elementType.parseKnnVectorAndIndex(context, this);
    }

    private void parseBinaryDocValuesVectorAndIndex(DocumentParserContext context) throws IOException {
        int dims = this.fieldType().dims;
        ElementType elementType = this.fieldType().elementType;
        int numBytes = this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION) ? elementType.getNumBytes(dims) + 4 : elementType.getNumBytes(dims);
        ByteBuffer byteBuffer = elementType.createByteBuffer(this.indexCreatedVersion, numBytes);
        VectorData vectorData = elementType.parseKnnVector(context, dims, (i, b) -> {
            if (b) {
                this.checkDimensionMatches(i, context);
            } else {
                this.checkDimensionExceeded(i, context);
            }
        }, this.fieldType().similarity);
        vectorData.addToBuffer(byteBuffer);
        if (this.indexCreatedVersion.onOrAfter(MAGNITUDE_STORED_INDEX_VERSION)) {
            double dotProduct = elementType.computeSquaredMagnitude(vectorData);
            float vectorMagnitude = (float)Math.sqrt(dotProduct);
            byteBuffer.putFloat(vectorMagnitude);
        }
        BinaryDocValuesField field = new BinaryDocValuesField(this.fieldType().name(), new BytesRef(byteBuffer.array()));
        context.doc().addWithKey(this.fieldType().name(), field);
    }

    private void checkDimensionExceeded(int index, DocumentParserContext context) {
        if (index >= this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has more dimensions than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    private void checkDimensionMatches(int index, DocumentParserContext context) {
        if (index != this.fieldType().dims) {
            throw new IllegalArgumentException("The [" + this.typeName() + "] field [" + this.fullPath() + "] in doc [" + context.documentDescription() + "] has a different number of dimensions [" + index + "] than defined in the mapping [" + this.fieldType().dims + "]");
        }
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) {
        throw new AssertionError((Object)"parse is implemented directly");
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion).init(this);
    }

    private static IndexOptions parseIndexOptions(String fieldName, Object propNode) {
        Map indexOptionsMap = (Map)propNode;
        Object typeNode = indexOptionsMap.remove("type");
        if (typeNode == null) {
            throw new MapperParsingException("[index_options] requires field [type] to be configured");
        }
        String type = XContentMapValues.nodeStringValue(typeNode);
        Optional<VectorIndexType> vectorIndexType = VectorIndexType.fromString(type);
        if (vectorIndexType.isEmpty()) {
            throw new MapperParsingException("Unknown vector index options type [" + type + "] for field [" + fieldName + "]");
        }
        VectorIndexType parsedType = vectorIndexType.get();
        return parsedType.parseIndexOptions(fieldName, indexOptionsMap);
    }

    public KnnVectorsFormat getKnnVectorsFormatForField(KnnVectorsFormat defaultFormat) {
        final KnnVectorsFormat format = this.indexOptions == null ? (this.fieldType().elementType == ElementType.BIT ? new ES815HnswBitVectorsFormat() : defaultFormat) : this.indexOptions.getVectorsFormat(this.fieldType().elementType);
        return new KnnVectorsFormat(this, format.getName()){

            @Override
            public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
                return format.fieldsWriter(state);
            }

            @Override
            public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
                return format.fieldsReader(state);
            }

            @Override
            public int getMaxDimensions(String fieldName) {
                return 4096;
            }

            public String toString() {
                return format.toString();
            }
        };
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        return new FieldMapper.SyntheticSourceSupport.Native(() -> this.fieldType().indexed ? new IndexedSyntheticFieldLoader(this.indexCreatedVersion, this.fieldType().similarity) : new DocValuesSyntheticFieldLoader(this.indexCreatedVersion));
    }

    static abstract class IndexOptions
    implements ToXContent {
        final VectorIndexType type;

        IndexOptions(VectorIndexType type) {
            this.type = type;
        }

        abstract KnnVectorsFormat getVectorsFormat(ElementType var1);

        final void validateElementType(ElementType elementType) {
            if (!this.type.supportsElementType(elementType)) {
                throw new IllegalArgumentException("[element_type] cannot be [" + elementType.toString() + "] when using index type [" + String.valueOf((Object)this.type) + "]");
            }
        }

        abstract boolean updatableTo(IndexOptions var1);

        public void validateDimension(int dim) {
            if (this.type.supportsDimension(dim)) {
                return;
            }
            throw new IllegalArgumentException(this.type.name + " only supports even dimensions; provided=" + dim);
        }

        abstract boolean doEquals(IndexOptions var1);

        abstract int doHashCode();

        public final boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            IndexOptions otherOptions = (IndexOptions)other;
            return Objects.equals((Object)this.type, (Object)otherOptions.type) && this.doEquals(otherOptions);
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.type, this.doHashCode()});
        }
    }

    public static final class DenseVectorFieldType
    extends SimpleMappedFieldType {
        private final ElementType elementType;
        private final Integer dims;
        private final boolean indexed;
        private final VectorSimilarity similarity;
        private final IndexVersion indexVersionCreated;
        private final IndexOptions indexOptions;

        public DenseVectorFieldType(String name, IndexVersion indexVersionCreated, ElementType elementType, Integer dims, boolean indexed, VectorSimilarity similarity, IndexOptions indexOptions, Map<String, String> meta) {
            super(name, indexed, false, !indexed, TextSearchInfo.NONE, meta);
            this.elementType = elementType;
            this.dims = dims;
            this.indexed = indexed;
            this.similarity = similarity;
            this.indexVersionCreated = indexVersionCreated;
            this.indexOptions = indexOptions;
        }

        @Override
        public String typeName() {
            return DenseVectorFieldMapper.CONTENT_TYPE;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            return new ArraySourceValueFetcher(this, this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    return value;
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            return DocValueFormat.DENSE_VECTOR;
        }

        @Override
        public boolean isAggregatable() {
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            return this.elementType.fielddataBuilder(this, fieldDataContext);
        }

        @Override
        public Query existsQuery(SearchExecutionContext context) {
            return new FieldExistsQuery(this.name());
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support term queries");
        }

        public Query createExactKnnQuery(VectorData queryVector, Float vectorSimilarity) {
            Query knnQuery;
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            switch (this.elementType.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Query query = this.createExactKnnByteQuery(queryVector.asByteVector());
                    break;
                }
                case 1: {
                    Query query = this.createExactKnnFloatQuery(queryVector.asFloatVector());
                    break;
                }
                case 2: {
                    Query query = knnQuery = this.createExactKnnBitQuery(queryVector.asByteVector());
                }
            }
            if (vectorSimilarity != null) {
                knnQuery = new VectorSimilarityQuery(knnQuery, vectorSimilarity.floatValue(), this.similarity.score(vectorSimilarity.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        private Query createExactKnnBitQuery(byte[] queryVector) {
            this.elementType.checkDimensions(this.dims, queryVector.length);
            return new DenseVectorQuery.Bytes(queryVector, this.name());
        }

        private Query createExactKnnByteQuery(byte[] queryVector) {
            this.elementType.checkDimensions(this.dims, queryVector.length);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct(queryVector, queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorByteElementsAppender(queryVector), squaredMagnitude);
            }
            return new DenseVectorQuery.Bytes(queryVector, this.name());
        }

        private Query createExactKnnFloatQuery(float[] queryVector) {
            this.elementType.checkDimensions(this.dims, queryVector.length);
            this.elementType.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct(queryVector, queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorFloatElementsAppender(queryVector), squaredMagnitude);
                if (this.similarity == VectorSimilarity.COSINE && this.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    queryVector = Arrays.copyOf(queryVector, queryVector.length);
                    int i = 0;
                    while (i < queryVector.length) {
                        int n = i++;
                        queryVector[n] = queryVector[n] / length;
                    }
                }
            }
            return new DenseVectorQuery.Floats(queryVector, this.name());
        }

        public Query createKnnQuery(VectorData queryVector, int k, int numCands, Float oversample, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            if (!this.isIndexed()) {
                throw new IllegalArgumentException("to perform knn search on field [" + this.name() + "], its mapping must have [index] set to [true]");
            }
            return switch (this.getElementType().ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.createKnnByteQuery(queryVector.asByteVector(), k, numCands, filter, similarityThreshold, parentFilter);
                case 1 -> this.createKnnFloatQuery(queryVector.asFloatVector(), k, numCands, oversample, filter, similarityThreshold, parentFilter);
                case 2 -> this.createKnnBitQuery(queryVector.asByteVector(), k, numCands, filter, similarityThreshold, parentFilter);
            };
        }

        private boolean needsRescore(Float rescoreOversample) {
            return rescoreOversample != null && this.isQuantized();
        }

        private boolean isQuantized() {
            return this.indexOptions != null && this.indexOptions.type != null && this.indexOptions.type.isQuantized();
        }

        private Query createKnnBitQuery(byte[] queryVector, int k, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            QueryProfilerProvider knnQuery;
            this.elementType.checkDimensions(this.dims, queryVector.length);
            QueryProfilerProvider queryProfilerProvider = knnQuery = parentFilter != null ? new ESDiversifyingChildrenByteKnnVectorQuery(this.name(), queryVector, filter, k, numCands, parentFilter) : new ESKnnByteVectorQuery(this.name(), queryVector, k, numCands, filter);
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)((Object)knnQuery), similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        private Query createKnnByteQuery(byte[] queryVector, int k, int numCands, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            QueryProfilerProvider knnQuery;
            this.elementType.checkDimensions(this.dims, queryVector.length);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct(queryVector, queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorByteElementsAppender(queryVector), squaredMagnitude);
            }
            QueryProfilerProvider queryProfilerProvider = knnQuery = parentFilter != null ? new ESDiversifyingChildrenByteKnnVectorQuery(this.name(), queryVector, filter, k, numCands, parentFilter) : new ESKnnByteVectorQuery(this.name(), queryVector, k, numCands, filter);
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)((Object)knnQuery), similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        private Query createKnnFloatQuery(float[] queryVector, int k, int numCands, Float oversample, Query filter, Float similarityThreshold, BitSetProducer parentFilter) {
            QueryProfilerProvider knnQuery;
            this.elementType.checkDimensions(this.dims, queryVector.length);
            this.elementType.checkVectorBounds(queryVector);
            if (this.similarity == VectorSimilarity.DOT_PRODUCT || this.similarity == VectorSimilarity.COSINE) {
                float squaredMagnitude = VectorUtil.dotProduct(queryVector, queryVector);
                this.elementType.checkVectorMagnitude(this.similarity, ElementType.errorFloatElementsAppender(queryVector), squaredMagnitude);
                if (this.similarity == VectorSimilarity.COSINE && this.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    queryVector = Arrays.copyOf(queryVector, queryVector.length);
                    int i = 0;
                    while (i < queryVector.length) {
                        int n = i++;
                        queryVector[n] = queryVector[n] / length;
                    }
                }
            }
            int adjustedK = k;
            boolean rescore = this.needsRescore(oversample);
            if (rescore) {
                adjustedK = Math.min((int)Math.ceil((float)k * oversample.floatValue()), 10000);
                numCands = Math.max(adjustedK, numCands);
            }
            QueryProfilerProvider queryProfilerProvider = knnQuery = parentFilter != null ? new ESDiversifyingChildrenFloatKnnVectorQuery(this.name(), queryVector, filter, adjustedK, numCands, parentFilter) : new ESKnnFloatVectorQuery(this.name(), queryVector, adjustedK, numCands, filter);
            if (rescore) {
                knnQuery = new RescoreKnnVectorQuery(this.name(), queryVector, this.similarity.vectorSimilarityFunction(this.indexVersionCreated, ElementType.FLOAT), k, (Query)((Object)knnQuery));
            }
            if (similarityThreshold != null) {
                knnQuery = new VectorSimilarityQuery((Query)((Object)knnQuery), similarityThreshold.floatValue(), this.similarity.score(similarityThreshold.floatValue(), this.elementType, this.dims));
            }
            return knnQuery;
        }

        VectorSimilarity getSimilarity() {
            return this.similarity;
        }

        int getVectorDimensions() {
            return this.dims;
        }

        ElementType getElementType() {
            return this.elementType;
        }
    }

    public static enum ElementType {
        BYTE{

            public String toString() {
                return "byte";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.put((byte)value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.get());
            }

            private KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                if (vector == null) {
                    throw new IllegalArgumentException("vector value must not be null");
                }
                FieldType denseVectorFieldType = new FieldType();
                denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.BYTE, function);
                denseVectorFieldType.freeze();
                return new KnnByteVectorField(name, vector, denseVectorFieldType);
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed, r -> r);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
                StringBuilder errorBuilder = null;
                for (int index = 0; index < vector.length; ++index) {
                    float value = vector[index];
                    if (value % 1.0f != 0.0f) {
                        errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors only support non-decimal values but found decimal value [" + value + "] at dim [" + index + "];");
                        break;
                    }
                    if (!(value < -128.0f) && !(value > 127.0f)) continue;
                    errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(1.appendErrorElements(errorBuilder, vector).toString());
                }
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.COSINE) + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public double computeSquaredMagnitude(VectorData vectorData) {
                return VectorUtil.dotProduct(vectorData.asByteVector(), vectorData.asByteVector());
            }

            private VectorData parseVectorArray(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                int index = 0;
                byte[] vector = new byte[dims];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    int value;
                    dimChecker.accept(index, false);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    if (context.parser().numberType() != XContentParser.NumberType.INT) {
                        float floatValue = context.parser().floatValue(true);
                        if (floatValue % 1.0f != 0.0f) {
                            throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this) + "] vectors only support non-decimal values but found decimal value [" + floatValue + "] at dim [" + index + "];");
                        }
                        value = (int)floatValue;
                    } else {
                        value = context.parser().intValue(true);
                    }
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    vector[index++] = (byte)value;
                    squaredMagnitude += (float)(value * value);
                    token = context.parser().nextToken();
                }
                dimChecker.accept(index, true);
                this.checkVectorMagnitude(similarity, 1.errorByteElementsAppender(vector), squaredMagnitude);
                return VectorData.fromBytes(vector);
            }

            private VectorData parseHexEncodedVector(DocumentParserContext context, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
                dimChecker.accept(decodedVector.length, true);
                VectorData vectorData = VectorData.fromBytes(decodedVector);
                double squaredMagnitude = this.computeSquaredMagnitude(vectorData);
                this.checkVectorMagnitude(similarity, 1.errorByteElementsAppender(decodedVector), (float)squaredMagnitude);
                return vectorData;
            }

            @Override
            public VectorData parseKnnVector(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                XContentParser.Token token = context.parser().currentToken();
                return switch (token) {
                    case XContentParser.Token.START_ARRAY -> this.parseVectorArray(context, dims, dimChecker, similarity);
                    case XContentParser.Token.VALUE_STRING -> this.parseHexEncodedVector(context, dimChecker, similarity);
                    default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", new Object[]{token, context.parser().text()}), new Object[0]);
                };
            }

            @Override
            public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                VectorData vectorData = this.parseKnnVector(context, fieldMapper.fieldType().dims, (i, end) -> {
                    if (end) {
                        fieldMapper.checkDimensionMatches(i, context);
                    } else {
                        fieldMapper.checkDimensionExceeded(i, context);
                    }
                }, fieldMapper.fieldType().similarity);
                KnnByteVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vectorData.asByteVector(), fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this));
                context.doc().addWithKey(fieldMapper.fieldType().name(), field);
            }

            @Override
            public int getNumBytes(int dimensions) {
                return dimensions;
            }

            @Override
            public ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
                return ByteBuffer.wrap(new byte[numBytes]);
            }

            @Override
            public int parseDimensionCount(DocumentParserContext context) throws IOException {
                XContentParser.Token currentToken = context.parser().currentToken();
                return switch (currentToken) {
                    case XContentParser.Token.START_ARRAY -> {
                        int index = 0;
                        XContentParser.Token token = context.parser().nextToken();
                        while (token != XContentParser.Token.END_ARRAY) {
                            ++index;
                            token = context.parser().nextToken();
                        }
                        yield index;
                    }
                    case XContentParser.Token.VALUE_STRING -> {
                        byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
                        yield decodedVector.length;
                    }
                    default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", new Object[]{currentToken, context.parser().text()}), new Object[0]);
                };
            }
        }
        ,
        FLOAT{

            public String toString() {
                return "float";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.putFloat(value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.getFloat());
            }

            private KnnFloatVectorField createKnnVectorField(String name, float[] vector, VectorSimilarityFunction function) {
                if (vector == null) {
                    throw new IllegalArgumentException("vector value must not be null");
                }
                FieldType denseVectorFieldType = new FieldType();
                denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.FLOAT32, function);
                denseVectorFieldType.freeze();
                return new KnnFloatVectorField(name, vector, denseVectorFieldType);
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed, denseVectorFieldType.indexVersionCreated.onOrAfter(NORMALIZE_COSINE) && denseVectorFieldType.indexed && denseVectorFieldType.similarity.equals((Object)VectorSimilarity.COSINE) ? r -> new FilterLeafReader(this, (LeafReader)r, (LeafReader)r){
                    final /* synthetic */ LeafReader val$r;
                    {
                        this.val$r = leafReader;
                        super(arg0);
                    }

                    @Override
                    public IndexReader.CacheHelper getCoreCacheHelper() {
                        return this.val$r.getCoreCacheHelper();
                    }

                    @Override
                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return this.val$r.getReaderCacheHelper();
                    }

                    @Override
                    public FloatVectorValues getFloatVectorValues(String fieldName) throws IOException {
                        FloatVectorValues values = this.in.getFloatVectorValues(fieldName);
                        if (values == null) {
                            return null;
                        }
                        return new DenormalizedCosineFloatVectorValues(values, this.in.getNumericDocValues(fieldName + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX));
                    }
                } : r -> r);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
                StringBuilder errorBuilder = null;
                if (Float.isNaN(squaredMagnitude) || Float.isInfinite(squaredMagnitude)) {
                    errorBuilder = new StringBuilder("NaN or Infinite magnitude detected, this usually means the vector values are too extreme to fit within a float.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
                if (similarity == VectorSimilarity.DOT_PRODUCT && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.DOT_PRODUCT) + "] similarity can only be used with unit-length vectors.");
                } else if (similarity == VectorSimilarity.COSINE && Math.sqrt(squaredMagnitude) == 0.0) {
                    errorBuilder = new StringBuilder("The [" + String.valueOf((Object)VectorSimilarity.COSINE) + "] similarity does not support vectors with zero magnitude.");
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(appender.apply(errorBuilder).toString());
                }
            }

            @Override
            public double computeSquaredMagnitude(VectorData vectorData) {
                return VectorUtil.dotProduct(vectorData.asFloatVector(), vectorData.asFloatVector());
            }

            @Override
            public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                int index = 0;
                float[] vector = new float[fieldMapper.fieldType().dims.intValue()];
                float squaredMagnitude = 0.0f;
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    fieldMapper.checkDimensionExceeded(index, context);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    float value = context.parser().floatValue(true);
                    vector[index++] = value;
                    squaredMagnitude += value * value;
                    token = context.parser().nextToken();
                }
                fieldMapper.checkDimensionMatches(index, context);
                this.checkVectorBounds(vector);
                this.checkVectorMagnitude(fieldMapper.fieldType().similarity, 2.errorFloatElementsAppender(vector), squaredMagnitude);
                if (fieldMapper.indexCreatedVersion.onOrAfter(NORMALIZE_COSINE) && fieldMapper.fieldType().similarity.equals((Object)VectorSimilarity.COSINE) && DenseVectorFieldMapper.isNotUnitVector(squaredMagnitude)) {
                    float length = (float)Math.sqrt(squaredMagnitude);
                    int i = 0;
                    while (i < vector.length) {
                        int n = i++;
                        vector[n] = vector[n] / length;
                    }
                    String fieldName = fieldMapper.fieldType().name() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX;
                    FloatDocValuesField magnitudeField = new FloatDocValuesField(fieldName, length);
                    context.doc().addWithKey(fieldName, magnitudeField);
                }
                KnnFloatVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vector, fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this));
                context.doc().addWithKey(fieldMapper.fieldType().name(), field);
            }

            @Override
            public VectorData parseKnnVector(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                int index = 0;
                float squaredMagnitude = 0.0f;
                float[] vector = new float[dims];
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    float value;
                    dimChecker.accept(index, false);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    vector[index] = value = context.parser().floatValue(true);
                    squaredMagnitude += value * value;
                    ++index;
                    token = context.parser().nextToken();
                }
                dimChecker.accept(index, true);
                this.checkVectorBounds(vector);
                this.checkVectorMagnitude(similarity, 2.errorFloatElementsAppender(vector), squaredMagnitude);
                return VectorData.fromFloats(vector);
            }

            @Override
            public int getNumBytes(int dimensions) {
                return dimensions * 4;
            }

            @Override
            public ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
                return indexVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION) ? ByteBuffer.wrap(new byte[numBytes]).order(ByteOrder.LITTLE_ENDIAN) : ByteBuffer.wrap(new byte[numBytes]);
            }
        }
        ,
        BIT{

            public String toString() {
                return "bit";
            }

            @Override
            public void writeValue(ByteBuffer byteBuffer, float value) {
                byteBuffer.put((byte)value);
            }

            @Override
            public void readAndWriteValue(ByteBuffer byteBuffer, XContentBuilder b) throws IOException {
                b.value(byteBuffer.get());
            }

            private KnnByteVectorField createKnnVectorField(String name, byte[] vector, VectorSimilarityFunction function) {
                if (vector == null) {
                    throw new IllegalArgumentException("vector value must not be null");
                }
                FieldType denseVectorFieldType = new FieldType();
                denseVectorFieldType.setVectorAttributes(vector.length, VectorEncoding.BYTE, function);
                denseVectorFieldType.freeze();
                return new KnnByteVectorField(name, vector, denseVectorFieldType);
            }

            @Override
            IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType denseVectorFieldType, FieldDataContext fieldDataContext) {
                return new VectorIndexFieldData.Builder(denseVectorFieldType.name(), CoreValuesSourceType.KEYWORD, denseVectorFieldType.indexVersionCreated, this, denseVectorFieldType.dims, denseVectorFieldType.indexed, r -> r);
            }

            @Override
            public void checkVectorBounds(float[] vector) {
                this.checkNanAndInfinite(vector);
                StringBuilder errorBuilder = null;
                for (int index = 0; index < vector.length; ++index) {
                    float value = vector[index];
                    if (value % 1.0f != 0.0f) {
                        errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors only support non-decimal values but found decimal value [" + value + "] at dim [" + index + "];");
                        break;
                    }
                    if (!(value < -128.0f) && !(value > 127.0f)) continue;
                    errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (errorBuilder != null) {
                    throw new IllegalArgumentException(3.appendErrorElements(errorBuilder, vector).toString());
                }
            }

            @Override
            void checkVectorMagnitude(VectorSimilarity similarity, Function<StringBuilder, StringBuilder> appender, float squaredMagnitude) {
            }

            @Override
            public double computeSquaredMagnitude(VectorData vectorData) {
                int i;
                int count = 0;
                byte[] byteBits = vectorData.asByteVector();
                int upperBound = byteBits.length & 0xFFFFFFF8;
                for (i = 0; i < upperBound; i += 8) {
                    count += Long.bitCount(BitUtil.VH_NATIVE_LONG.get(byteBits, i));
                }
                while (i < byteBits.length) {
                    count += Integer.bitCount(byteBits[i] & 0xFF);
                    ++i;
                }
                return count;
            }

            private VectorData parseVectorArray(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                int index = 0;
                byte[] vector = new byte[dims / 8];
                XContentParser.Token token = context.parser().nextToken();
                while (token != XContentParser.Token.END_ARRAY) {
                    int value;
                    dimChecker.accept(index * 8, false);
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_NUMBER, token, context.parser());
                    if (context.parser().numberType() != XContentParser.NumberType.INT) {
                        float floatValue = context.parser().floatValue(true);
                        if (floatValue % 1.0f != 0.0f) {
                            throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this) + "] vectors only support non-decimal values but found decimal value [" + floatValue + "] at dim [" + index + "];");
                        }
                        value = (int)floatValue;
                    } else {
                        value = context.parser().intValue(true);
                    }
                    if (value < -128 || value > 127) {
                        throw new IllegalArgumentException("element_type [" + String.valueOf((Object)this) + "] vectors only support integers between [-128, 127] but found [" + value + "] at dim [" + index + "];");
                    }
                    vector[index++] = (byte)value;
                    token = context.parser().nextToken();
                }
                dimChecker.accept(index * 8, true);
                return VectorData.fromBytes(vector);
            }

            private VectorData parseHexEncodedVector(DocumentParserContext context, IntBooleanConsumer dimChecker) throws IOException {
                byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
                dimChecker.accept(decodedVector.length * 8, true);
                return VectorData.fromBytes(decodedVector);
            }

            @Override
            public VectorData parseKnnVector(DocumentParserContext context, int dims, IntBooleanConsumer dimChecker, VectorSimilarity similarity) throws IOException {
                XContentParser.Token token = context.parser().currentToken();
                return switch (token) {
                    case XContentParser.Token.START_ARRAY -> this.parseVectorArray(context, dims, dimChecker, similarity);
                    case XContentParser.Token.VALUE_STRING -> this.parseHexEncodedVector(context, dimChecker);
                    default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", new Object[]{token, context.parser().text()}), new Object[0]);
                };
            }

            @Override
            public void parseKnnVectorAndIndex(DocumentParserContext context, DenseVectorFieldMapper fieldMapper) throws IOException {
                VectorData vectorData = this.parseKnnVector(context, fieldMapper.fieldType().dims, (i, end) -> {
                    if (end) {
                        fieldMapper.checkDimensionMatches(i, context);
                    } else {
                        fieldMapper.checkDimensionExceeded(i, context);
                    }
                }, fieldMapper.fieldType().similarity);
                KnnByteVectorField field = this.createKnnVectorField(fieldMapper.fieldType().name(), vectorData.asByteVector(), fieldMapper.fieldType().similarity.vectorSimilarityFunction(fieldMapper.indexCreatedVersion, this));
                context.doc().addWithKey(fieldMapper.fieldType().name(), field);
            }

            @Override
            public int getNumBytes(int dimensions) {
                assert (dimensions % 8 == 0);
                return dimensions / 8;
            }

            @Override
            public ByteBuffer createByteBuffer(IndexVersion indexVersion, int numBytes) {
                return ByteBuffer.wrap(new byte[numBytes]);
            }

            @Override
            public int parseDimensionCount(DocumentParserContext context) throws IOException {
                XContentParser.Token currentToken = context.parser().currentToken();
                return switch (currentToken) {
                    case XContentParser.Token.START_ARRAY -> {
                        int index = 0;
                        XContentParser.Token token = context.parser().nextToken();
                        while (token != XContentParser.Token.END_ARRAY) {
                            ++index;
                            token = context.parser().nextToken();
                        }
                        yield index * 8;
                    }
                    case XContentParser.Token.VALUE_STRING -> {
                        byte[] decodedVector = HexFormat.of().parseHex(context.parser().text());
                        yield decodedVector.length * 8;
                    }
                    default -> throw new ParsingException(context.parser().getTokenLocation(), Strings.format("Unsupported type [%s] for provided value [%s]", new Object[]{currentToken, context.parser().text()}), new Object[0]);
                };
            }

            @Override
            public void checkDimensions(Integer dvDims, int qvDims) {
                if (dvDims != null && dvDims != qvDims * 8) {
                    throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims * 8 + "] than the document vectors [" + dvDims + "].");
                }
            }
        };


        public abstract void writeValue(ByteBuffer var1, float var2);

        public abstract void readAndWriteValue(ByteBuffer var1, XContentBuilder var2) throws IOException;

        abstract IndexFieldData.Builder fielddataBuilder(DenseVectorFieldType var1, FieldDataContext var2);

        abstract void parseKnnVectorAndIndex(DocumentParserContext var1, DenseVectorFieldMapper var2) throws IOException;

        public abstract VectorData parseKnnVector(DocumentParserContext var1, int var2, IntBooleanConsumer var3, VectorSimilarity var4) throws IOException;

        public abstract int getNumBytes(int var1);

        public abstract ByteBuffer createByteBuffer(IndexVersion var1, int var2);

        public abstract void checkVectorBounds(float[] var1);

        abstract void checkVectorMagnitude(VectorSimilarity var1, Function<StringBuilder, StringBuilder> var2, float var3);

        public void checkDimensions(Integer dvDims, int qvDims) {
            if (dvDims != null && dvDims != qvDims) {
                throw new IllegalArgumentException("The query vector has a different number of dimensions [" + qvDims + "] than the document vectors [" + dvDims + "].");
            }
        }

        public int parseDimensionCount(DocumentParserContext context) throws IOException {
            int index = 0;
            XContentParser.Token token = context.parser().nextToken();
            while (token != XContentParser.Token.END_ARRAY) {
                ++index;
                token = context.parser().nextToken();
            }
            return index;
        }

        void checkNanAndInfinite(float[] vector) {
            StringBuilder errorBuilder = null;
            for (int index = 0; index < vector.length; ++index) {
                float value = vector[index];
                if (Float.isNaN(value)) {
                    errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors do not support NaN values but found [" + value + "] at dim [" + index + "];");
                    break;
                }
                if (!Float.isInfinite(value)) continue;
                errorBuilder = new StringBuilder("element_type [" + String.valueOf((Object)this) + "] vectors do not support infinite values but found [" + value + "] at dim [" + index + "];");
                break;
            }
            if (errorBuilder != null) {
                throw new IllegalArgumentException(ElementType.appendErrorElements(errorBuilder, vector).toString());
            }
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, float[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static StringBuilder appendErrorElements(StringBuilder errorBuilder, byte[] vector) {
            errorBuilder.append(" Preview of invalid vector: [");
            for (int i = 0; i < Math.min(5, vector.length); ++i) {
                if (i > 0) {
                    errorBuilder.append(", ");
                }
                errorBuilder.append(vector[i]);
            }
            if (vector.length >= 5) {
                errorBuilder.append(", ...");
            }
            errorBuilder.append("]");
            return errorBuilder;
        }

        static Function<StringBuilder, StringBuilder> errorFloatElementsAppender(float[] vector) {
            return sb -> ElementType.appendErrorElements(sb, vector);
        }

        static Function<StringBuilder, StringBuilder> errorByteElementsAppender(byte[] vector) {
            return sb -> ElementType.appendErrorElements(sb, vector);
        }

        public abstract double computeSquaredMagnitude(VectorData var1);

        public static ElementType fromString(String name) {
            return ElementType.valueOf(name.trim().toUpperCase(Locale.ROOT));
        }
    }

    public static enum VectorSimilarity {
        L2_NORM{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    default -> throw new MatchException(null, null);
                    case ElementType.BYTE, ElementType.FLOAT -> 1.0f / (1.0f + similarity * similarity);
                    case ElementType.BIT -> ((float)dim - similarity) / (float)dim;
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.EUCLIDEAN;
            }
        }
        ,
        COSINE{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                assert (elementType != ElementType.BIT);
                switch (elementType) {
                    case BYTE: 
                    case FLOAT: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                    }
                }
                return (1.0f + similarity) / 2.0f;
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return indexVersion.onOrAfter(NORMALIZE_COSINE) && ElementType.FLOAT.equals((Object)elementType) ? VectorSimilarityFunction.DOT_PRODUCT : VectorSimilarityFunction.COSINE;
            }
        }
        ,
        DOT_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    case ElementType.BYTE -> 0.5f + similarity / (float)(dim * 32768);
                    case ElementType.FLOAT -> (1.0f + similarity) / 2.0f;
                    default -> throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.DOT_PRODUCT;
            }
        }
        ,
        MAX_INNER_PRODUCT{

            @Override
            float score(float similarity, ElementType elementType, int dim) {
                return switch (elementType) {
                    case ElementType.BYTE, ElementType.FLOAT -> {
                        if (similarity < 0.0f) {
                            yield 1.0f / (1.0f + -1.0f * similarity);
                        }
                        yield similarity + 1.0f;
                    }
                    default -> throw new IllegalArgumentException("Unsupported element type [" + String.valueOf((Object)elementType) + "]");
                };
            }

            @Override
            public VectorSimilarityFunction vectorSimilarityFunction(IndexVersion indexVersion, ElementType elementType) {
                return VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT;
            }
        };


        public final String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        abstract float score(float var1, ElementType var2, int var3);

        public abstract VectorSimilarityFunction vectorSimilarityFunction(IndexVersion var1, ElementType var2);
    }

    @FunctionalInterface
    public static interface IntBooleanConsumer {
        public void accept(int var1, boolean var2);
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<ElementType> elementType = new FieldMapper.Parameter<ElementType>("element_type", false, () -> ElementType.FLOAT, (n, c, o) -> {
            ElementType elementType = namesToElementType.get((String)o);
            if (elementType == null) {
                throw new MapperParsingException("invalid element_type [" + String.valueOf(o) + "]; available types are " + String.valueOf(namesToElementType.keySet()));
            }
            return elementType;
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().elementType, XContentBuilder::field, Objects::toString);
        private final FieldMapper.Parameter<Integer> dims = new FieldMapper.Parameter<Integer>("dims", true, () -> null, (n, c, o) -> {
            if (!(o instanceof Integer)) {
                throw new MapperParsingException("Property [dims] on field [" + n + "] must be an integer but got [" + String.valueOf(o) + "]");
            }
            return XContentMapValues.nodeIntegerValue(o);
        }, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().dims, XContentBuilder::field, Objects::toString).setSerializerCheck((id, ic, v) -> v != null).setMergeValidator((previous, current, c) -> previous == null || Objects.equals(previous, current)).addValidator(dims -> {
            int minDims;
            if (dims == null) {
                return;
            }
            int maxDims = this.elementType.getValue() == ElementType.BIT ? 32768 : 4096;
            int n = minDims = this.elementType.getValue() == ElementType.BIT ? 8 : 1;
            if (dims < minDims || dims > maxDims) {
                throw new MapperParsingException("The number of dimensions should be in the range [" + minDims + ", " + maxDims + "] but was [" + dims + "]");
            }
            if (this.elementType.getValue() == ElementType.BIT && dims % 8 != 0) {
                throw new MapperParsingException("The number of dimensions for should be a multiple of 8 but was [" + dims + "]");
            }
        });
        private final FieldMapper.Parameter<VectorSimilarity> similarity;
        private final FieldMapper.Parameter<IndexOptions> indexOptions;
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        final IndexVersion indexVersionCreated;

        public Builder(String name, IndexVersion indexVersionCreated) {
            super(name);
            this.indexVersionCreated = indexVersionCreated;
            boolean indexedByDefault = indexVersionCreated.onOrAfter(INDEXED_BY_DEFAULT_INDEX_VERSION);
            boolean defaultInt8Hnsw = indexVersionCreated.onOrAfter(IndexVersions.DEFAULT_DENSE_VECTOR_TO_INT8_HNSW);
            this.indexed = FieldMapper.Parameter.indexParam(m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().indexed, indexedByDefault);
            if (indexedByDefault) {
                this.indexed.alwaysSerialize();
            }
            this.similarity = FieldMapper.Parameter.enumParam("similarity", false, m -> DenseVectorFieldMapper.toType((FieldMapper)m).fieldType().similarity, () -> {
                if (indexedByDefault && this.indexed.getValue().booleanValue()) {
                    return this.elementType.getValue() == ElementType.BIT ? VectorSimilarity.L2_NORM : VectorSimilarity.COSINE;
                }
                return null;
            }, VectorSimilarity.class).acceptsNull().setSerializerCheck((id, ic, v) -> v != null).addValidator(vectorSim -> {
                if (vectorSim == null) {
                    return;
                }
                if (this.elementType.getValue() == ElementType.BIT && vectorSim != VectorSimilarity.L2_NORM) {
                    throw new IllegalArgumentException("The [" + String.valueOf((Object)VectorSimilarity.L2_NORM) + "] similarity is the only supported similarity for bit vectors");
                }
            });
            this.indexOptions = new FieldMapper.Parameter<IndexOptions>("index_options", true, () -> defaultInt8Hnsw && this.elementType.getValue() == ElementType.FLOAT && this.indexed.getValue() != false ? new Int8HnswIndexOptions(16, 100, null) : null, (n, c, o) -> o == null ? null : DenseVectorFieldMapper.parseIndexOptions(n, o), m -> DenseVectorFieldMapper.toType((FieldMapper)m).indexOptions, (b, n, v) -> {
                if (v != null) {
                    b.field(n, (ToXContent)v);
                }
            }, Objects::toString).setSerializerCheck((id, ic, v) -> v != null).addValidator(v -> {
                if (v != null && this.dims.isConfigured() && this.dims.get() != null) {
                    v.validateDimension(this.dims.get());
                }
                if (v != null) {
                    v.validateElementType(this.elementType.getValue());
                }
            }).acceptsNull().setMergeValidator((previous, current, c) -> previous == null || current == null || Objects.equals(previous, current) || previous.updatableTo((IndexOptions)current));
            if (defaultInt8Hnsw) {
                this.indexOptions.alwaysSerialize();
            }
            this.indexed.addValidator(v -> {
                if (v.booleanValue()) {
                    if (this.similarity.getValue() == null) {
                        throw new IllegalArgumentException("Field [index] requires field [similarity] to be configured and not null");
                    }
                } else {
                    if (this.similarity.isConfigured() && this.similarity.getValue() != null) {
                        throw new IllegalArgumentException("Field [similarity] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                    if (this.indexOptions.isConfigured() && this.indexOptions.getValue() != null) {
                        throw new IllegalArgumentException("Field [index_options] can only be specified for a field of type [dense_vector] when it is indexed");
                    }
                }
            });
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.elementType, this.dims, this.indexed, this.similarity, this.indexOptions, this.meta};
        }

        public Builder similarity(VectorSimilarity vectorSimilarity) {
            this.similarity.setValue(vectorSimilarity);
            return this;
        }

        public Builder dimensions(int dimensions) {
            this.dims.setValue(dimensions);
            return this;
        }

        public Builder elementType(ElementType elementType) {
            this.elementType.setValue(elementType);
            return this;
        }

        @Override
        public DenseVectorFieldMapper build(MapperBuilderContext context) {
            this.validate();
            return new DenseVectorFieldMapper(this.leafName(), new DenseVectorFieldType(context.buildFullName(this.leafName()), this.indexVersionCreated, this.elementType.getValue(), this.dims.getValue(), this.indexed.getValue(), this.similarity.getValue(), this.indexOptions.getValue(), this.meta.getValue()), this.builderParams(this, context), this.indexOptions.getValue(), this.indexVersionCreated);
        }
    }

    public static enum VectorIndexType {
        HNSW("hnsw", false){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new HnswIndexOptions(m, efConstruction);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return true;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT8_HNSW("int8_hnsw", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int8HnswIndexOptions(m, efConstruction, confidenceInterval);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT4_HNSW("int4_hnsw", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int4HnswIndexOptions(m, efConstruction, confidenceInterval);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims % 2 == 0;
            }
        }
        ,
        FLAT("flat", false){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new FlatIndexOptions();
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return true;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT8_FLAT("int8_flat", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int8FlatIndexOptions(confidenceInterval);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return true;
            }
        }
        ,
        INT4_FLAT("int4_flat", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object confidenceIntervalNode = indexOptionsMap.remove("confidence_interval");
                Float confidenceInterval = null;
                if (confidenceIntervalNode != null) {
                    confidenceInterval = Float.valueOf((float)XContentMapValues.nodeDoubleValue(confidenceIntervalNode));
                }
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new Int4FlatIndexOptions(confidenceInterval);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims % 2 == 0;
            }
        }
        ,
        BBQ_HNSW("bbq_hnsw", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                Object mNode = indexOptionsMap.remove("m");
                Object efConstructionNode = indexOptionsMap.remove("ef_construction");
                if (mNode == null) {
                    mNode = 16;
                }
                if (efConstructionNode == null) {
                    efConstructionNode = 100;
                }
                int m = XContentMapValues.nodeIntegerValue(mNode);
                int efConstruction = XContentMapValues.nodeIntegerValue(efConstructionNode);
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new BBQHnswIndexOptions(m, efConstruction);
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims >= 64;
            }
        }
        ,
        BBQ_FLAT("bbq_flat", true){

            @Override
            public IndexOptions parseIndexOptions(String fieldName, Map<String, ?> indexOptionsMap) {
                MappingParser.checkNoRemainingFields(fieldName, indexOptionsMap);
                return new BBQFlatIndexOptions();
            }

            @Override
            public boolean supportsElementType(ElementType elementType) {
                return elementType == ElementType.FLOAT;
            }

            @Override
            public boolean supportsDimension(int dims) {
                return dims >= 64;
            }
        };

        private final String name;
        private final boolean quantized;

        static Optional<VectorIndexType> fromString(String type) {
            return Stream.of(VectorIndexType.values()).filter(vectorIndexType -> vectorIndexType.name.equals(type)).findFirst();
        }

        private VectorIndexType(String name, boolean quantized) {
            this.name = name;
            this.quantized = quantized;
        }

        abstract IndexOptions parseIndexOptions(String var1, Map<String, ?> var2);

        public abstract boolean supportsElementType(ElementType var1);

        public abstract boolean supportsDimension(int var1);

        public boolean isQuantized() {
            return this.quantized;
        }

        public String toString() {
            return this.name;
        }
    }

    private class IndexedSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private FloatVectorValues values;
        private ByteVectorValues byteVectorValues;
        private boolean hasValue;
        private boolean hasMagnitude;
        private int ord;
        private final IndexVersion indexCreatedVersion;
        private final VectorSimilarity vectorSimilarity;
        private NumericDocValues magnitudeReader;

        private IndexedSyntheticFieldLoader(IndexVersion indexCreatedVersion, VectorSimilarity vectorSimilarity) {
            this.indexCreatedVersion = indexCreatedVersion;
            this.vectorSimilarity = vectorSimilarity;
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getFloatVectorValues(DenseVectorFieldMapper.this.fullPath());
            if (this.values != null) {
                if (this.indexCreatedVersion.onOrAfter(NORMALIZE_COSINE) && VectorSimilarity.COSINE.equals((Object)this.vectorSimilarity)) {
                    this.magnitudeReader = leafReader.getNumericDocValues(DenseVectorFieldMapper.this.fullPath() + DenseVectorFieldMapper.COSINE_MAGNITUDE_FIELD_SUFFIX);
                }
                KnnVectorValues.DocIndexIterator iterator = this.values.iterator();
                return docId -> {
                    if (iterator.docID() > docId) {
                        this.hasValue = false;
                        return false;
                    }
                    if (iterator.docID() == docId) {
                        this.hasValue = true;
                        return true;
                    }
                    this.hasValue = docId == iterator.advance(docId);
                    this.hasMagnitude = this.hasValue && this.magnitudeReader != null && this.magnitudeReader.advanceExact(docId);
                    this.ord = iterator.index();
                    return this.hasValue;
                };
            }
            this.byteVectorValues = leafReader.getByteVectorValues(DenseVectorFieldMapper.this.fullPath());
            if (this.byteVectorValues != null) {
                KnnVectorValues.DocIndexIterator iterator = this.byteVectorValues.iterator();
                return docId -> {
                    if (iterator.docID() > docId) {
                        this.hasValue = false;
                        return false;
                    }
                    if (iterator.docID() == docId) {
                        this.hasValue = true;
                        return true;
                    }
                    this.hasValue = docId == iterator.advance(docId);
                    this.ord = iterator.index();
                    return this.hasValue;
                };
            }
            return null;
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            float magnitude = Float.NaN;
            if (this.hasMagnitude) {
                magnitude = Float.intBitsToFloat((int)this.magnitudeReader.longValue());
            }
            b.startArray(DenseVectorFieldMapper.this.leafName());
            if (this.values != null) {
                for (float v : this.values.vectorValue(this.ord)) {
                    if (this.hasMagnitude) {
                        b.value(v * magnitude);
                        continue;
                    }
                    b.value(v);
                }
            } else if (this.byteVectorValues != null) {
                byte[] vectorValue;
                for (byte value : vectorValue = this.byteVectorValues.vectorValue(this.ord)) {
                    b.value(value);
                }
            }
            b.endArray();
        }

        @Override
        public String fieldName() {
            return DenseVectorFieldMapper.this.fullPath();
        }
    }

    private class DocValuesSyntheticFieldLoader
    extends SourceLoader.DocValuesBasedSyntheticFieldLoader {
        private BinaryDocValues values;
        private boolean hasValue;
        private final IndexVersion indexCreatedVersion;

        private DocValuesSyntheticFieldLoader(IndexVersion indexCreatedVersion) {
            this.indexCreatedVersion = indexCreatedVersion;
        }

        @Override
        public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
            this.values = leafReader.getBinaryDocValues(DenseVectorFieldMapper.this.fullPath());
            if (this.values == null) {
                return null;
            }
            return docId -> {
                if (this.values.docID() > docId) {
                    this.hasValue = false;
                    return false;
                }
                if (this.values.docID() == docId) {
                    this.hasValue = true;
                    return true;
                }
                this.hasValue = docId == this.values.advance(docId);
                return this.hasValue;
            };
        }

        @Override
        public boolean hasValue() {
            return this.hasValue;
        }

        @Override
        public void write(XContentBuilder b) throws IOException {
            if (!this.hasValue) {
                return;
            }
            b.startArray(DenseVectorFieldMapper.this.leafName());
            BytesRef ref = this.values.binaryValue();
            ByteBuffer byteBuffer = ByteBuffer.wrap(ref.bytes, ref.offset, ref.length);
            if (this.indexCreatedVersion.onOrAfter(LITTLE_ENDIAN_FLOAT_STORED_INDEX_VERSION)) {
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int dims = DenseVectorFieldMapper.this.fieldType().elementType == ElementType.BIT ? DenseVectorFieldMapper.this.fieldType().dims / 8 : DenseVectorFieldMapper.this.fieldType().dims;
            for (int dim = 0; dim < dims; ++dim) {
                DenseVectorFieldMapper.this.fieldType().elementType.readAndWriteValue(byteBuffer, b);
            }
            b.endArray();
        }

        @Override
        public String fieldName() {
            return DenseVectorFieldMapper.this.fullPath();
        }
    }

    static class BBQFlatIndexOptions
    extends IndexOptions {
        private final int CLASS_NAME_HASH = this.getClass().getName().hashCode();

        BBQFlatIndexOptions() {
            super(VectorIndexType.BBQ_FLAT);
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES818BinaryQuantizedVectorsFormat();
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            return update.type.equals((Object)this.type);
        }

        @Override
        boolean doEquals(IndexOptions other) {
            return other instanceof BBQFlatIndexOptions;
        }

        @Override
        int doHashCode() {
            return this.CLASS_NAME_HASH;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.endObject();
            return builder;
        }

        @Override
        public void validateDimension(int dim) {
            if (this.type.supportsDimension(dim)) {
                return;
            }
            throw new IllegalArgumentException(this.type.name + " does not support dimensions fewer than 64; provided=" + dim);
        }
    }

    static class BBQHnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;

        BBQHnswIndexOptions(int m, int efConstruction) {
            super(VectorIndexType.BBQ_HNSW);
            this.m = m;
            this.efConstruction = efConstruction;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES818HnswBinaryQuantizedVectorsFormat(this.m, this.efConstruction);
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            return update.type.equals((Object)this.type);
        }

        @Override
        boolean doEquals(IndexOptions other) {
            BBQHnswIndexOptions that = (BBQHnswIndexOptions)other;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        @Override
        int doHashCode() {
            return Objects.hash(this.m, this.efConstruction);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        @Override
        public void validateDimension(int dim) {
            if (this.type.supportsDimension(dim)) {
                return;
            }
            throw new IllegalArgumentException(this.type.name + " does not support dimensions fewer than 64; provided=" + dim);
        }
    }

    static class HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;

        HnswIndexOptions(int m, int efConstruction) {
            super(VectorIndexType.HNSW);
            this.m = m;
            this.efConstruction = efConstruction;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            if (elementType == ElementType.BIT) {
                return new ES815HnswBitVectorsFormat(this.m, this.efConstruction);
            }
            return new Lucene99HnswVectorsFormat(this.m, this.efConstruction, 1, null);
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            boolean updatable = update.type.equals((Object)this.type);
            if (updatable) {
                HnswIndexOptions hnswIndexOptions = (HnswIndexOptions)update;
                updatable = hnswIndexOptions.m >= this.m;
            }
            return updatable || update.type.equals((Object)VectorIndexType.INT8_HNSW) && ((Int8HnswIndexOptions)update).m >= this.m || update.type.equals((Object)VectorIndexType.INT4_HNSW) && ((Int4HnswIndexOptions)update).m >= this.m;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(IndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HnswIndexOptions that = (HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction;
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction);
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + "}";
        }
    }

    static class Int8HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;
        private final Float confidenceInterval;

        Int8HnswIndexOptions(int m, int efConstruction, Float confidenceInterval) {
            super(VectorIndexType.INT8_HNSW);
            this.m = m;
            this.efConstruction = efConstruction;
            this.confidenceInterval = confidenceInterval;
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES814HnswScalarQuantizedVectorsFormat(this.m, this.efConstruction, this.confidenceInterval, 7, false);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            if (this.confidenceInterval != null) {
                builder.field("confidence_interval", this.confidenceInterval);
            }
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(IndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Int8HnswIndexOptions that = (Int8HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(this.confidenceInterval, that.confidenceInterval);
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction, this.confidenceInterval);
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + ", confidence_interval=" + this.confidenceInterval + "}";
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            boolean updatable;
            if (update.type.equals((Object)this.type)) {
                Int8HnswIndexOptions int8HnswIndexOptions = (Int8HnswIndexOptions)update;
                updatable = int8HnswIndexOptions.m >= this.m;
                updatable &= this.confidenceInterval == null || int8HnswIndexOptions.confidenceInterval != null && this.confidenceInterval.equals(int8HnswIndexOptions.confidenceInterval);
            } else {
                updatable = update.type.equals((Object)VectorIndexType.INT4_HNSW) && ((Int4HnswIndexOptions)update).m >= this.m;
            }
            return updatable;
        }
    }

    static class Int4FlatIndexOptions
    extends IndexOptions {
        private final float confidenceInterval;

        Int4FlatIndexOptions(Float confidenceInterval) {
            super(VectorIndexType.INT4_FLAT);
            this.confidenceInterval = confidenceInterval == null ? 0.0f : confidenceInterval.floatValue();
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES813Int8FlatVectorFormat(Float.valueOf(this.confidenceInterval), 4, true);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("confidence_interval", this.confidenceInterval);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(IndexOptions o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Int4FlatIndexOptions that = (Int4FlatIndexOptions)o;
            return Objects.equals(Float.valueOf(this.confidenceInterval), Float.valueOf(that.confidenceInterval));
        }

        @Override
        public int doHashCode() {
            return Objects.hash(Float.valueOf(this.confidenceInterval));
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", confidence_interval=" + this.confidenceInterval + "}";
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            return update.type.equals((Object)this.type) || update.type.equals((Object)VectorIndexType.HNSW) || update.type.equals((Object)VectorIndexType.INT8_HNSW) || update.type.equals((Object)VectorIndexType.INT4_HNSW);
        }
    }

    static class Int4HnswIndexOptions
    extends IndexOptions {
        private final int m;
        private final int efConstruction;
        private final float confidenceInterval;

        Int4HnswIndexOptions(int m, int efConstruction, Float confidenceInterval) {
            super(VectorIndexType.INT4_HNSW);
            this.m = m;
            this.efConstruction = efConstruction;
            this.confidenceInterval = confidenceInterval == null ? 0.0f : confidenceInterval.floatValue();
        }

        @Override
        public KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES814HnswScalarQuantizedVectorsFormat(this.m, this.efConstruction, Float.valueOf(this.confidenceInterval), 4, true);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.field("m", this.m);
            builder.field("ef_construction", this.efConstruction);
            builder.field("confidence_interval", this.confidenceInterval);
            builder.endObject();
            return builder;
        }

        @Override
        public boolean doEquals(IndexOptions o) {
            Int4HnswIndexOptions that = (Int4HnswIndexOptions)o;
            return this.m == that.m && this.efConstruction == that.efConstruction && Objects.equals(Float.valueOf(this.confidenceInterval), Float.valueOf(that.confidenceInterval));
        }

        @Override
        public int doHashCode() {
            return Objects.hash(this.m, this.efConstruction, Float.valueOf(this.confidenceInterval));
        }

        public String toString() {
            return "{type=" + String.valueOf((Object)this.type) + ", m=" + this.m + ", ef_construction=" + this.efConstruction + ", confidence_interval=" + this.confidenceInterval + "}";
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            boolean updatable = update.type.equals((Object)this.type);
            if (updatable) {
                Int4HnswIndexOptions int4HnswIndexOptions = (Int4HnswIndexOptions)update;
                updatable = int4HnswIndexOptions.m >= this.m && this.confidenceInterval == int4HnswIndexOptions.confidenceInterval;
            }
            return updatable;
        }
    }

    static class FlatIndexOptions
    extends IndexOptions {
        FlatIndexOptions() {
            super(VectorIndexType.FLAT);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            builder.endObject();
            return builder;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            if (elementType.equals((Object)ElementType.BIT)) {
                return new ES815BitFlatVectorFormat();
            }
            return new ES813FlatVectorFormat();
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            return true;
        }

        @Override
        public boolean doEquals(IndexOptions o) {
            return o instanceof FlatIndexOptions;
        }

        @Override
        public int doHashCode() {
            return Objects.hash(new Object[]{this.type});
        }
    }

    static class Int8FlatIndexOptions
    extends IndexOptions {
        private final Float confidenceInterval;

        Int8FlatIndexOptions(Float confidenceInterval) {
            super(VectorIndexType.INT8_FLAT);
            this.confidenceInterval = confidenceInterval;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("type", this.type);
            if (this.confidenceInterval != null) {
                builder.field("confidence_interval", this.confidenceInterval);
            }
            builder.endObject();
            return builder;
        }

        @Override
        KnnVectorsFormat getVectorsFormat(ElementType elementType) {
            assert (elementType == ElementType.FLOAT);
            return new ES813Int8FlatVectorFormat(this.confidenceInterval, 7, false);
        }

        @Override
        boolean doEquals(IndexOptions o) {
            Int8FlatIndexOptions that = (Int8FlatIndexOptions)o;
            return Objects.equals(this.confidenceInterval, that.confidenceInterval);
        }

        @Override
        int doHashCode() {
            return Objects.hash(this.confidenceInterval);
        }

        @Override
        boolean updatableTo(IndexOptions update) {
            return update.type.equals((Object)this.type) || update.type.equals((Object)VectorIndexType.HNSW) || update.type.equals((Object)VectorIndexType.INT8_HNSW) || update.type.equals((Object)VectorIndexType.INT4_HNSW) || update.type.equals((Object)VectorIndexType.INT4_FLAT);
        }
    }
}

