/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryIndexFieldData;
import org.elasticsearch.index.mapper.BinaryDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RangeFieldMapper
extends FieldMapper {
    public static final NodeFeature DATE_RANGE_INDEXING_FIX = new NodeFeature("mapper.range.date_range_indexing_fix");
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final RangeType type;
    private final boolean index;
    private final boolean hasDocValues;
    private final boolean store;
    private final Explicit<Boolean> coerce;
    private final String format;
    private final Locale locale;
    private final boolean coerceByDefault;

    private static RangeFieldMapper toType(FieldMapper in) {
        return (RangeFieldMapper)in;
    }

    private RangeFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, RangeType type, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.type = type;
        this.index = builder.index.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.store = builder.store.getValue();
        this.coerce = builder.coerce.getValue();
        this.format = builder.format.getValue();
        this.locale = builder.locale.getValue();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
    }

    boolean coerce() {
        return this.coerce.value();
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.type, this.coerceByDefault).init(this);
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType().typeName();
    }

    @Override
    protected boolean supportsParsingObject() {
        return true;
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentParser parser = context.parser();
        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
            return;
        }
        Range range = this.parseRange(parser);
        context.doc().addAll(this.fieldType().rangeType.createFields(context, this.fullPath(), range, this.index, this.hasDocValues, this.store));
        if (!this.hasDocValues && (this.index || this.store)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    private Range parseRange(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParser.Token start = parser.currentToken();
        if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
            return RangeFieldMapper.parseIpRangeFromCidr(parser);
        }
        if (start != XContentParser.Token.START_OBJECT) {
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], expected an object but got " + parser.currentName());
        }
        RangeFieldType fieldType = this.fieldType();
        RangeType rangeType = fieldType.rangeType;
        String fieldName = null;
        Object parsedFrom = null;
        Object parsedTo = null;
        boolean includeFrom = true;
        boolean includeTo = true;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                includeFrom = false;
                if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                parsedFrom = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                continue;
            }
            if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                includeFrom = true;
                if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                parsedFrom = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                continue;
            }
            if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                includeTo = false;
                if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                parsedTo = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                continue;
            }
            if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                includeTo = true;
                if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                parsedTo = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                continue;
            }
            throw new DocumentParsingException(parser.getTokenLocation(), "error parsing field [" + this.fullPath() + "], with unknown parameter [" + fieldName + "]");
        }
        Object from = parsedFrom != null ? parsedFrom : rangeType.defaultFrom(includeFrom);
        Object to = parsedTo != null ? parsedTo : rangeType.defaultTo(includeTo);
        return new Range(rangeType, from, to, includeFrom, includeTo);
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        InetAddresses.IpRange range = InetAddresses.parseIpRangeFromCidr(parser.text());
        return new Range(RangeType.IP, range.lowerBound(), range.upperBound(), true, true);
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new BinaryDocValuesSyntheticFieldLoader(this.fullPath()){

                @Override
                protected void writeValue(XContentBuilder b, BytesRef value) throws IOException {
                    List<Range> ranges = RangeFieldMapper.this.type.decodeRanges(value);
                    switch (ranges.size()) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            b.field(RangeFieldMapper.this.leafName());
                            ranges.get(0).toXContent(b, RangeFieldMapper.this.fieldType().dateTimeFormatter);
                            break;
                        }
                        default: {
                            b.startArray(RangeFieldMapper.this.leafName());
                            for (Range range : ranges) {
                                range.toXContent(b, RangeFieldMapper.this.fieldType().dateTimeFormatter);
                            }
                            b.endArray();
                        }
                    }
                }
            });
        }
        return super.syntheticSourceSupport();
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Boolean> index = FieldMapper.Parameter.indexParam(m -> RangeFieldMapper.toType((FieldMapper)m).index, true);
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> RangeFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> store = FieldMapper.Parameter.storeParam(m -> RangeFieldMapper.toType((FieldMapper)m).store, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<String> format = FieldMapper.Parameter.stringParam("format", false, m -> RangeFieldMapper.toType((FieldMapper)m).format, Defaults.DATE_FORMATTER.pattern());
        private final FieldMapper.Parameter<Locale> locale = new FieldMapper.Parameter<Locale>("locale", false, () -> Defaults.LOCALE, (n, c, o) -> LocaleUtils.parse(o.toString()), m -> RangeFieldMapper.toType((FieldMapper)m).locale, (xContentBuilder, n, v) -> xContentBuilder.field(n, v.toString()), Objects::toString);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final RangeType type;

        public Builder(String name, RangeType type, Settings settings) {
            this(name, type, COERCE_SETTING.get(settings));
        }

        public Builder(String name, RangeType type, boolean coerceByDefault) {
            super(name);
            this.type = type;
            this.coerce = FieldMapper.Parameter.explicitBoolParam("coerce", true, m -> RangeFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            if (this.type != RangeType.DATE) {
                this.format.neverSerialize();
                this.locale.neverSerialize();
            }
        }

        public void docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
        }

        Builder format(String format) {
            this.format.setValue(format);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.index, this.hasDocValues, this.store, this.coerce, this.format, this.locale, this.meta};
        }

        protected RangeFieldType setupFieldType(MapperBuilderContext context) {
            String fullName = context.buildFullName(this.leafName());
            if (this.format.isConfigured()) {
                if (this.type != RangeType.DATE) {
                    throw new IllegalArgumentException("field [" + this.leafName() + "] of type [range] should not define a dateTimeFormatter unless it is a " + String.valueOf((Object)RangeType.DATE) + " type");
                }
                return new RangeFieldType(fullName, this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), DateFormatter.forPattern(this.format.getValue()).withLocale(this.locale.getValue()), (boolean)this.coerce.getValue().value(), this.meta.getValue());
            }
            if (this.type == RangeType.DATE) {
                return new RangeFieldType(fullName, this.index.getValue(), (boolean)this.store.getValue(), (boolean)this.hasDocValues.getValue(), Defaults.DATE_FORMATTER, (boolean)this.coerce.getValue().value(), this.meta.getValue());
            }
            return new RangeFieldType(fullName, this.type, (boolean)this.index.getValue(), (boolean)this.store.getValue(), this.hasDocValues.getValue(), (boolean)this.coerce.getValue().value(), this.meta.getValue());
        }

        @Override
        public RangeFieldMapper build(MapperBuilderContext context) {
            RangeFieldType ft = this.setupFieldType(context);
            return new RangeFieldMapper(this.leafName(), ft, this.builderParams(this, context), this.type, this);
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected final RangeType rangeType;
        protected final DateFormatter dateTimeFormatter;
        protected final DateMathParser dateMathParser;
        protected final boolean coerce;

        public RangeFieldType(String name, RangeType type, boolean indexed, boolean stored, boolean hasDocValues, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            assert (type != RangeType.DATE);
            this.rangeType = Objects.requireNonNull(type);
            this.dateTimeFormatter = null;
            this.dateMathParser = null;
            this.coerce = coerce;
        }

        public RangeFieldType(String name, RangeType type) {
            this(name, type, true, false, true, false, Collections.emptyMap());
        }

        public RangeFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, DateFormatter formatter, boolean coerce, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.rangeType = RangeType.DATE;
            this.dateTimeFormatter = Objects.requireNonNull(formatter);
            this.dateMathParser = this.dateTimeFormatter.toDateMathParser();
            this.coerce = coerce;
        }

        public RangeFieldType(String name, DateFormatter formatter) {
            this(name, true, false, true, formatter, false, Collections.emptyMap());
        }

        public RangeType rangeType() {
            return this.rangeType;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return new BinaryIndexFieldData.Builder(this.name(), CoreValuesSourceType.RANGE);
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            DateFormatter defaultFormatter = this.dateTimeFormatter();
            final DateFormatter formatter = format != null ? DateFormatter.forPattern(format).withLocale(defaultFormatter.locale()) : defaultFormatter;
            return new SourceValueFetcher(this.name(), context){

                @Override
                protected Object parseSourceValue(Object value) {
                    RangeType rangeType = this.rangeType();
                    if (!(value instanceof Map)) {
                        assert (rangeType == RangeType.IP);
                        Tuple<InetAddress, Integer> ipRange = InetAddresses.parseCidr(value.toString());
                        return InetAddresses.toCidrString(ipRange.v1(), ipRange.v2());
                    }
                    Map range = (Map)value;
                    HashMap<String, Object> parsedRange = new HashMap<String, Object>();
                    for (Map.Entry entry : range.entrySet()) {
                        Object parsedValue = rangeType.parseValue(entry.getValue(), coerce, dateMathParser);
                        Object formattedValue = rangeType.formatValue(parsedValue, formatter);
                        parsedRange.put((String)entry.getKey(), formattedValue);
                    }
                    return parsedRange;
                }
            };
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (this.rangeType == RangeType.DATE) {
                DateFormatter dateTimeFormatter = this.dateTimeFormatter;
                if (format != null) {
                    dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
                }
                if (timeZone == null) {
                    timeZone = ZoneOffset.UTC;
                }
                return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
            }
            return super.docValueFormat(format, timeZone);
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            return this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, SearchExecutionContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private final boolean includeFrom;
        private final boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeFrom == range.includeFrom && this.includeTo == range.includeTo && this.type == range.type && this.from.equals(range.from) && this.to.equals(range.to);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.from, this.to, this.includeFrom, this.includeTo});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }

        public XContentBuilder toXContent(XContentBuilder builder, DateFormatter dateFormatter) throws IOException {
            Object valueWithAdjustment;
            builder.startObject();
            if (this.from.equals(this.type.minValue())) {
                assert (this.includeFrom) : "Range bounds were not properly adjusted during parsing";
                builder.nullField("gte");
            } else {
                if (this.includeFrom) {
                    builder.field("gte");
                } else {
                    builder.field("gt");
                }
                valueWithAdjustment = this.includeFrom ? this.from : this.type.nextDown(this.from);
                builder.value(this.type.formatValue(valueWithAdjustment, dateFormatter));
            }
            if (this.to.equals(this.type.maxValue())) {
                assert (this.includeTo) : "Range bounds were not properly adjusted during parsing";
                builder.nullField("lte");
            } else {
                if (this.includeTo) {
                    builder.field("lte");
                } else {
                    builder.field("lt");
                }
                valueWithAdjustment = this.includeTo ? this.to : this.type.nextUp(this.to);
                builder.value(this.type.formatValue(valueWithAdjustment, dateFormatter));
            }
            builder.endObject();
            return builder;
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        @Override
        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class Defaults {
        public static final DateFormatter DATE_FORMATTER = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER;
        public static final Locale LOCALE = DateFieldMapper.DEFAULT_LOCALE;
    }
}

