/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.IndexSortSortedNumericDocValuesRangeQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedDoubleIndexFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedDoublesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SimpleMappedFieldType;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.DoubleFieldScript;
import org.elasticsearch.script.LongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.ByteDocValuesField;
import org.elasticsearch.script.field.DoubleDocValuesField;
import org.elasticsearch.script.field.FloatDocValuesField;
import org.elasticsearch.script.field.HalfFloatDocValuesField;
import org.elasticsearch.script.field.IntegerDocValuesField;
import org.elasticsearch.script.field.LongDocValuesField;
import org.elasticsearch.script.field.ShortDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.TimeSeriesValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class NumberFieldMapper
extends FieldMapper {
    public static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private final NumberType type;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Explicit<Boolean> ignoreMalformed;
    private final Explicit<Boolean> coerce;
    private final Number nullValue;
    private final FieldValues<Number> scriptValues;
    private final boolean ignoreMalformedByDefault;
    private final boolean coerceByDefault;
    private final boolean dimension;
    private final ScriptCompiler scriptCompiler;
    private final Script script;
    private final TimeSeriesParams.MetricType metricType;
    private boolean allowMultipleValues;
    private final IndexVersion indexCreatedVersion;
    private final boolean storeMalformedFields;
    private final IndexMode indexMode;

    private static NumberFieldMapper toType(FieldMapper in) {
        return (NumberFieldMapper)in;
    }

    private NumberFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean storeMalformedFields, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.type = builder.type;
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.hasDocValues.getValue();
        this.stored = builder.stored.getValue();
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.coerce = builder.coerce.getValue();
        this.nullValue = builder.nullValue.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.coerceByDefault = builder.coerce.getDefaultValue().value();
        this.scriptValues = builder.scriptValues();
        this.dimension = builder.dimension.getValue();
        this.scriptCompiler = builder.scriptCompiler;
        this.script = builder.script.getValue();
        this.metricType = builder.metric.getValue();
        this.allowMultipleValues = builder.allowMultipleValues;
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.storeMalformedFields = storeMalformedFields;
        this.indexMode = builder.indexMode;
    }

    boolean coerce() {
        return this.coerce.value();
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    public NumberFieldType fieldType() {
        return (NumberFieldType)super.fieldType();
    }

    public NumberType type() {
        return this.type;
    }

    @Override
    protected String contentType() {
        return this.fieldType().type.typeName();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        Number value;
        try {
            value = this.value(context.parser());
        }
        catch (IllegalArgumentException e) {
            if (this.ignoreMalformed.value().booleanValue() && context.parser().currentToken().isValue()) {
                context.addIgnoredField(this.mappedFieldType.name());
                if (this.storeMalformedFields) {
                    context.doc().add(IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                }
                return;
            }
            throw e;
        }
        if (value != null) {
            this.indexValue(context, value);
        }
    }

    public Number value(XContentParser parser) throws IllegalArgumentException, IOException {
        XContentParser.Token currentToken = parser.currentToken();
        if (currentToken == XContentParser.Token.VALUE_NULL) {
            return this.nullValue;
        }
        if (this.coerce() && currentToken == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
            return this.nullValue;
        }
        if (currentToken == XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Cannot parse object as number");
        }
        return this.type.parse(parser, this.coerce());
    }

    public void indexValue(DocumentParserContext context, Number numericValue) {
        if (this.dimension && numericValue != null) {
            context.getRoutingFields().addLong(this.fieldType().name(), numericValue.longValue());
        }
        this.fieldType().type.addFields(context.doc(), this.fieldType().name(), numericValue, this.indexed, this.hasDocValues, this.stored);
        if (!this.allowMultipleValues && (this.indexed || this.hasDocValues || this.stored)) {
            List<IndexableField> fields = context.doc().getFields();
            IndexableField last = fields.get(fields.size() - 1);
            assert (last.name().equals(this.fieldType().name())) : "last field name [" + last.name() + "] mis match field name [" + this.fieldType().name() + "]";
            context.doc().onlyAddKey(this.fieldType().name(), fields.get(fields.size() - 1));
        }
        if (!this.hasDocValues && (this.stored || this.indexed)) {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (Number)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.type, this.scriptCompiler, this.ignoreMalformedByDefault, this.coerceByDefault, this.indexCreatedVersion, this.indexMode).dimension(this.dimension).metric(this.metricType).allowMultipleValues(this.allowMultipleValues).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.dimension && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> this.type.syntheticFieldLoader(this.fullPath(), this.leafName(), this.ignoreMalformed.value()));
        }
        return super.syntheticSourceSupport();
    }

    void setAllowMultipleValues(boolean allowMultipleValues) {
        this.allowMultipleValues = allowMultipleValues;
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> indexed;
        private final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> NumberFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> NumberFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Explicit<Boolean>> coerce;
        private final FieldMapper.Parameter<Number> nullValue;
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> NumberFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> NumberFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final FieldMapper.Parameter<Boolean> dimension;
        private final FieldMapper.Parameter<TimeSeriesParams.MetricType> metric;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final NumberType type;
        private boolean allowMultipleValues = true;
        private final IndexVersion indexCreatedVersion;
        private final IndexMode indexMode;

        public Builder(String name, NumberType type, ScriptCompiler compiler, Settings settings, IndexVersion indexCreatedVersion, IndexMode mode) {
            this(name, type, compiler, FieldMapper.IGNORE_MALFORMED_SETTING.get(settings), COERCE_SETTING.get(settings), indexCreatedVersion, mode);
        }

        public static Builder docValuesOnly(String name, NumberType type, IndexVersion indexCreatedVersion) {
            Builder builder = new Builder(name, type, ScriptCompiler.NONE, false, false, indexCreatedVersion, null);
            builder.indexed.setValue(false);
            builder.dimension.setValue(false);
            return builder;
        }

        public Builder(String name, NumberType type, ScriptCompiler compiler, boolean ignoreMalformedByDefault, boolean coerceByDefault, IndexVersion indexCreatedVersion, IndexMode mode) {
            super(name);
            this.type = type;
            this.scriptCompiler = Objects.requireNonNull(compiler);
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> NumberFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.coerce = FieldMapper.Parameter.explicitBoolParam("coerce", true, m -> NumberFieldMapper.toType((FieldMapper)m).coerce, coerceByDefault);
            this.nullValue = new FieldMapper.Parameter<Number>("null_value", false, () -> null, (n, c, o) -> o == null ? (Number)null : (Number)type.parse(o, false), m -> NumberFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
            this.indexMode = mode;
            this.indexed = FieldMapper.Parameter.indexParam(m -> NumberFieldMapper.toType((FieldMapper)m).indexed, () -> {
                if (this.indexMode == IndexMode.TIME_SERIES) {
                    TimeSeriesParams.MetricType metricType = this.getMetric().getValue();
                    return metricType != TimeSeriesParams.MetricType.COUNTER && metricType != TimeSeriesParams.MetricType.GAUGE;
                }
                return true;
            });
            this.dimension = TimeSeriesParams.dimensionParam(m -> NumberFieldMapper.toType((FieldMapper)m).dimension).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.hasDocValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.hasDocValues.name + "] are true");
                }
            });
            this.metric = TimeSeriesParams.metricParam(m -> NumberFieldMapper.toType((FieldMapper)m).metricType, TimeSeriesParams.MetricType.GAUGE, TimeSeriesParams.MetricType.COUNTER).addValidator(v -> {
                if (v != null && !this.hasDocValues.getValue().booleanValue()) {
                    throw new IllegalArgumentException("Field [time_series_metric] requires that [" + this.hasDocValues.name + "] is true");
                }
            }).precludesParameters(this.dimension);
            this.script.precludesParameters(this.ignoreMalformed, this.coerce, this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.hasDocValues);
        }

        Builder nullValue(Number number) {
            this.nullValue.setValue(number);
            return this;
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private FieldValues<Number> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            return this.type.compile(this.leafName(), this.script.get(), this.scriptCompiler);
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        public Builder metric(TimeSeriesParams.MetricType metric) {
            this.metric.setValue(metric);
            return this;
        }

        private FieldMapper.Parameter<TimeSeriesParams.MetricType> getMetric() {
            return this.metric;
        }

        public Builder allowMultipleValues(boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.coerce, this.nullValue, this.script, this.onScriptErrorParam, this.meta, this.dimension, this.metric};
        }

        @Override
        public NumberFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension.setValue(true);
            }
            NumberFieldType ft = new NumberFieldType(context.buildFullName(this.leafName()), this);
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.getValue();
            return new NumberFieldMapper(this.leafName(), ft, this.builderParams(this, context), context.isSourceSynthetic(), this);
        }
    }

    public static enum NumberType {
        HALF_FLOAT("half_float", IndexNumericFieldData.NumericType.HALF_FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result = 1.parseToFloat(value);
                1.validateFiniteValue(result);
                return Float.valueOf(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)result)));
            }

            @Override
            public double reduceToStoredPrecision(double value) {
                return this.parse(value, false).doubleValue();
            }

            private static float parseToFloat(Object value) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                return result;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(HalfFloatPoint.decodeDimension((byte[])value, (int)0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                1.validateFiniteValue(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                float v = 1.parseToFloat(value);
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)v)))) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                if (isIndexed) {
                    return HalfFloatPoint.newExactQuery((String)field, (float)v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery(field, HalfFloatPoint.halfFloatToSortableShort((float)v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                float[] v = new float[values.size()];
                int pos = 0;
                for (Object value : values) {
                    float float_value = 1.parseToFloat(value);
                    1.validateFiniteValue(float_value);
                    v[pos++] = float_value;
                }
                return HalfFloatPoint.newSetQuery((String)field, (float[])v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = 1.parseToFloat(lowerTerm);
                    if (includeLower) {
                        l = HalfFloatPoint.nextDown((float)l);
                    }
                    l = HalfFloatPoint.nextUp((float)l);
                }
                if (upperTerm != null) {
                    u = 1.parseToFloat(upperTerm);
                    if (includeUpper) {
                        u = HalfFloatPoint.nextUp((float)u);
                    }
                    u = HalfFloatPoint.nextDown((float)u);
                }
                if (isIndexed) {
                    query = HalfFloatPoint.newRangeQuery((String)field, (float)l, (float)u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort((float)l), HalfFloatPoint.halfFloatToSortableShort((float)u));
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery(field, HalfFloatPoint.halfFloatToSortableShort((float)l), HalfFloatPoint.halfFloatToSortableShort((float)u));
                }
                return query;
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                float f = value.floatValue();
                if (indexed) {
                    document.add((IndexableField)new HalfFloatPoint(name, new float[]{f}));
                }
                if (docValued) {
                    document.add(new SortedNumericDocValuesField(name, HalfFloatPoint.halfFloatToSortableShort((float)f)));
                }
                if (stored) {
                    document.add(new StoredField(name, f));
                }
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedDoublesIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, HalfFloatDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedDoubleIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, HalfFloatDocValuesField::new);
            }

            private static void validateFiniteValue(float value) {
                if (!Float.isFinite(HalfFloatPoint.sortableShortToHalfFloat((short)HalfFloatPoint.halfFloatToSortableShort((float)value)))) {
                    throw new IllegalArgumentException("[half_float] supports only finite values, but got [" + value + "]");
                }
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return new SortedNumericDocValuesSyntheticFieldLoader(this, fieldName, fieldSimpleName, ignoreMalformed){

                    @Override
                    protected void writeValue(XContentBuilder b, long value) throws IOException {
                        b.value(HalfFloatPoint.sortableShortToHalfFloat((short)((short)value)));
                    }
                };
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.DoublesBlockLoader(fieldName, l -> HalfFloatPoint.sortableShortToHalfFloat((short)((short)l)));
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.DoublesBlockLoader(sourceValueFetcher, lookup);
            }
        }
        ,
        FLOAT("float", IndexNumericFieldData.NumericType.FLOAT){

            @Override
            public Float parse(Object value, boolean coerce) {
                float result = 2.parseToFloat(value);
                2.validateFiniteValue(result);
                return Float.valueOf(result);
            }

            private static float parseToFloat(Object value) {
                float result;
                if (value instanceof Number) {
                    result = ((Number)value).floatValue();
                } else {
                    if (value instanceof BytesRef) {
                        value = ((BytesRef)value).utf8ToString();
                    }
                    result = Float.parseFloat(value.toString());
                }
                return result;
            }

            @Override
            public double reduceToStoredPrecision(double value) {
                return this.parse(value, false).doubleValue();
            }

            @Override
            public Number parsePoint(byte[] value) {
                return Float.valueOf(FloatPoint.decodeDimension(value, 0));
            }

            @Override
            public Float parse(XContentParser parser, boolean coerce) throws IOException {
                float parsed = parser.floatValue(coerce);
                2.validateFiniteValue(parsed);
                return Float.valueOf(parsed);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                float v = 2.parseToFloat(value);
                if (!Float.isFinite(v)) {
                    return new MatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                if (isIndexed) {
                    return FloatPoint.newExactQuery(field, v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.floatToSortableInt(v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                float[] v = new float[values.size()];
                int pos = 0;
                for (Object value : values) {
                    v[pos++] = this.parse(value, false).floatValue();
                }
                return FloatPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                float l = Float.NEGATIVE_INFINITY;
                float u = Float.POSITIVE_INFINITY;
                if (lowerTerm != null) {
                    l = 2.parseToFloat(lowerTerm);
                    if (includeLower) {
                        l = FloatPoint.nextDown(l);
                    }
                    l = FloatPoint.nextUp(l);
                }
                if (upperTerm != null) {
                    u = 2.parseToFloat(upperTerm);
                    if (includeUpper) {
                        u = FloatPoint.nextUp(u);
                    }
                    u = FloatPoint.nextDown(u);
                }
                if (isIndexed) {
                    query = FloatPoint.newRangeQuery(field, l, u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.floatToSortableInt(l), NumericUtils.floatToSortableInt(u));
                }
                return query;
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                float f = value.floatValue();
                if (indexed && docValued) {
                    document.add(new FloatField(name, f, Field.Store.NO));
                } else if (docValued) {
                    document.add(new SortedNumericDocValuesField(name, NumericUtils.floatToSortableInt(f)));
                } else if (indexed) {
                    document.add(new FloatPoint(name, f));
                }
                if (stored) {
                    document.add(new StoredField(name, f));
                }
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedDoublesIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, FloatDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedDoubleIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, FloatDocValuesField::new);
            }

            private static void validateFiniteValue(float value) {
                if (!Float.isFinite(value)) {
                    throw new IllegalArgumentException("[float] supports only finite values, but got [" + value + "]");
                }
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return new SortedNumericDocValuesSyntheticFieldLoader(this, fieldName, fieldSimpleName, ignoreMalformed){

                    @Override
                    protected void writeValue(XContentBuilder b, long value) throws IOException {
                        b.value(NumericUtils.sortableIntToFloat((int)value));
                    }
                };
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.DoublesBlockLoader(fieldName, l -> NumericUtils.sortableIntToFloat((int)l));
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.DoublesBlockLoader(sourceValueFetcher, lookup);
            }
        }
        ,
        DOUBLE("double", IndexNumericFieldData.NumericType.DOUBLE){

            @Override
            public Double parse(Object value, boolean coerce) {
                double parsed = 3.objectToDouble(value);
                3.validateParsed(parsed);
                return parsed;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return DoublePoint.decodeDimension(value, 0);
            }

            @Override
            public Double parse(XContentParser parser, boolean coerce) throws IOException {
                double parsed = parser.doubleValue(coerce);
                3.validateParsed(parsed);
                return parsed;
            }

            @Override
            public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
                DoubleFieldScript.Factory scriptFactory = compiler.compile(script, DoubleFieldScript.CONTEXT);
                return (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(fieldName, script.getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer::accept);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                double v = 3.objectToDouble(value);
                if (!Double.isFinite(v)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (isIndexed) {
                    return DoublePoint.newExactQuery(field, v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery(field, NumericUtils.doubleToSortableLong(v));
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                double[] v = values.stream().mapToDouble(value -> this.parse(value, false)).toArray();
                return DoublePoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return 3.doubleRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query;
                    if (isIndexed) {
                        query = DoublePoint.newRangeQuery(field, l, u);
                        if (hasDocValues) {
                            Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                            query = new IndexOrDocValuesQuery(query, dvQuery);
                        }
                    } else {
                        query = SortedNumericDocValuesField.newSlowRangeQuery(field, NumericUtils.doubleToSortableLong(l), NumericUtils.doubleToSortableLong(u));
                    }
                    return query;
                });
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                double d = value.doubleValue();
                if (indexed && docValued) {
                    document.add(new DoubleField(name, d, Field.Store.NO));
                } else if (docValued) {
                    document.add(new SortedNumericDocValuesField(name, NumericUtils.doubleToSortableLong(d)));
                } else if (indexed) {
                    document.add(new DoublePoint(name, d));
                }
                if (stored) {
                    document.add(new StoredField(name, d));
                }
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedDoublesIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, DoubleDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedDoubleIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, DoubleDocValuesField::new);
            }

            private static void validateParsed(double value) {
                if (!Double.isFinite(value)) {
                    throw new IllegalArgumentException("[double] supports only finite values, but got [" + value + "]");
                }
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return new SortedNumericDocValuesSyntheticFieldLoader(this, fieldName, fieldSimpleName, ignoreMalformed){

                    @Override
                    protected void writeValue(XContentBuilder b, long value) throws IOException {
                        b.value(NumericUtils.sortableLongToDouble(value));
                    }
                };
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.DoublesBlockLoader(fieldName, NumericUtils::sortableLongToDouble);
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.DoublesBlockLoader(sourceValueFetcher, lookup);
            }
        }
        ,
        BYTE("byte", IndexNumericFieldData.NumericType.BYTE){

            @Override
            public Byte parse(Object value, boolean coerce) {
                double doubleValue = 4.objectToDouble(value);
                if (doubleValue < -128.0 || doubleValue > 127.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a byte");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).byteValue();
                }
                return (byte)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).byteValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                int value = parser.intValue(coerce);
                if (value < -128 || value > 127) {
                    throw new IllegalArgumentException("Value [" + value + "] is out of range for a byte");
                }
                return (short)value;
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (this.isOutOfRange(value)) {
                    return new MatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                return INTEGER.termQuery(field, value, isIndexed);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context, isIndexed);
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                INTEGER.addFields(document, name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.byteValue();
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedNumericIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, ByteDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, ByteDocValuesField::new);
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return NumberType.syntheticLongFieldLoader(fieldName, fieldSimpleName, ignoreMalformed);
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.IntsBlockLoader(fieldName);
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.IntsBlockLoader(sourceValueFetcher, lookup);
            }

            private boolean isOutOfRange(Object value) {
                double doubleValue = 4.objectToDouble(value);
                return doubleValue < -128.0 || doubleValue > 127.0;
            }
        }
        ,
        SHORT("short", IndexNumericFieldData.NumericType.SHORT){

            @Override
            public Short parse(Object value, boolean coerce) {
                double doubleValue = 5.objectToDouble(value);
                if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a short");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).shortValue();
                }
                return (short)doubleValue;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return INTEGER.parsePoint(value).shortValue();
            }

            @Override
            public Short parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.shortValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (this.isOutOfRange(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                return INTEGER.termQuery(field, value, isIndexed);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                return INTEGER.termsQuery(field, values);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return INTEGER.rangeQuery(field, lowerTerm, upperTerm, includeLower, includeUpper, hasDocValues, context, isIndexed);
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                INTEGER.addFields(document, name, value, indexed, docValued, stored);
            }

            @Override
            Number valueForSearch(Number value) {
                return value.shortValue();
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedNumericIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, ShortDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, ShortDocValuesField::new);
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return NumberType.syntheticLongFieldLoader(fieldName, fieldSimpleName, ignoreMalformed);
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.IntsBlockLoader(fieldName);
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.IntsBlockLoader(sourceValueFetcher, lookup);
            }

            private boolean isOutOfRange(Object value) {
                double doubleValue = 5.objectToDouble(value);
                return doubleValue < -32768.0 || doubleValue > 32767.0;
            }
        }
        ,
        INTEGER("integer", IndexNumericFieldData.NumericType.INT){

            @Override
            public Integer parse(Object value, boolean coerce) {
                double doubleValue = 6.objectToDouble(value);
                if (this.isOutOfRange(doubleValue)) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for an integer");
                }
                if (!coerce && doubleValue % 1.0 != 0.0) {
                    throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return (int)doubleValue;
            }

            private boolean isOutOfRange(double value) {
                return value < -2.147483648E9 || value > 2.147483647E9;
            }

            @Override
            public Number parsePoint(byte[] value) {
                return IntPoint.decodeDimension(value, 0);
            }

            @Override
            public Integer parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.intValue(coerce);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (6.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                double doubleValue = 6.objectToDouble(value);
                if (this.isOutOfRange(doubleValue)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                int v = this.parse(value, true);
                if (isIndexed) {
                    return IntPoint.newExactQuery(field, v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                int[] v = new int[values.size()];
                int upTo = 0;
                for (Object value : values) {
                    if (6.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return IntPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                Query query;
                int l = Integer.MIN_VALUE;
                int u = Integer.MAX_VALUE;
                if (lowerTerm != null) {
                    l = this.parse(lowerTerm, true);
                    boolean lowerTermHasDecimalPart = 6.hasDecimalPart(lowerTerm);
                    if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && 6.signum(lowerTerm) > 0.0) {
                        if (l == Integer.MAX_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        ++l;
                    }
                }
                if (upperTerm != null) {
                    u = this.parse(upperTerm, true);
                    boolean upperTermHasDecimalPart = 6.hasDecimalPart(upperTerm);
                    if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && 6.signum(upperTerm) < 0.0) {
                        if (u == Integer.MIN_VALUE) {
                            return new MatchNoDocsQuery();
                        }
                        --u;
                    }
                }
                if (isIndexed) {
                    query = IntPoint.newRangeQuery(field, l, u);
                    if (hasDocValues) {
                        Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                        query = new IndexOrDocValuesQuery(query, dvQuery);
                    }
                } else {
                    query = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                }
                if (hasDocValues && context.indexSortedOnField(field)) {
                    query = new IndexSortSortedNumericDocValuesRangeQuery(field, l, u, query);
                }
                return query;
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                int i = value.intValue();
                if (indexed && docValued) {
                    document.add(new IntField(name, i, Field.Store.NO));
                } else if (docValued) {
                    document.add(new SortedNumericDocValuesField(name, i));
                } else if (indexed) {
                    document.add(new IntPoint(name, i));
                }
                if (stored) {
                    document.add(new StoredField(name, i));
                }
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedNumericIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, IntegerDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, IntegerDocValuesField::new);
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return NumberType.syntheticLongFieldLoader(fieldName, fieldSimpleName, ignoreMalformed);
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.IntsBlockLoader(fieldName);
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.IntsBlockLoader(sourceValueFetcher, lookup);
            }
        }
        ,
        LONG("long", IndexNumericFieldData.NumericType.LONG){

            @Override
            public Long parse(Object value, boolean coerce) {
                return 7.objectToLong(value, coerce);
            }

            @Override
            public Number parsePoint(byte[] value) {
                return LongPoint.decodeDimension(value, 0);
            }

            @Override
            public Long parse(XContentParser parser, boolean coerce) throws IOException {
                return parser.longValue(coerce);
            }

            @Override
            public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
                LongFieldScript.Factory scriptFactory = compiler.compile(script, LongFieldScript.CONTEXT);
                return (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(fieldName, script.getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer::accept);
            }

            @Override
            public Query termQuery(String field, Object value, boolean isIndexed) {
                if (7.hasDecimalPart(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] has a decimal part");
                }
                if (this.isOutOfRange(value)) {
                    return Queries.newMatchNoDocsQuery("Value [" + String.valueOf(value) + "] is out of range");
                }
                long v = this.parse(value, true);
                if (isIndexed) {
                    return LongPoint.newExactQuery(field, v);
                }
                return SortedNumericDocValuesField.newSlowExactQuery(field, v);
            }

            @Override
            public Query termsQuery(String field, Collection<?> values) {
                long[] v = new long[values.size()];
                int upTo = 0;
                for (Object value : values) {
                    if (7.hasDecimalPart(value)) continue;
                    v[upTo++] = this.parse(value, true);
                }
                if (upTo == 0) {
                    return Queries.newMatchNoDocsQuery("All values have a decimal part");
                }
                if (upTo != v.length) {
                    v = Arrays.copyOf(v, upTo);
                }
                return LongPoint.newSetQuery(field, v);
            }

            @Override
            public Query rangeQuery(String field, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, boolean hasDocValues, SearchExecutionContext context, boolean isIndexed) {
                return 7.longRangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, (l, u) -> {
                    Query query;
                    if (isIndexed) {
                        query = LongPoint.newRangeQuery(field, l, u);
                        if (hasDocValues) {
                            Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                            query = new IndexOrDocValuesQuery(query, dvQuery);
                        }
                    } else {
                        query = SortedNumericDocValuesField.newSlowRangeQuery(field, l, u);
                    }
                    if (hasDocValues && context.indexSortedOnField(field)) {
                        query = new IndexSortSortedNumericDocValuesRangeQuery(field, (long)l, (long)u, query);
                    }
                    return query;
                });
            }

            @Override
            public void addFields(LuceneDocument document, String name, Number value, boolean indexed, boolean docValued, boolean stored) {
                long l = value.longValue();
                if (indexed && docValued) {
                    document.add(new LongField(name, l, Field.Store.NO));
                } else if (docValued) {
                    document.add(new SortedNumericDocValuesField(name, l));
                } else if (indexed) {
                    document.add(new LongPoint(name, l));
                }
                if (stored) {
                    document.add(new StoredField(name, l));
                }
            }

            @Override
            public IndexFieldData.Builder getFieldDataBuilder(MappedFieldType ft, ValuesSourceType valuesSourceType) {
                return new SortedNumericIndexFieldData.Builder(ft.name(), this.numericType(), valuesSourceType, LongDocValuesField::new, ft.isIndexed());
            }

            @Override
            public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
                return new SourceValueFetcherSortedNumericIndexFieldData.Builder(name, valuesSourceType, valueFetcher, sourceProvider, LongDocValuesField::new);
            }

            @Override
            SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
                return NumberType.syntheticLongFieldLoader(fieldName, fieldSimpleName, ignoreMalformed);
            }

            @Override
            BlockLoader blockLoaderFromDocValues(String fieldName) {
                return new BlockDocValuesReader.LongsBlockLoader(fieldName);
            }

            @Override
            BlockLoader blockLoaderFromSource(SourceValueFetcher sourceValueFetcher, BlockSourceReader.LeafIteratorLookup lookup) {
                return new BlockSourceReader.LongsBlockLoader(sourceValueFetcher, lookup);
            }

            private boolean isOutOfRange(Object value) {
                if (value instanceof Long) {
                    return false;
                }
                String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                return bigDecimalValue.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0 || bigDecimalValue.compareTo(BigDecimal.valueOf(Long.MIN_VALUE)) < 0;
            }
        };

        private final String name;
        private final IndexNumericFieldData.NumericType numericType;
        private final FieldMapper.TypeParser parser;

        private NumberType(String name, IndexNumericFieldData.NumericType numericType) {
            this.name = name;
            this.numericType = numericType;
            this.parser = FieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, this, c.scriptCompiler(), c.getSettings(), c.indexVersionCreated(), c.getIndexSettings().getMode()));
        }

        public final String typeName() {
            return this.name;
        }

        public final IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public final FieldMapper.TypeParser parser() {
            return this.parser;
        }

        public abstract Query termQuery(String var1, Object var2, boolean var3);

        public abstract Query termsQuery(String var1, Collection<?> var2);

        public abstract Query rangeQuery(String var1, Object var2, Object var3, boolean var4, boolean var5, boolean var6, SearchExecutionContext var7, boolean var8);

        public abstract Number parse(XContentParser var1, boolean var2) throws IOException;

        public abstract Number parse(Object var1, boolean var2);

        public abstract Number parsePoint(byte[] var1);

        public abstract void addFields(LuceneDocument var1, String var2, Number var3, boolean var4, boolean var5, boolean var6);

        public FieldValues<Number> compile(String fieldName, Script script, ScriptCompiler compiler) {
            throw new IllegalArgumentException("Unknown parameter [script] for mapper [" + fieldName + "]");
        }

        Number valueForSearch(Number value) {
            return value;
        }

        public static boolean hasDecimalPart(Object number) {
            if (number instanceof Byte || number instanceof Short || number instanceof Integer || number instanceof Long) {
                return false;
            }
            if (number instanceof Number) {
                double doubleValue = ((Number)number).doubleValue();
                return doubleValue % 1.0 != 0.0;
            }
            if (number instanceof BytesRef) {
                number = ((BytesRef)number).utf8ToString();
            }
            if (number instanceof String) {
                return Double.parseDouble((String)number) % 1.0 != 0.0;
            }
            return false;
        }

        static double signum(Object value) {
            if (value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                return Math.signum(doubleValue);
            }
            if (value instanceof BytesRef) {
                value = ((BytesRef)value).utf8ToString();
            }
            return Math.signum(Double.parseDouble(value.toString()));
        }

        public static double objectToDouble(Object value) {
            double doubleValue = value instanceof Number ? ((Number)value).doubleValue() : (value instanceof BytesRef ? Double.parseDouble(((BytesRef)value).utf8ToString()) : Double.parseDouble(value.toString()));
            return doubleValue;
        }

        public static long objectToLong(Object value, boolean coerce) {
            if (value instanceof Long) {
                return (Long)value;
            }
            double doubleValue = NumberType.objectToDouble(value);
            if (doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] is out of range for a long");
            }
            if (!coerce && doubleValue % 1.0 != 0.0) {
                throw new IllegalArgumentException("Value [" + String.valueOf(value) + "] has a decimal part");
            }
            String stringValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return Numbers.toLong(stringValue, coerce);
        }

        public static Query doubleRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Double, Double, Query> builder) {
            double l = Double.NEGATIVE_INFINITY;
            double u = Double.POSITIVE_INFINITY;
            if (lowerTerm != null) {
                l = NumberType.objectToDouble(lowerTerm);
                if (!includeLower) {
                    l = DoublePoint.nextUp(l);
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToDouble(upperTerm);
                if (!includeUpper) {
                    u = DoublePoint.nextDown(u);
                }
            }
            return builder.apply(l, u);
        }

        public static Query longRangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, BiFunction<Long, Long, Query> builder) {
            long l = Long.MIN_VALUE;
            long u = Long.MAX_VALUE;
            if (lowerTerm != null) {
                l = NumberType.objectToLong(lowerTerm, true);
                boolean lowerTermHasDecimalPart = NumberType.hasDecimalPart(lowerTerm);
                if (!lowerTermHasDecimalPart && !includeLower || lowerTermHasDecimalPart && NumberType.signum(lowerTerm) > 0.0) {
                    if (l == Long.MAX_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    ++l;
                }
            }
            if (upperTerm != null) {
                u = NumberType.objectToLong(upperTerm, true);
                boolean upperTermHasDecimalPart = NumberType.hasDecimalPart(upperTerm);
                if (!upperTermHasDecimalPart && !includeUpper || upperTermHasDecimalPart && NumberType.signum(upperTerm) < 0.0) {
                    if (u == Long.MIN_VALUE) {
                        return new MatchNoDocsQuery();
                    }
                    --u;
                }
            }
            return builder.apply(l, u);
        }

        public abstract IndexFieldData.Builder getFieldDataBuilder(MappedFieldType var1, ValuesSourceType var2);

        public IndexFieldData.Builder getValueFetcherFieldDataBuilder(String name, ValuesSourceType valuesSourceType, SourceProvider sourceProvider, ValueFetcher valueFetcher) {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        public double reduceToStoredPrecision(double value) {
            return value;
        }

        abstract SourceLoader.SyntheticFieldLoader syntheticFieldLoader(String var1, String var2, boolean var3);

        private static SourceLoader.SyntheticFieldLoader syntheticLongFieldLoader(String fieldName, String fieldSimpleName, boolean ignoreMalformed) {
            return new SortedNumericDocValuesSyntheticFieldLoader(fieldName, fieldSimpleName, ignoreMalformed){

                @Override
                protected void writeValue(XContentBuilder b, long value) throws IOException {
                    b.value(value);
                }
            };
        }

        abstract BlockLoader blockLoaderFromDocValues(String var1);

        abstract BlockLoader blockLoaderFromSource(SourceValueFetcher var1, BlockSourceReader.LeafIteratorLookup var2);
    }

    public static class NumberFieldType
    extends SimpleMappedFieldType {
        private final NumberType type;
        private final boolean coerce;
        private final Number nullValue;
        private final FieldValues<Number> scriptValues;
        private final boolean isDimension;
        private final TimeSeriesParams.MetricType metricType;
        private final IndexMode indexMode;

        public NumberFieldType(String name, NumberType type, boolean isIndexed, boolean isStored, boolean hasDocValues, boolean coerce, Number nullValue, Map<String, String> meta, FieldValues<Number> script, boolean isDimension, TimeSeriesParams.MetricType metricType, IndexMode indexMode) {
            super(name, isIndexed, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_WITHOUT_TERMS, meta);
            this.type = Objects.requireNonNull(type);
            this.coerce = coerce;
            this.nullValue = nullValue;
            this.scriptValues = script;
            this.isDimension = isDimension;
            this.metricType = metricType;
            this.indexMode = indexMode;
        }

        NumberFieldType(String name, Builder builder) {
            this(name, builder.type, builder.indexed.getValue() != false && !builder.indexCreatedVersion.isLegacyIndexVersion(), builder.stored.getValue(), builder.hasDocValues.getValue(), builder.coerce.getValue().value(), builder.nullValue.getValue(), builder.meta.getValue(), builder.scriptValues(), builder.dimension.getValue(), builder.metric.getValue(), builder.indexMode);
        }

        public NumberFieldType(String name, NumberType type) {
            this(name, type, true);
        }

        public NumberFieldType(String name, NumberType type, boolean isIndexed) {
            this(name, type, isIndexed, false, true, true, null, Collections.emptyMap(), null, false, null, null);
        }

        @Override
        public String typeName() {
            return this.type.name;
        }

        public double reduceToStoredPrecision(double value) {
            if (Double.isInfinite(value)) {
                return value;
            }
            return this.type.reduceToStoredPrecision(value);
        }

        public IndexNumericFieldData.NumericType numericType() {
            return this.type.numericType();
        }

        @Override
        public boolean mayExistInIndex(SearchExecutionContext context) {
            return context.fieldExistsInIndex(this.name());
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return this.type.termQuery(this.name(), value, this.isIndexed());
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return this.type.termsQuery(this.name(), values);
            }
            return super.termsQuery(values, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            return this.type.rangeQuery(this.name(), lowerTerm, upperTerm, includeLower, includeUpper, this.hasDocValues(), context, this.isIndexed());
        }

        @Override
        public Function<byte[], Number> pointReaderIfPossible() {
            if (this.isIndexed()) {
                return this::parsePoint;
            }
            return null;
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return this.type.blockLoaderFromDocValues(this.name());
            }
            BlockSourceReader.LeafIteratorLookup lookup = this.isStored() || this.isIndexed() ? BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name()) : BlockSourceReader.lookupMatchingAll();
            return this.type.blockLoaderFromSource(this.sourceValueFetcher(blContext.sourcePaths(this.name())), lookup);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            ValuesSourceType valuesSourceType;
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (fieldDataContext.fielddataOperation() == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            ValuesSourceType valuesSourceType2 = valuesSourceType = this.indexMode == IndexMode.TIME_SERIES && this.metricType == TimeSeriesParams.MetricType.COUNTER ? TimeSeriesValuesSourceType.COUNTER : this.type.numericType.getValuesSourceType();
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                return this.type.getFieldDataBuilder(this, valuesSourceType);
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return this.type.getValueFetcherFieldDataBuilder(this.name(), valuesSourceType, searchLookup, this.sourceValueFetcher(sourcePaths));
            }
            throw new IllegalStateException("unknown field data type [" + operation.name() + "]");
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return this.type.valueForSearch((Number)value);
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(sourcePaths, (Object)this.nullValue){

                @Override
                protected Object parseSourceValue(Object value) {
                    if (value.equals("")) {
                        return nullValue;
                    }
                    return type.parse(value, coerce);
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            this.checkNoTimeZone(timeZone);
            if (format == null) {
                return DocValueFormat.RAW;
            }
            return new DocValueFormat.Decimal(format);
        }

        public Number parsePoint(byte[] value) {
            return this.type.parsePoint(value);
        }

        @Override
        public MappedFieldType.CollapseType collapseType() {
            return MappedFieldType.CollapseType.NUMERIC;
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public boolean hasScriptValues() {
            return this.scriptValues != null;
        }

        @Override
        public TimeSeriesParams.MetricType getMetricType() {
            return this.metricType;
        }
    }
}

