/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.health;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.health.ImpactArea;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record HealthIndicatorImpact(String indicatorName, String id, int severity, String impactDescription, List<ImpactArea> impactAreas) implements ToXContentObject
{
    public HealthIndicatorImpact {
        if (severity < 0) {
            throw new IllegalArgumentException("Severity cannot be less than 0");
        }
        if (Strings.isEmpty(impactDescription)) {
            throw new IllegalArgumentException("Impact description must be provided");
        }
        if (impactAreas == null || impactAreas.isEmpty()) {
            throw new IllegalArgumentException("At least one impact area must be provided");
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", "elasticsearch:health:" + this.indicatorName + ":impact:" + this.id);
        builder.field("severity", this.severity);
        builder.field("description", this.impactDescription);
        builder.startArray("impact_areas");
        for (ImpactArea impactArea : this.impactAreas) {
            builder.value(impactArea.displayValue());
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }
}

