/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import java.util.Map;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.WriteLoadForecaster;
import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalance;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardAssignment;
import org.elasticsearch.cluster.routing.allocation.allocator.WeightFunction;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;

public class NodeAllocationStatsAndWeightsCalculator {
    private final WriteLoadForecaster writeLoadForecaster;
    private volatile float indexBalanceFactor;
    private volatile float shardBalanceFactor;
    private volatile float writeLoadBalanceFactor;
    private volatile float diskUsageBalanceFactor;

    public NodeAllocationStatsAndWeightsCalculator(WriteLoadForecaster writeLoadForecaster, ClusterSettings clusterSettings) {
        this.writeLoadForecaster = writeLoadForecaster;
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.SHARD_BALANCE_FACTOR_SETTING, value -> {
            this.shardBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.INDEX_BALANCE_FACTOR_SETTING, value -> {
            this.indexBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.WRITE_LOAD_BALANCE_FACTOR_SETTING, value -> {
            this.writeLoadBalanceFactor = value.floatValue();
        });
        clusterSettings.initializeAndWatch(BalancedShardsAllocator.DISK_USAGE_BALANCE_FACTOR_SETTING, value -> {
            this.diskUsageBalanceFactor = value.floatValue();
        });
    }

    public Map<String, NodeAllocationStatsAndWeight> nodesAllocationStatsAndWeights(Metadata metadata, RoutingNodes routingNodes, ClusterInfo clusterInfo, @Nullable DesiredBalance desiredBalance) {
        if (!metadata.indices().isEmpty()) {
            this.writeLoadForecaster.refreshLicense();
        }
        WeightFunction weightFunction = new WeightFunction(this.shardBalanceFactor, this.indexBalanceFactor, this.writeLoadBalanceFactor, this.diskUsageBalanceFactor);
        float avgShardsPerNode = WeightFunction.avgShardPerNode(metadata, routingNodes);
        double avgWriteLoadPerNode = WeightFunction.avgWriteLoadPerNode(this.writeLoadForecaster, metadata, routingNodes);
        double avgDiskUsageInBytesPerNode = WeightFunction.avgDiskUsageInBytesPerNode(clusterInfo, metadata, routingNodes);
        Map<String, NodeAllocationStatsAndWeight> nodeAllocationStatsAndWeights = Maps.newMapWithExpectedSize(routingNodes.size());
        for (RoutingNode node : routingNodes) {
            int shards = 0;
            int undesiredShards = 0;
            double forecastedWriteLoad = 0.0;
            long forecastedDiskUsage = 0L;
            long currentDiskUsage = 0L;
            for (ShardRouting shardRouting : node) {
                if (shardRouting.relocating()) continue;
                ++shards;
                IndexMetadata indexMetadata = metadata.getIndexSafe(shardRouting.index());
                if (!NodeAllocationStatsAndWeightsCalculator.isDesiredAllocation(desiredBalance, shardRouting)) {
                    ++undesiredShards;
                }
                long shardSize = clusterInfo.getShardSize(shardRouting.shardId(), shardRouting.primary(), 0L);
                forecastedWriteLoad += this.writeLoadForecaster.getForecastedWriteLoad(indexMetadata).orElse(0.0);
                forecastedDiskUsage += Math.max(indexMetadata.getForecastedShardSizeInBytes().orElse(0L), shardSize);
                currentDiskUsage += shardSize;
            }
            float currentNodeWeight = weightFunction.calculateNodeWeight(shards, avgShardsPerNode, forecastedWriteLoad, avgWriteLoadPerNode, currentDiskUsage, avgDiskUsageInBytesPerNode);
            nodeAllocationStatsAndWeights.put(node.nodeId(), new NodeAllocationStatsAndWeight(shards, desiredBalance != null ? undesiredShards : -1, forecastedWriteLoad, forecastedDiskUsage, currentDiskUsage, currentNodeWeight));
        }
        return nodeAllocationStatsAndWeights;
    }

    private static boolean isDesiredAllocation(@Nullable DesiredBalance desiredBalance, ShardRouting shardRouting) {
        if (desiredBalance == null) {
            return true;
        }
        ShardAssignment assignment = desiredBalance.getAssignment(shardRouting.shardId());
        if (assignment == null) {
            return false;
        }
        return assignment.nodeIds().contains(shardRouting.currentNodeId());
    }

    public record NodeAllocationStatsAndWeight(int shards, int undesiredShards, double forecastedIngestLoad, long forecastedDiskUsage, long currentDiskUsage, float currentNodeWeight) {
    }
}

