/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;

public record LifecycleExecutionState(String phase, String action, String step, String failedStep, Boolean isAutoRetryableError, Integer failedStepRetryCount, String stepInfo, String previousStepInfo, String phaseDefinition, Long lifecycleDate, Long phaseTime, Long actionTime, Long stepTime, String snapshotRepository, String snapshotName, String shrinkIndexName, String snapshotIndexName, String downsampleIndexName) {
    public static final String ILM_CUSTOM_METADATA_KEY = "ilm";
    private static final String PHASE = "phase";
    private static final String ACTION = "action";
    private static final String STEP = "step";
    private static final String INDEX_CREATION_DATE = "creation_date";
    private static final String PHASE_TIME = "phase_time";
    private static final String ACTION_TIME = "action_time";
    private static final String STEP_TIME = "step_time";
    private static final String FAILED_STEP = "failed_step";
    private static final String IS_AUTO_RETRYABLE_ERROR = "is_auto_retryable_error";
    private static final String FAILED_STEP_RETRY_COUNT = "failed_step_retry_count";
    private static final String STEP_INFO = "step_info";
    private static final String PREVIOUS_STEP_INFO = "previous_step_info";
    private static final String PHASE_DEFINITION = "phase_definition";
    private static final String SNAPSHOT_NAME = "snapshot_name";
    private static final String SNAPSHOT_REPOSITORY = "snapshot_repository";
    private static final String SNAPSHOT_INDEX_NAME = "snapshot_index_name";
    private static final String SHRINK_INDEX_NAME = "shrink_index_name";
    private static final String DOWNSAMPLE_INDEX_NAME = "rollup_index_name";
    public static final LifecycleExecutionState EMPTY_STATE = LifecycleExecutionState.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(LifecycleExecutionState state) {
        return new Builder().setPhase(state.phase).setAction(state.action).setStep(state.step).setFailedStep(state.failedStep).setIsAutoRetryableError(state.isAutoRetryableError).setFailedStepRetryCount(state.failedStepRetryCount).setStepInfo(state.stepInfo).setPreviousStepInfo(state.previousStepInfo).setPhaseDefinition(state.phaseDefinition).setIndexCreationDate(state.lifecycleDate).setPhaseTime(state.phaseTime).setActionTime(state.actionTime).setSnapshotRepository(state.snapshotRepository).setSnapshotName(state.snapshotName).setShrinkIndexName(state.shrinkIndexName).setSnapshotIndexName(state.snapshotIndexName).setDownsampleIndexName(state.downsampleIndexName).setStepTime(state.stepTime);
    }

    public static LifecycleExecutionState fromCustomMetadata(Map<String, String> customData) {
        String downsampleIndexName;
        String snapshotIndexName;
        String stepTime;
        String actionTime;
        String phaseTime;
        String indexCreationDate;
        String shrinkIndexName;
        String snapshotName;
        String snapShotRepository;
        String phaseDefinition;
        String previousStepInfo;
        String stepInfo;
        String failedStepRetryCount;
        String isAutoRetryableError;
        String failedStep;
        String step;
        String action;
        Builder builder = LifecycleExecutionState.builder();
        String phase = customData.get(PHASE);
        if (phase != null) {
            builder.setPhase(phase);
        }
        if ((action = customData.get(ACTION)) != null) {
            builder.setAction(action);
        }
        if ((step = customData.get(STEP)) != null) {
            builder.setStep(step);
        }
        if ((failedStep = customData.get(FAILED_STEP)) != null) {
            builder.setFailedStep(failedStep);
        }
        if ((isAutoRetryableError = customData.get(IS_AUTO_RETRYABLE_ERROR)) != null) {
            builder.setIsAutoRetryableError(Boolean.parseBoolean(isAutoRetryableError));
        }
        if ((failedStepRetryCount = customData.get(FAILED_STEP_RETRY_COUNT)) != null) {
            builder.setFailedStepRetryCount(Integer.parseInt(failedStepRetryCount));
        }
        if ((stepInfo = customData.get(STEP_INFO)) != null) {
            builder.setStepInfo(stepInfo);
        }
        if ((previousStepInfo = customData.get(PREVIOUS_STEP_INFO)) != null) {
            builder.setPreviousStepInfo(previousStepInfo);
        }
        if ((phaseDefinition = customData.get(PHASE_DEFINITION)) != null) {
            builder.setPhaseDefinition(phaseDefinition);
        }
        if ((snapShotRepository = customData.get(SNAPSHOT_REPOSITORY)) != null) {
            builder.setSnapshotRepository(snapShotRepository);
        }
        if ((snapshotName = customData.get(SNAPSHOT_NAME)) != null) {
            builder.setSnapshotName(snapshotName);
        }
        if ((shrinkIndexName = customData.get(SHRINK_INDEX_NAME)) != null) {
            builder.setShrinkIndexName(shrinkIndexName);
        }
        if ((indexCreationDate = customData.get(INDEX_CREATION_DATE)) != null) {
            try {
                builder.setIndexCreationDate(Long.parseLong(indexCreationDate));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, INDEX_CREATION_DATE, customData.get(INDEX_CREATION_DATE));
            }
        }
        if ((phaseTime = customData.get(PHASE_TIME)) != null) {
            try {
                builder.setPhaseTime(Long.parseLong(phaseTime));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, PHASE_TIME, customData.get(PHASE_TIME));
            }
        }
        if ((actionTime = customData.get(ACTION_TIME)) != null) {
            try {
                builder.setActionTime(Long.parseLong(actionTime));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, ACTION_TIME, customData.get(ACTION_TIME));
            }
        }
        if ((stepTime = customData.get(STEP_TIME)) != null) {
            try {
                builder.setStepTime(Long.parseLong(stepTime));
            }
            catch (NumberFormatException e) {
                throw new ElasticsearchException("Custom metadata field [{}] does not contain a valid long. Actual value: [{}]", (Throwable)e, STEP_TIME, customData.get(STEP_TIME));
            }
        }
        if ((snapshotIndexName = customData.get(SNAPSHOT_INDEX_NAME)) != null) {
            builder.setSnapshotIndexName(snapshotIndexName);
        }
        if ((downsampleIndexName = customData.get(DOWNSAMPLE_INDEX_NAME)) != null) {
            builder.setDownsampleIndexName(downsampleIndexName);
        }
        return builder.build();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (this.phase != null) {
            result.put(PHASE, this.phase);
        }
        if (this.action != null) {
            result.put(ACTION, this.action);
        }
        if (this.step != null) {
            result.put(STEP, this.step);
        }
        if (this.failedStep != null) {
            result.put(FAILED_STEP, this.failedStep);
        }
        if (this.isAutoRetryableError != null) {
            result.put(IS_AUTO_RETRYABLE_ERROR, String.valueOf(this.isAutoRetryableError));
        }
        if (this.failedStepRetryCount != null) {
            result.put(FAILED_STEP_RETRY_COUNT, String.valueOf(this.failedStepRetryCount));
        }
        if (this.stepInfo != null) {
            result.put(STEP_INFO, this.stepInfo);
        }
        if (this.previousStepInfo != null) {
            result.put(PREVIOUS_STEP_INFO, this.previousStepInfo);
        }
        if (this.lifecycleDate != null) {
            result.put(INDEX_CREATION_DATE, String.valueOf(this.lifecycleDate));
        }
        if (this.phaseTime != null) {
            result.put(PHASE_TIME, String.valueOf(this.phaseTime));
        }
        if (this.actionTime != null) {
            result.put(ACTION_TIME, String.valueOf(this.actionTime));
        }
        if (this.stepTime != null) {
            result.put(STEP_TIME, String.valueOf(this.stepTime));
        }
        if (this.phaseDefinition != null) {
            result.put(PHASE_DEFINITION, this.phaseDefinition);
        }
        if (this.snapshotRepository != null) {
            result.put(SNAPSHOT_REPOSITORY, this.snapshotRepository);
        }
        if (this.snapshotName != null) {
            result.put(SNAPSHOT_NAME, this.snapshotName);
        }
        if (this.shrinkIndexName != null) {
            result.put(SHRINK_INDEX_NAME, this.shrinkIndexName);
        }
        if (this.snapshotIndexName != null) {
            result.put(SNAPSHOT_INDEX_NAME, this.snapshotIndexName);
        }
        if (this.downsampleIndexName != null) {
            result.put(DOWNSAMPLE_INDEX_NAME, this.downsampleIndexName);
        }
        return Collections.unmodifiableMap(result);
    }

    public static class Builder {
        private String phase;
        private String action;
        private String step;
        private String failedStep;
        private String stepInfo;
        private String previousStepInfo;
        private String phaseDefinition;
        private Long indexCreationDate;
        private Long phaseTime;
        private Long actionTime;
        private Long stepTime;
        private Boolean isAutoRetryableError;
        private Integer failedStepRetryCount;
        private String snapshotName;
        private String snapshotRepository;
        private String shrinkIndexName;
        private String snapshotIndexName;
        private String downsampleIndexName;

        public Builder setPhase(String phase) {
            this.phase = phase;
            return this;
        }

        public Builder setAction(String action) {
            this.action = action;
            return this;
        }

        public Builder setStep(String step) {
            this.step = step;
            return this;
        }

        public Builder setFailedStep(String failedStep) {
            this.failedStep = failedStep;
            return this;
        }

        public Builder setStepInfo(String stepInfo) {
            this.stepInfo = stepInfo;
            return this;
        }

        public Builder setPreviousStepInfo(String previousStepInfo) {
            this.previousStepInfo = previousStepInfo;
            return this;
        }

        public Builder setPhaseDefinition(String phaseDefinition) {
            this.phaseDefinition = phaseDefinition;
            return this;
        }

        public Builder setIndexCreationDate(Long indexCreationDate) {
            this.indexCreationDate = indexCreationDate;
            return this;
        }

        public Builder setPhaseTime(Long phaseTime) {
            this.phaseTime = phaseTime;
            return this;
        }

        public Builder setActionTime(Long actionTime) {
            this.actionTime = actionTime;
            return this;
        }

        public Builder setStepTime(Long stepTime) {
            this.stepTime = stepTime;
            return this;
        }

        public Builder setIsAutoRetryableError(Boolean isAutoRetryableError) {
            this.isAutoRetryableError = isAutoRetryableError;
            return this;
        }

        public Builder setFailedStepRetryCount(Integer failedStepRetryCount) {
            this.failedStepRetryCount = failedStepRetryCount;
            return this;
        }

        public Builder setSnapshotRepository(String snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        public Builder setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public Builder setShrinkIndexName(String shrinkIndexName) {
            this.shrinkIndexName = shrinkIndexName;
            return this;
        }

        public Builder setSnapshotIndexName(String snapshotIndexName) {
            this.snapshotIndexName = snapshotIndexName;
            return this;
        }

        public Builder setDownsampleIndexName(String downsampleIndexName) {
            this.downsampleIndexName = downsampleIndexName;
            return this;
        }

        public LifecycleExecutionState build() {
            return new LifecycleExecutionState(this.phase, this.action, this.step, this.failedStep, this.isAutoRetryableError, this.failedStepRetryCount, this.stepInfo, this.previousStepInfo, this.phaseDefinition, this.indexCreationDate, this.phaseTime, this.actionTime, this.stepTime, this.snapshotRepository, this.snapshotName, this.shrinkIndexName, this.snapshotIndexName, this.downsampleIndexName);
        }
    }
}

