/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.admin.cluster.coordination.MasterHistoryAction;
import org.elasticsearch.cluster.coordination.MasterHistory;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class MasterHistoryService {
    private final TransportService transportService;
    private final MasterHistory localMasterHistory;
    private final LongSupplier currentTimeMillisSupplier;
    private final TimeValue acceptableRemoteHistoryAge;
    volatile RemoteHistoryOrException remoteHistoryOrException = new RemoteHistoryOrException(null, null, Long.MIN_VALUE);
    private static final Logger logger = LogManager.getLogger(MasterHistoryService.class);
    private static final TimeValue DEFAULT_REMOTE_HISTORY_TIME_TO_LIVE = new TimeValue(5L, TimeUnit.MINUTES);
    public static final Setting<TimeValue> REMOTE_HISTORY_TIME_TO_LIVE_SETTING = Setting.positiveTimeSetting("master_history.remote_history_time_to_live", DEFAULT_REMOTE_HISTORY_TIME_TO_LIVE, Setting.Property.NodeScope);

    public MasterHistoryService(TransportService transportService, ThreadPool threadPool, ClusterService clusterService) {
        this.transportService = transportService;
        this.localMasterHistory = new MasterHistory(threadPool, clusterService);
        this.currentTimeMillisSupplier = threadPool.relativeTimeInMillisSupplier();
        this.acceptableRemoteHistoryAge = REMOTE_HISTORY_TIME_TO_LIVE_SETTING.get(clusterService.getSettings());
    }

    public MasterHistory getLocalMasterHistory() {
        return this.localMasterHistory;
    }

    @Nullable
    public List<DiscoveryNode> getRemoteMasterHistory() throws Exception {
        RemoteHistoryOrException remoteHistoryOrExceptionCopy = this.remoteHistoryOrException;
        long acceptableRemoteHistoryTime = this.currentTimeMillisSupplier.getAsLong() - this.acceptableRemoteHistoryAge.getMillis();
        if (remoteHistoryOrExceptionCopy.creationTimeMillis < acceptableRemoteHistoryTime) {
            return null;
        }
        if (remoteHistoryOrExceptionCopy.exception != null) {
            throw remoteHistoryOrExceptionCopy.exception;
        }
        return remoteHistoryOrExceptionCopy.remoteHistory;
    }

    public void refreshRemoteMasterHistory(final DiscoveryNode node) {
        Version minSupportedVersion = Version.V_8_4_0;
        if (node.getVersion().before(minSupportedVersion)) {
            logger.trace("Cannot get master history for {} because it is at version {} and {} is required", (Object)node, (Object)node.getVersion(), (Object)minSupportedVersion);
            return;
        }
        final long startTime = System.nanoTime();
        this.transportService.connectToNode(node, new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable releasable) {
                logger.trace("Connected to {}, making master history request", (Object)node);
                TimeValue remoteMasterHistoryTimeout = TimeValue.timeValueSeconds(10L);
                MasterHistoryService.this.transportService.sendRequest(node, "internal:cluster/master_history/get", (TransportRequest)new MasterHistoryAction.Request(), TransportRequestOptions.timeout(remoteMasterHistoryTimeout), new ActionListenerResponseHandler<MasterHistoryAction.Response>(ActionListener.runBefore(new ActionListener<MasterHistoryAction.Response>(){

                    @Override
                    public void onResponse(MasterHistoryAction.Response response) {
                        long endTime = System.nanoTime();
                        logger.trace("Received history from {} in {}", (Object)node, (Object)TimeValue.timeValueNanos(endTime - startTime));
                        MasterHistoryService.this.remoteHistoryOrException = new RemoteHistoryOrException(response.getMasterHistory(), MasterHistoryService.this.currentTimeMillisSupplier.getAsLong());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Exception in master history request to master node", (Throwable)e);
                        MasterHistoryService.this.remoteHistoryOrException = new RemoteHistoryOrException(e, MasterHistoryService.this.currentTimeMillisSupplier.getAsLong());
                    }
                }, () -> Releasables.close(releasable)), MasterHistoryAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn("Exception connecting to master node", (Throwable)e);
                MasterHistoryService.this.remoteHistoryOrException = new RemoteHistoryOrException(e, MasterHistoryService.this.currentTimeMillisSupplier.getAsLong());
            }
        });
    }

    record RemoteHistoryOrException(List<DiscoveryNode> remoteHistory, Exception exception, long creationTimeMillis) {
        public RemoteHistoryOrException {
            if (remoteHistory != null && exception != null) {
                throw new IllegalArgumentException("Remote history and exception cannot both be non-null");
            }
        }

        RemoteHistoryOrException(List<DiscoveryNode> remoteHistory, long creationTimeMillis) {
            this(remoteHistory, null, creationTimeMillis);
        }

        RemoteHistoryOrException(Exception exception, long creationTimeMillis) {
            this(null, exception, creationTimeMillis);
        }
    }
}

