/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.CanMatchShardResponse;
import org.elasticsearch.transport.TransportResponse;

public class CanMatchNodeResponse
extends TransportResponse {
    private final List<ResponseOrFailure> responses;

    public CanMatchNodeResponse(StreamInput in) throws IOException {
        super(in);
        this.responses = in.readCollectionAsList(ResponseOrFailure::new);
    }

    public CanMatchNodeResponse(List<ResponseOrFailure> responses) {
        this.responses = responses;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.responses);
    }

    public List<ResponseOrFailure> getResponses() {
        return this.responses;
    }

    public static class ResponseOrFailure
    implements Writeable {
        private final CanMatchShardResponse response;
        private final Exception exception;

        public ResponseOrFailure(CanMatchShardResponse response) {
            this.response = response;
            this.exception = null;
        }

        public ResponseOrFailure(Exception exception) {
            this.exception = exception;
            this.response = null;
        }

        @Nullable
        public CanMatchShardResponse getResponse() {
            return this.response;
        }

        @Nullable
        public Exception getException() {
            return this.exception;
        }

        public ResponseOrFailure(StreamInput in) throws IOException {
            if (in.readBoolean()) {
                this.response = new CanMatchShardResponse(in);
                this.exception = null;
            } else {
                this.exception = in.readException();
                this.response = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            boolean hasResponse = this.response != null;
            out.writeBoolean(hasResponse);
            if (hasResponse) {
                this.response.writeTo(out);
            } else {
                out.writeException(this.exception);
            }
        }
    }
}

