/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.search.SearchActionListener;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchPhase;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseSections;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportSearchAction;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.transport.Transport;

abstract class AbstractSearchAsyncAction<Result extends SearchPhaseResult>
extends SearchPhase {
    private static final float DEFAULT_INDEX_BOOST = 1.0f;
    private final Logger logger;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final SearchTransportService searchTransportService;
    private final Executor executor;
    private final ActionListener<SearchResponse> listener;
    private final SearchRequest request;
    private final BiFunction<String, String, Transport.Connection> nodeIdToConnection;
    private final SearchTask task;
    protected final SearchPhaseResults<Result> results;
    private final long clusterStateVersion;
    private final TransportVersion minTransportVersion;
    private final Map<String, AliasFilter> aliasFilter;
    private final Map<String, Float> concreteIndexBoosts;
    private final SetOnce<AtomicArray<ShardSearchFailure>> shardFailures = new SetOnce();
    private final Object shardFailuresMutex = new Object();
    private final AtomicBoolean hasShardResponse = new AtomicBoolean(false);
    private final AtomicInteger successfulOps = new AtomicInteger();
    private final AtomicInteger skippedOps = new AtomicInteger();
    private final TransportSearchAction.SearchTimeProvider timeProvider;
    private final SearchResponse.Clusters clusters;
    protected final GroupShardsIterator<SearchShardIterator> toSkipShardsIts;
    protected final GroupShardsIterator<SearchShardIterator> shardsIts;
    private final SearchShardIterator[] shardIterators;
    private final int expectedTotalOps;
    private final AtomicInteger totalOps = new AtomicInteger();
    private final int maxConcurrentRequestsPerNode;
    private final Map<String, PendingExecutions> pendingExecutionsPerNode = new ConcurrentHashMap<String, PendingExecutions>();
    private final boolean throttleConcurrentRequests;
    private final AtomicBoolean requestCancelled = new AtomicBoolean();
    protected final List<Releasable> releasables = new ArrayList<Releasable>();

    AbstractSearchAsyncAction(String name, Logger logger, NamedWriteableRegistry namedWriteableRegistry, SearchTransportService searchTransportService, BiFunction<String, String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator<SearchShardIterator> shardsIts, TransportSearchAction.SearchTimeProvider timeProvider, ClusterState clusterState, SearchTask task, SearchPhaseResults<Result> resultConsumer, int maxConcurrentRequestsPerNode, SearchResponse.Clusters clusters) {
        super(name);
        this.namedWriteableRegistry = namedWriteableRegistry;
        ArrayList<SearchShardIterator> toSkipIterators = new ArrayList<SearchShardIterator>();
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>();
        for (SearchShardIterator iterator : shardsIts) {
            if (iterator.skip()) {
                toSkipIterators.add(iterator);
                continue;
            }
            iterators.add(iterator);
        }
        this.toSkipShardsIts = new GroupShardsIterator(toSkipIterators);
        this.shardsIts = new GroupShardsIterator(iterators);
        this.shardIterators = iterators.toArray(new SearchShardIterator[0]);
        Arrays.sort(this.shardIterators);
        this.expectedTotalOps = shardsIts.totalSizeWith1ForEmpty();
        this.maxConcurrentRequestsPerNode = maxConcurrentRequestsPerNode;
        this.throttleConcurrentRequests = maxConcurrentRequestsPerNode < shardsIts.size();
        this.timeProvider = timeProvider;
        this.logger = logger;
        this.searchTransportService = searchTransportService;
        this.executor = executor;
        this.request = request;
        this.task = task;
        this.listener = ActionListener.runAfter(listener, () -> Releasables.close(this.releasables));
        this.nodeIdToConnection = nodeIdToConnection;
        this.concreteIndexBoosts = concreteIndexBoosts;
        this.clusterStateVersion = clusterState.version();
        this.minTransportVersion = clusterState.getMinTransportVersion();
        this.aliasFilter = aliasFilter;
        this.results = resultConsumer;
        this.addReleasable(resultConsumer);
        this.clusters = clusters;
    }

    protected void notifyListShards(SearchProgressListener progressListener, SearchResponse.Clusters clusters, SearchSourceBuilder sourceBuilder) {
        progressListener.notifyListShards(SearchProgressListener.buildSearchShards(this.shardsIts), SearchProgressListener.buildSearchShards(this.toSkipShardsIts), clusters, sourceBuilder == null || sourceBuilder.size() > 0, this.timeProvider);
    }

    public void addReleasable(Releasable releasable) {
        this.releasables.add(releasable);
    }

    long buildTookInMillis() {
        return this.timeProvider.buildTookInMillis();
    }

    public final void start() {
        if (this.getNumShards() == 0) {
            int trackTotalHitsUpTo = this.request.source() == null ? 10000 : (this.request.source().trackTotalHitsUpTo() == null ? 10000 : this.request.source().trackTotalHitsUpTo());
            boolean withTotalHits = trackTotalHitsUpTo != -1;
            this.sendSearchResponse(withTotalHits ? SearchResponseSections.EMPTY_WITH_TOTAL_HITS : SearchResponseSections.EMPTY_WITHOUT_TOTAL_HITS, new AtomicArray<SearchPhaseResult>(0));
            return;
        }
        this.executePhase(this);
    }

    @Override
    protected final void run() {
        int i;
        for (SearchShardIterator iterator : this.toSkipShardsIts) {
            assert (iterator.skip());
            this.skipShard(iterator);
        }
        Map<SearchShardIterator, Integer> shardIndexMap = Maps.newHashMapWithExpectedSize(this.shardIterators.length);
        for (i = 0; i < this.shardIterators.length; ++i) {
            shardIndexMap.put(this.shardIterators[i], i);
        }
        if (this.shardsIts.size() > 0) {
            this.doCheckNoMissingShards(this.getName(), this.request, this.shardsIts);
            for (i = 0; i < this.shardsIts.size(); ++i) {
                SearchShardIterator shardRoutings = this.shardsIts.get(i);
                assert (!shardRoutings.skip());
                assert (shardIndexMap.containsKey(shardRoutings));
                int shardIndex = (Integer)shardIndexMap.get(shardRoutings);
                SearchShardTarget routing = shardRoutings.nextOrNull();
                if (routing == null) {
                    this.failOnUnavailable(shardIndex, shardRoutings);
                    continue;
                }
                this.performPhaseOnShard(shardIndex, shardRoutings, routing);
            }
        }
    }

    void skipShard(SearchShardIterator iterator) {
        this.successfulOps.incrementAndGet();
        this.skippedOps.incrementAndGet();
        assert (iterator.skip());
        this.successfulShardExecution(iterator);
    }

    private void performPhaseOnShard(int shardIndex, SearchShardIterator shardIt, SearchShardTarget shard) {
        if (this.throttleConcurrentRequests) {
            PendingExecutions pendingExecutions = this.pendingExecutionsPerNode.computeIfAbsent(shard.getNodeId(), n -> new PendingExecutions(this.maxConcurrentRequestsPerNode));
            pendingExecutions.submit(l -> this.doPerformPhaseOnShard(shardIndex, shardIt, shard, (Releasable)l));
        } else {
            this.doPerformPhaseOnShard(shardIndex, shardIt, shard, () -> {});
        }
    }

    private void doPerformPhaseOnShard(final int shardIndex, final SearchShardIterator shardIt, final SearchShardTarget shard, final Releasable releasable) {
        Transport.Connection connection;
        var shardListener = new SearchActionListener<Result>(shard, shardIndex){

            @Override
            public void innerOnResponse(Result result) {
                try {
                    releasable.close();
                    AbstractSearchAsyncAction.this.onShardResult(result, shardIt);
                }
                catch (Exception exc) {
                    AbstractSearchAsyncAction.this.onShardFailure(shardIndex, shard, shardIt, exc);
                }
            }

            @Override
            public void onFailure(Exception e) {
                releasable.close();
                AbstractSearchAsyncAction.this.onShardFailure(shardIndex, shard, shardIt, e);
            }
        };
        try {
            connection = this.getConnection(shard.getClusterAlias(), shard.getNodeId());
        }
        catch (Exception e) {
            shardListener.onFailure(e);
            return;
        }
        this.executePhaseOnShard(shardIt, connection, shardListener);
    }

    private void failOnUnavailable(int shardIndex, SearchShardIterator shardIt) {
        SearchShardTarget unassignedShard = new SearchShardTarget(null, shardIt.shardId(), shardIt.getClusterAlias());
        this.onShardFailure(shardIndex, unassignedShard, shardIt, new NoShardAvailableActionException(shardIt.shardId()));
    }

    protected abstract void executePhaseOnShard(SearchShardIterator var1, Transport.Connection var2, SearchActionListener<Result> var3);

    protected void executeNextPhase(String currentPhase, Supplier<SearchPhase> nextPhaseSupplier) {
        ShardOperationFailedException[] shardSearchFailures = this.buildShardFailures();
        if (shardSearchFailures.length == this.getNumShards()) {
            ElasticsearchException cause = (shardSearchFailures = ExceptionsHelper.groupBy(shardSearchFailures)).length == 0 ? null : ElasticsearchException.guessRootCauses(shardSearchFailures[0].getCause())[0];
            this.logger.debug(() -> "All shards failed for phase: [" + currentPhase + "]", (Throwable)cause);
            this.onPhaseFailure(currentPhase, "all shards failed", cause);
        } else {
            Boolean allowPartialResults = this.request.allowPartialSearchResults();
            assert (allowPartialResults != null) : "SearchRequest missing setting for allowPartialSearchResults";
            if (!allowPartialResults.booleanValue() && this.successfulOps.get() != this.getNumShards()) {
                if (shardSearchFailures.length > 0) {
                    if (this.logger.isDebugEnabled()) {
                        int numShardFailures = shardSearchFailures.length;
                        shardSearchFailures = ExceptionsHelper.groupBy(shardSearchFailures);
                        ElasticsearchException cause = ElasticsearchException.guessRootCauses(shardSearchFailures[0].getCause())[0];
                        this.logger.debug(() -> Strings.format("%s shards failed for phase: [%s]", numShardFailures, currentPhase), (Throwable)cause);
                    }
                    this.onPhaseFailure(currentPhase, "Partial shards failure", null);
                } else {
                    int discrepancy = this.getNumShards() - this.successfulOps.get();
                    assert (discrepancy > 0) : "discrepancy: " + discrepancy;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Partial shards failure (unavailable: {}, successful: {}, skipped: {}, num-shards: {}, phase: {})", (Object)discrepancy, (Object)this.successfulOps.get(), (Object)this.skippedOps.get(), (Object)this.getNumShards(), (Object)currentPhase);
                    }
                    this.onPhaseFailure(currentPhase, "Partial shards failure (" + discrepancy + " shards unavailable)", null);
                }
                return;
            }
            SearchPhase nextPhase = nextPhaseSupplier.get();
            if (this.logger.isTraceEnabled()) {
                String resultsFrom = this.results.getSuccessfulResults().map(r -> r.getSearchShardTarget().toString()).collect(Collectors.joining(","));
                this.logger.trace("[{}] Moving to next phase: [{}], based on results from: {} (cluster state version: {})", (Object)currentPhase, (Object)nextPhase.getName(), (Object)resultsFrom, (Object)this.clusterStateVersion);
            }
            this.executePhase(nextPhase);
        }
    }

    private void executePhase(SearchPhase phase) {
        try {
            phase.run();
        }
        catch (RuntimeException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(() -> Strings.format("Failed to execute [%s] while moving to [%s] phase", this.request, phase.getName()), (Throwable)e);
            }
            this.onPhaseFailure(phase.getName(), "", e);
        }
    }

    private ShardSearchFailure[] buildShardFailures() {
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures.get();
        if (shardFailures == null) {
            return ShardSearchFailure.EMPTY_ARRAY;
        }
        List<ShardSearchFailure> entries = shardFailures.asList();
        ShardSearchFailure[] failures = new ShardSearchFailure[entries.size()];
        for (int i = 0; i < failures.length; ++i) {
            failures[i] = entries.get(i);
        }
        return failures;
    }

    private void onShardFailure(int shardIndex, SearchShardTarget shard, SearchShardIterator shardIt, Exception e) {
        int totalOps;
        this.onShardFailure(shardIndex, shard, e);
        SearchShardTarget nextShard = shardIt.nextOrNull();
        boolean lastShard = nextShard == null;
        this.logger.debug(() -> Strings.format("%s: Failed to execute [%s] lastShard [%s]", shard, this.request, lastShard), (Throwable)e);
        if (lastShard) {
            if (!this.request.allowPartialSearchResults().booleanValue() && this.requestCancelled.compareAndSet(false, true)) {
                try {
                    this.searchTransportService.cancelSearchTask(this.task, "partial results are not allowed and at least one shard has failed");
                }
                catch (Exception cancelFailure) {
                    this.logger.debug("Failed to cancel search request", (Throwable)cancelFailure);
                }
            }
            this.onShardGroupFailure(shardIndex, shard, e);
        }
        if ((totalOps = this.totalOps.incrementAndGet()) == this.expectedTotalOps) {
            this.onPhaseDone();
        } else {
            if (totalOps > this.expectedTotalOps) {
                throw new AssertionError("unexpected higher total ops [" + totalOps + "] compared to expected [" + this.expectedTotalOps + "]", new SearchPhaseExecutionException(this.getName(), "Shard failures", null, this.buildShardFailures()));
            }
            if (!lastShard) {
                this.performPhaseOnShard(shardIndex, shardIt, nextShard);
            }
        }
    }

    protected void onShardGroupFailure(int shardIndex, SearchShardTarget shardTarget, Exception exc) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onShardFailure(int shardIndex, SearchShardTarget shardTarget, Exception e) {
        if (TransportActions.isShardNotAvailableException(e)) {
            e = NoShardAvailableActionException.forOnShardFailureWrapper(e.getMessage());
        }
        if (!(this.requestCancelled.get() && ExceptionsHelper.isTaskCancelledException(e))) {
            ShardSearchFailure failure;
            AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures.get();
            if (shardFailures == null) {
                Object object = this.shardFailuresMutex;
                synchronized (object) {
                    shardFailures = this.shardFailures.get();
                    if (shardFailures == null) {
                        shardFailures = new AtomicArray(this.getNumShards());
                        this.shardFailures.set(shardFailures);
                    }
                }
            }
            if ((failure = shardFailures.get(shardIndex)) == null) {
                shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
            } else if (TransportActions.isReadOverrideException(e) && !(e instanceof SearchContextMissingException)) {
                shardFailures.set(shardIndex, new ShardSearchFailure(e, shardTarget));
            }
            if (this.results.hasResult(shardIndex)) {
                assert (failure == null) : "shard failed before but shouldn't: " + String.valueOf(failure);
                this.successfulOps.decrementAndGet();
            }
        }
    }

    protected void onShardResult(Result result, SearchShardIterator shardIt) {
        assert (((SearchPhaseResult)result).getShardIndex() != -1) : "shard index is not set";
        assert (((SearchPhaseResult)result).getSearchShardTarget() != null) : "search shard target must not be null";
        this.hasShardResponse.set(true);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("got first-phase result from {}", (Object)(result != null ? ((SearchPhaseResult)result).getSearchShardTarget() : null));
        }
        this.results.consumeResult(result, () -> this.onShardResultConsumed(result, shardIt));
    }

    private void onShardResultConsumed(Result result, SearchShardIterator shardIt) {
        this.successfulOps.incrementAndGet();
        AtomicArray<ShardSearchFailure> shardFailures = this.shardFailures.get();
        if (shardFailures != null) {
            shardFailures.set(((SearchPhaseResult)result).getShardIndex(), null);
        }
        this.successfulShardExecution(shardIt);
    }

    private void successfulShardExecution(SearchShardIterator shardsIt) {
        int remainingOpsOnIterator = shardsIt.skip() ? Math.max(shardsIt.remaining(), 1) : shardsIt.remaining() + 1;
        int xTotalOps = this.totalOps.addAndGet(remainingOpsOnIterator);
        if (xTotalOps == this.expectedTotalOps) {
            this.onPhaseDone();
        } else if (xTotalOps > this.expectedTotalOps) {
            throw new AssertionError("unexpected higher total ops [" + xTotalOps + "] compared to expected [" + this.expectedTotalOps + "]", new SearchPhaseExecutionException(this.getName(), "Shard failures", null, this.buildShardFailures()));
        }
    }

    public final int getNumShards() {
        return this.results.getNumShards();
    }

    public final Logger getLogger() {
        return this.logger;
    }

    public final SearchTask getTask() {
        return this.task;
    }

    public final SearchRequest getRequest() {
        return this.request;
    }

    public OriginalIndices getOriginalIndices(int shardIndex) {
        return this.shardIterators[shardIndex].getOriginalIndices();
    }

    public boolean isPartOfPointInTime(ShardSearchContextId contextId) {
        PointInTimeBuilder pointInTimeBuilder = this.request.pointInTimeBuilder();
        if (pointInTimeBuilder != null) {
            return this.request.pointInTimeBuilder().getSearchContextId(this.namedWriteableRegistry).contains(contextId);
        }
        return false;
    }

    private SearchResponse buildSearchResponse(SearchResponseSections internalSearchResponse, ShardSearchFailure[] failures, String scrollId, BytesReference searchContextId) {
        int numSuccess = this.successfulOps.get();
        int numFailures = failures.length;
        assert (numSuccess + numFailures == this.getNumShards()) : "numSuccess(" + numSuccess + ") + numFailures(" + numFailures + ") != totalShards(" + this.getNumShards() + ")";
        return new SearchResponse(internalSearchResponse, scrollId, this.getNumShards(), numSuccess, this.skippedOps.get(), this.buildTookInMillis(), failures, this.clusters, searchContextId);
    }

    boolean buildPointInTimeFromSearchResults() {
        return false;
    }

    public void sendSearchResponse(SearchResponseSections internalSearchResponse, AtomicArray<SearchPhaseResult> queryResults) {
        ShardSearchFailure[] failures = this.buildShardFailures();
        Boolean allowPartialResults = this.request.allowPartialSearchResults();
        assert (allowPartialResults != null) : "SearchRequest missing setting for allowPartialSearchResults";
        if (!allowPartialResults.booleanValue() && failures.length > 0) {
            this.raisePhaseFailure(new SearchPhaseExecutionException("", "Shard failures", null, failures));
        } else {
            String scrollId;
            String string = scrollId = this.request.scroll() != null ? TransportSearchHelper.buildScrollId(queryResults) : null;
            BytesReference searchContextId = this.buildPointInTimeFromSearchResults() ? SearchContextId.encode(queryResults.asList(), this.aliasFilter, this.minTransportVersion, failures) : (this.request.source() != null && this.request.source().pointInTimeBuilder() != null && !this.request.source().pointInTimeBuilder().singleSession() ? this.request.source().pointInTimeBuilder().getEncodedId() : null);
            ActionListener.respondAndRelease(this.listener, this.buildSearchResponse(internalSearchResponse, failures, scrollId, searchContextId));
        }
    }

    public void onPhaseFailure(String phase, String msg, Throwable cause) {
        this.raisePhaseFailure(new SearchPhaseExecutionException(phase, msg, cause, this.buildShardFailures()));
    }

    private void raisePhaseFailure(SearchPhaseExecutionException exception) {
        this.results.getSuccessfulResults().forEach(entry -> {
            if (entry.getContextId() != null && !this.isPartOfPointInTime(entry.getContextId())) {
                try {
                    SearchShardTarget searchShardTarget = entry.getSearchShardTarget();
                    Transport.Connection connection = this.getConnection(searchShardTarget.getClusterAlias(), searchShardTarget.getNodeId());
                    this.sendReleaseSearchContext(entry.getContextId(), connection);
                }
                catch (Exception inner) {
                    inner.addSuppressed(exception);
                    this.logger.trace("failed to release context", (Throwable)inner);
                }
            }
        });
        this.listener.onFailure(exception);
    }

    void sendReleaseSearchContext(ShardSearchContextId contextId, Transport.Connection connection) {
        assert (!this.isPartOfPointInTime(contextId)) : "Must not release point in time context [" + String.valueOf(contextId) + "]";
        if (connection != null) {
            this.searchTransportService.sendFreeContext(connection, contextId, ActionListener.noop());
        }
    }

    private void onPhaseDone() {
        this.executeNextPhase(this.getName(), this::getNextPhase);
    }

    public final Transport.Connection getConnection(String clusterAlias, String nodeId) {
        return this.nodeIdToConnection.apply(clusterAlias, nodeId);
    }

    public SearchTransportService getSearchTransport() {
        return this.searchTransportService;
    }

    public final void execute(Runnable command) {
        this.executor.execute(command);
    }

    protected final ShardSearchRequest buildShardSearchRequest(SearchShardIterator shardIt, int shardIndex) {
        AliasFilter filter = this.aliasFilter.get(shardIt.shardId().getIndex().getUUID());
        assert (filter != null);
        float indexBoost = this.concreteIndexBoosts.getOrDefault(shardIt.shardId().getIndex().getUUID(), Float.valueOf(1.0f)).floatValue();
        ShardSearchRequest shardRequest = new ShardSearchRequest(shardIt.getOriginalIndices(), this.request, shardIt.shardId(), shardIndex, this.getNumShards(), filter, indexBoost, this.timeProvider.absoluteStartMillis(), shardIt.getClusterAlias(), shardIt.getSearchContextId(), shardIt.getSearchContextKeepAlive());
        shardRequest.canReturnNullResponseIfMatchNoDocs(this.hasShardResponse.get() && shardRequest.scroll() == null);
        return shardRequest;
    }

    protected abstract SearchPhase getNextPhase();

    private static final class PendingExecutions {
        private final Semaphore semaphore;
        private final ConcurrentLinkedQueue<Consumer<Releasable>> queue = new ConcurrentLinkedQueue();

        PendingExecutions(int permits) {
            assert (permits > 0) : "not enough permits: " + permits;
            this.semaphore = new Semaphore(permits);
        }

        void submit(Consumer<Releasable> task) {
            if (this.semaphore.tryAcquire()) {
                this.executeAndRelease(task);
            } else {
                this.queue.add(task);
                if (this.semaphore.tryAcquire() && (task = this.pollNextTaskOrReleasePermit()) != null) {
                    this.executeAndRelease(task);
                }
            }
        }

        private void executeAndRelease(Consumer<Releasable> task) {
            do {
                SubscribableListener<Void> onDone = new SubscribableListener<Void>();
                task.accept(() -> onDone.onResponse(null));
                if (!onDone.isDone()) {
                    onDone.addListener(new ActionListener<Void>(){

                        @Override
                        public void onResponse(Void unused) {
                            Consumer<Releasable> nextTask = this.pollNextTaskOrReleasePermit();
                            if (nextTask != null) {
                                this.executeAndRelease(nextTask);
                            }
                        }

                        @Override
                        public void onFailure(Exception e) {
                            assert (false) : e;
                        }
                    });
                    return;
                }
                task = this.pollNextTaskOrReleasePermit();
            } while (task != null);
        }

        private Consumer<Releasable> pollNextTaskOrReleasePermit() {
            Consumer<Releasable> task = this.queue.poll();
            if (task == null) {
                this.semaphore.release();
                while (this.queue.peek() != null && this.semaphore.tryAcquire()) {
                    task = this.queue.poll();
                    if (task == null) {
                        this.semaphore.release();
                        continue;
                    }
                    return task;
                }
            }
            return task;
        }
    }
}

