/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.template.post.TransportSimulateIndexTemplateAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.SimulateBulkAction;
import org.elasticsearch.action.bulk.SimulateBulkRequest;
import org.elasticsearch.action.bulk.TransportAbstractBulkAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.ingest.SimulateIndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexTemplateService;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettingProvider;
import org.elasticsearch.index.IndexSettingProviders;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.SimulateIngestService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class TransportSimulateBulkAction
extends TransportAbstractBulkAction {
    public static final NodeFeature SIMULATE_IGNORED_FIELDS = new NodeFeature("simulate.ignored.fields");
    private final IndicesService indicesService;
    private final NamedXContentRegistry xContentRegistry;
    private final Set<IndexSettingProvider> indexSettingProviders;

    @Inject
    public TransportSimulateBulkAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IngestService ingestService, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices, IndicesService indicesService, NamedXContentRegistry xContentRegistry, IndexSettingProviders indexSettingProviders) {
        super(SimulateBulkAction.INSTANCE, transportService, actionFilters, SimulateBulkRequest::new, threadPool, clusterService, ingestService, indexingPressure, systemIndices, threadPool::relativeTimeInNanos);
        this.indicesService = indicesService;
        this.xContentRegistry = xContentRegistry;
        this.indexSettingProviders = indexSettingProviders.getIndexSettingProviders();
    }

    @Override
    protected void doInternalExecute(Task task, BulkRequest bulkRequest, Executor executor, ActionListener<BulkResponse> listener, long relativeStartTimeNanos) throws IOException {
        assert (bulkRequest instanceof SimulateBulkRequest) : "TransportSimulateBulkAction should only ever be called with a SimulateBulkRequest but got a " + String.valueOf(bulkRequest.getClass());
        AtomicArray<BulkItemResponse> responses = new AtomicArray<BulkItemResponse>(bulkRequest.requests.size());
        Map<String, ComponentTemplate> componentTemplateSubstitutions = bulkRequest.getComponentTemplateSubstitutions();
        Map<String, ComposableIndexTemplate> indexTemplateSubstitutions = bulkRequest.getIndexTemplateSubstitutions();
        Map<String, Object> mappingAddition = ((SimulateBulkRequest)bulkRequest).getMappingAddition();
        for (int i = 0; i < bulkRequest.requests.size(); ++i) {
            DocWriteRequest<?> docRequest = bulkRequest.requests.get(i);
            assert (docRequest instanceof IndexRequest) : "TransportSimulateBulkAction should only ever be called with IndexRequests";
            IndexRequest request = (IndexRequest)docRequest;
            Tuple<Collection<String>, Exception> validationResult = this.validateMappings(componentTemplateSubstitutions, indexTemplateSubstitutions, mappingAddition, request);
            Exception mappingValidationException = validationResult.v2();
            responses.set(i, BulkItemResponse.success(0, DocWriteRequest.OpType.CREATE, new SimulateIndexResponse(request.id(), request.index(), request.version(), request.source(), request.getContentType(), request.getExecutedPipelines(), validationResult.v1(), mappingValidationException)));
        }
        listener.onResponse(new BulkResponse(responses.toArray(new BulkItemResponse[responses.length()]), this.buildTookInMillis(relativeStartTimeNanos)));
    }

    private Tuple<Collection<String>, Exception> validateMappings(Map<String, ComponentTemplate> componentTemplateSubstitutions, Map<String, ComposableIndexTemplate> indexTemplateSubstitutions, Map<String, Object> mappingAddition, IndexRequest request) {
        SourceToParse sourceToParse = new SourceToParse(request.id(), request.source(), request.getContentType(), request.routing(), request.getDynamicTemplates(), request.getIncludeSourceOnError(), XContentMeteringParserDecorator.NOOP);
        ClusterState state = this.clusterService.state();
        Exception mappingValidationException = null;
        Collection<Object> ignoredFields = List.of();
        IndexAbstraction indexAbstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(request.index());
        try {
            if (indexAbstraction != null && componentTemplateSubstitutions.isEmpty() && indexTemplateSubstitutions.isEmpty() && mappingAddition.isEmpty()) {
                IndexMetadata imd = state.metadata().getIndexSafe(indexAbstraction.getWriteIndex(request, state.metadata()));
                this.indicesService.withTempIndexService(imd, indexService -> {
                    indexService.mapperService().updateMapping(null, imd);
                    return IndexShard.prepareIndex(indexService.mapperService(), sourceToParse, -2L, -1L, -1L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, Long.MIN_VALUE, false, request.ifSeqNo(), request.ifPrimaryTerm(), 0L);
                });
            } else {
                ClusterState simulatedState;
                String matchingTemplate;
                ClusterState.Builder simulatedClusterStateBuilder = new ClusterState.Builder(state);
                Metadata.Builder simulatedMetadata = Metadata.builder(state.metadata());
                if (indexAbstraction != null) {
                    String indexRequest = request.index();
                    assert (indexRequest != null) : "Index requests cannot be null in a simulate bulk call";
                    if (indexRequest != null) {
                        simulatedMetadata.remove(indexRequest);
                        simulatedMetadata.removeDataStream(indexRequest);
                    }
                }
                if (!componentTemplateSubstitutions.isEmpty()) {
                    HashMap<String, ComponentTemplate> updatedComponentTemplates = new HashMap<String, ComponentTemplate>();
                    updatedComponentTemplates.putAll(state.metadata().componentTemplates());
                    updatedComponentTemplates.putAll(componentTemplateSubstitutions);
                    simulatedMetadata.componentTemplates(updatedComponentTemplates);
                }
                if (!indexTemplateSubstitutions.isEmpty()) {
                    HashMap<String, ComposableIndexTemplate> updatedIndexTemplates = new HashMap<String, ComposableIndexTemplate>();
                    updatedIndexTemplates.putAll(state.metadata().templatesV2());
                    updatedIndexTemplates.putAll(indexTemplateSubstitutions);
                    simulatedMetadata.indexTemplates(updatedIndexTemplates);
                }
                if ((matchingTemplate = MetadataIndexTemplateService.findV2Template((simulatedState = simulatedClusterStateBuilder.metadata(simulatedMetadata).build()).metadata(), request.index(), false)) != null) {
                    Template template = TransportSimulateIndexTemplateAction.resolveTemplate(matchingTemplate, request.index(), simulatedState, DataStreamLifecycle.isDataStreamsLifecycleOnlyMode(this.clusterService.getSettings()), this.xContentRegistry, this.indicesService, this.systemIndices, this.indexSettingProviders);
                    CompressedXContent mappings = template.mappings();
                    CompressedXContent mergedMappings = TransportSimulateBulkAction.mergeMappings(mappings, mappingAddition);
                    ignoredFields = this.validateUpdatedMappings(mappings, mergedMappings, request, sourceToParse);
                } else {
                    List<IndexTemplateMetadata> matchingTemplates = MetadataIndexTemplateService.findV1Templates(simulatedState.metadata(), request.index(), false);
                    if (!matchingTemplates.isEmpty()) {
                        Map<String, Object> mappingsMap = MetadataCreateIndexService.parseV1Mappings("{}", matchingTemplates.stream().map(IndexTemplateMetadata::getMappings).collect(Collectors.toList()), this.xContentRegistry);
                        CompressedXContent combinedMappings = TransportSimulateBulkAction.mergeMappings(new CompressedXContent(mappingsMap), mappingAddition);
                        ignoredFields = this.validateUpdatedMappings(null, combinedMappings, request, sourceToParse);
                    } else if (indexAbstraction != null && !mappingAddition.isEmpty()) {
                        MappingMetadata mappingFromIndex = this.clusterService.state().metadata().index(indexAbstraction.getName()).mapping();
                        CompressedXContent currentIndexCompressedXContent = mappingFromIndex == null ? null : mappingFromIndex.source();
                        CompressedXContent combinedMappings = TransportSimulateBulkAction.mergeMappings(currentIndexCompressedXContent, mappingAddition);
                        ignoredFields = this.validateUpdatedMappings(null, combinedMappings, request, sourceToParse);
                    } else {
                        CompressedXContent combinedMappings = TransportSimulateBulkAction.mergeMappings(null, mappingAddition);
                        ignoredFields = this.validateUpdatedMappings(null, combinedMappings, request, sourceToParse);
                    }
                }
            }
        }
        catch (Exception e) {
            mappingValidationException = e;
        }
        return Tuple.tuple(ignoredFields, mappingValidationException);
    }

    private Collection<String> validateUpdatedMappings(@Nullable CompressedXContent originalMappings, @Nullable CompressedXContent updatedMappings, IndexRequest request, SourceToParse sourceToParse) throws IOException {
        List<String> ignoredFields;
        IndexMetadata updatedIndexMetadata;
        IndexMetadata originalIndexMetadata;
        Engine.Index result;
        if (updatedMappings == null) {
            return List.of();
        }
        Settings dummySettings = Settings.builder().put("index.version.created", IndexVersion.current()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
        IndexMetadata.Builder originalIndexMetadataBuilder = IndexMetadata.builder(request.index()).settings(dummySettings);
        if (originalMappings != null) {
            originalIndexMetadataBuilder.putMapping(new MappingMetadata(originalMappings));
        }
        if ((result = this.indicesService.withTempIndexService(originalIndexMetadata = originalIndexMetadataBuilder.build(), arg_0 -> TransportSimulateBulkAction.lambda$validateUpdatedMappings$1(updatedIndexMetadata = IndexMetadata.builder(request.index()).settings(dummySettings).putMapping(new MappingMetadata(updatedMappings)).build(), sourceToParse, request, arg_0))) == null) {
            ignoredFields = List.of();
        } else {
            List<LuceneDocument> luceneDocuments = result.parsedDoc().docs();
            assert (luceneDocuments == null || luceneDocuments.size() == 1) : "Expected a single lucene document from index attempt";
            ignoredFields = luceneDocuments != null && luceneDocuments.size() == 1 ? luceneDocuments.getFirst().getFields().stream().filter(field -> field.name().equals("_ignored") && field instanceof StringField).map(IndexableField::stringValue).toList() : List.of();
        }
        return ignoredFields;
    }

    private static CompressedXContent mergeMappings(@Nullable CompressedXContent originalMapping, Map<String, Object> mappingAddition) throws IOException {
        HashMap<String, Object> combinedMappingMap = new HashMap<String, Object>();
        if (originalMapping != null) {
            combinedMappingMap.putAll(XContentHelper.convertToMap(originalMapping.uncompressed(), true, XContentType.JSON).v2());
        }
        XContentHelper.update(combinedMappingMap, mappingAddition, true);
        if (combinedMappingMap.isEmpty()) {
            return null;
        }
        return TransportSimulateBulkAction.convertMappingMapToXContent(combinedMappingMap);
    }

    @Override
    protected IngestService getIngestService(BulkRequest request) {
        IngestService rawIngestService = super.getIngestService(request);
        return new SimulateIngestService(rawIngestService, request);
    }

    @Override
    protected Boolean resolveFailureStore(String indexName, Metadata metadata, long epochMillis) {
        return null;
    }

    private static CompressedXContent convertMappingMapToXContent(Map<String, Object> rawAdditionalMapping) throws IOException {
        CompressedXContent compressedXContent;
        if (rawAdditionalMapping == null || rawAdditionalMapping.isEmpty()) {
            compressedXContent = null;
        } else {
            try (XContentParser parser = XContentHelper.mapToXContentParser(XContentParserConfiguration.EMPTY, rawAdditionalMapping);){
                compressedXContent = TransportSimulateBulkAction.mappingFromXContent(parser);
            }
        }
        return compressedXContent;
    }

    private static CompressedXContent mappingFromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            return new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(parser.mapOrdered())));
        }
        throw new IllegalArgumentException("Unexpected token: " + String.valueOf((Object)token));
    }

    private static /* synthetic */ Engine.Index lambda$validateUpdatedMappings$1(IndexMetadata updatedIndexMetadata, SourceToParse sourceToParse, IndexRequest request, IndexService indexService) throws RuntimeException {
        indexService.mapperService().merge(updatedIndexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        return IndexShard.prepareIndex(indexService.mapperService(), sourceToParse, -2L, -1L, -1L, VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY, Long.MIN_VALUE, false, request.ifSeqNo(), request.ifPrimaryTerm(), 0L);
    }
}

