/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class TransportGetFieldMappingsIndexAction
extends TransportSingleShardAction<GetFieldMappingsIndexRequest, GetFieldMappingsResponse> {
    private static final String ACTION_NAME = "indices:admin/mappings/fields/get[index]";
    public static final ActionType<GetFieldMappingsResponse> TYPE = new ActionType("indices:admin/mappings/fields/get[index]");
    private final IndicesService indicesService;
    private static final ToXContent.Params includeDefaultsParams = new ToXContent.Params(){
        static final String INCLUDE_DEFAULTS = "include_defaults";

        @Override
        public String param(String key) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return null;
        }

        @Override
        public String param(String key, String defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return "true";
            }
            return defaultValue;
        }

        @Override
        public boolean paramAsBoolean(String key, boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }

        @Override
        public Boolean paramAsBoolean(String key, Boolean defaultValue) {
            if (INCLUDE_DEFAULTS.equals(key)) {
                return true;
            }
            return defaultValue;
        }
    };

    @Inject
    public TransportGetFieldMappingsIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, GetFieldMappingsIndexRequest::new, threadPool.executor("management"));
        this.indicesService = indicesService;
    }

    @Override
    protected boolean resolveIndex(GetFieldMappingsIndexRequest request) {
        return false;
    }

    @Override
    protected ShardsIterator shards(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.routingTable().index(request.concreteIndex()).randomAllActiveShardsIt();
    }

    @Override
    protected GetFieldMappingsResponse shardOperation(GetFieldMappingsIndexRequest request, ShardId shardId) {
        assert (shardId != null);
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        Predicate<String> metadataFieldPredicate = f -> indexService.mapperService().isMetadataField((String)f);
        Predicate<String> fieldPredicate = metadataFieldPredicate.or(this.indicesService.getFieldFilter().apply(shardId.getIndexName()));
        MappingLookup mappingLookup = indexService.mapperService().mappingLookup();
        Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMapping = TransportGetFieldMappingsIndexAction.findFieldMappings(fieldPredicate, mappingLookup, request);
        return new GetFieldMappingsResponse(Collections.singletonMap(shardId.getIndexName(), fieldMapping));
    }

    @Override
    protected Writeable.Reader<GetFieldMappingsResponse> getResponseReader() {
        return GetFieldMappingsResponse::new;
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, TransportSingleShardAction.InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_READ, request.concreteIndex());
    }

    private static Map<String, GetFieldMappingsResponse.FieldMappingMetadata> findFieldMappings(Predicate<String> fieldPredicate, MappingLookup mappingLookup, GetFieldMappingsIndexRequest request) {
        HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings = new HashMap<String, GetFieldMappingsResponse.FieldMappingMetadata>();
        for (String field : request.fields()) {
            if (Regex.isMatchAllPattern(field)) {
                for (Mapper fieldMapper : mappingLookup.fieldMappers()) {
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.fullPath(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            if (Regex.isSimpleMatchPattern(field)) {
                for (Mapper fieldMapper : mappingLookup.fieldMappers()) {
                    if (!Regex.simpleMatch(field, fieldMapper.fullPath())) continue;
                    TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, fieldMapper.fullPath(), fieldMapper, fieldMappings, request.includeDefaults());
                }
                continue;
            }
            Mapper fieldMapper = mappingLookup.getMapper(field);
            if (fieldMapper == null) continue;
            TransportGetFieldMappingsIndexAction.addFieldMapper(fieldPredicate, field, fieldMapper, fieldMappings, request.includeDefaults());
        }
        return Collections.unmodifiableMap(fieldMappings);
    }

    private static void addFieldMapper(Predicate<String> fieldPredicate, String field, Mapper fieldMapper, Map<String, GetFieldMappingsResponse.FieldMappingMetadata> fieldMappings, boolean includeDefaults) {
        if (fieldMappings.containsKey(field)) {
            return;
        }
        if (fieldPredicate.test(field)) {
            try {
                BytesReference bytes = XContentHelper.toXContent(fieldMapper, XContentType.JSON, includeDefaults ? includeDefaultsParams : ToXContent.EMPTY_PARAMS, false);
                fieldMappings.put(field, new GetFieldMappingsResponse.FieldMappingMetadata(fieldMapper.fullPath(), bytes));
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize XContent of field [" + field + "]", (Throwable)e, new Object[0]);
            }
        }
    }
}

