/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DenseVectorIndexOptionsType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorIndexOptions
implements JsonpSerializable {
    @Nullable
    private final Float confidenceInterval;
    @Nullable
    private final Integer efConstruction;
    @Nullable
    private final Integer m;
    private final DenseVectorIndexOptionsType type;
    public static final JsonpDeserializer<DenseVectorIndexOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorIndexOptions::setupDenseVectorIndexOptionsDeserializer);

    private DenseVectorIndexOptions(Builder builder) {
        this.confidenceInterval = builder.confidenceInterval;
        this.efConstruction = builder.efConstruction;
        this.m = builder.m;
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static DenseVectorIndexOptions of(Function<Builder, ObjectBuilder<DenseVectorIndexOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Float confidenceInterval() {
        return this.confidenceInterval;
    }

    @Nullable
    public final Integer efConstruction() {
        return this.efConstruction;
    }

    @Nullable
    public final Integer m() {
        return this.m;
    }

    public final DenseVectorIndexOptionsType type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.confidenceInterval != null) {
            generator.writeKey("confidence_interval");
            generator.write(this.confidenceInterval.floatValue());
        }
        if (this.efConstruction != null) {
            generator.writeKey("ef_construction");
            generator.write(this.efConstruction);
        }
        if (this.m != null) {
            generator.writeKey("m");
            generator.write(this.m);
        }
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDenseVectorIndexOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::confidenceInterval, JsonpDeserializer.floatDeserializer(), "confidence_interval");
        op.add(Builder::efConstruction, JsonpDeserializer.integerDeserializer(), "ef_construction");
        op.add(Builder::m, JsonpDeserializer.integerDeserializer(), "m");
        op.add(Builder::type, DenseVectorIndexOptionsType._DESERIALIZER, "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DenseVectorIndexOptions> {
        @Nullable
        private Float confidenceInterval;
        @Nullable
        private Integer efConstruction;
        @Nullable
        private Integer m;
        private DenseVectorIndexOptionsType type;

        public final Builder confidenceInterval(@Nullable Float value) {
            this.confidenceInterval = value;
            return this;
        }

        public final Builder efConstruction(@Nullable Integer value) {
            this.efConstruction = value;
            return this;
        }

        public final Builder m(@Nullable Integer value) {
            this.m = value;
            return this;
        }

        public final Builder type(DenseVectorIndexOptionsType value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorIndexOptions build() {
            this._checkSingleUse();
            return new DenseVectorIndexOptions(this);
        }
    }
}

