/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class RetrieverBase
implements JsonpSerializable {
    private final List<Query> filter;
    @Nullable
    private final Float minScore;

    protected RetrieverBase(AbstractBuilder<?> builder) {
        this.filter = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).filter);
        this.minScore = ((AbstractBuilder)builder).minScore;
    }

    public final List<Query> filter() {
        return this.filter;
    }

    @Nullable
    public final Float minScore() {
        return this.minScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (Query item0 : this.filter) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupRetrieverBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::filter, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "filter");
        op.add(AbstractBuilder::minScore, JsonpDeserializer.floatDeserializer(), "min_score");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private List<Query> filter;
        @Nullable
        private Float minScore;

        public final BuilderT filter(List<Query> list) {
            this.filter = AbstractBuilder._listAddAll(this.filter, list);
            return (BuilderT)this.self();
        }

        public final BuilderT filter(Query value, Query ... values) {
            this.filter = AbstractBuilder._listAdd(this.filter, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT filter(QueryVariant value, QueryVariant ... values) {
            this.filter = AbstractBuilder._listAdd(this.filter, value._toQuery(), new Query[0]);
            for (QueryVariant v : values) {
                AbstractBuilder._listAdd(this.filter, v._toQuery(), new Query[0]);
            }
            return (BuilderT)this.self();
        }

        public final BuilderT filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final BuilderT minScore(@Nullable Float value) {
            this.minScore = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

