/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.UserInfo;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public final class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String accessTokenType;
    private final long expiresIn;
    private final Date expiresOn;
    private final String idToken;
    private final UserInfo userInfo;
    private final String accessToken;
    private final String refreshToken;
    private final boolean isMultipleResourceRefreshToken;

    public AuthenticationResult(String accessTokenType, String accessToken, String refreshToken, long expiresIn, String idToken, UserInfo userInfo, boolean isMultipleResourceRefreshToken) {
        this.accessTokenType = accessTokenType;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.expiresIn = expiresIn;
        Date now = new Date();
        now.setTime(now.getTime() + expiresIn * 1000L);
        this.expiresOn = now;
        this.idToken = idToken;
        this.userInfo = userInfo;
        this.isMultipleResourceRefreshToken = isMultipleResourceRefreshToken;
    }

    public String getAccessTokenType() {
        return this.accessTokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Deprecated
    public long getExpiresOn() {
        return this.expiresIn;
    }

    public long getExpiresAfter() {
        return this.expiresIn;
    }

    public Date getExpiresOnDate() {
        if (this.expiresOn != null) {
            return (Date)this.expiresOn.clone();
        }
        return null;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public boolean isMultipleResourceRefreshToken() {
        return this.isMultipleResourceRefreshToken;
    }

    public int hashCode() {
        int hash = 3;
        hash = 41 * hash + Objects.hashCode(this.accessTokenType);
        hash = 41 * hash + (int)(this.expiresIn ^ this.expiresIn >>> 32);
        hash = 41 * hash + Objects.hashCode(this.expiresOn);
        hash = 41 * hash + Objects.hashCode(this.idToken);
        hash = 41 * hash + Objects.hashCode(this.userInfo);
        hash = 41 * hash + Objects.hashCode(this.accessToken);
        hash = 41 * hash + Objects.hashCode(this.refreshToken);
        hash = 41 * hash + (this.isMultipleResourceRefreshToken ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationResult other = (AuthenticationResult)obj;
        if (this.expiresIn != other.expiresIn) {
            return false;
        }
        if (this.isMultipleResourceRefreshToken != other.isMultipleResourceRefreshToken) {
            return false;
        }
        if (!Objects.equals(this.accessTokenType, other.accessTokenType)) {
            return false;
        }
        if (!Objects.equals(this.idToken, other.idToken)) {
            return false;
        }
        if (!Objects.equals(this.accessToken, other.accessToken)) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, other.refreshToken)) {
            return false;
        }
        if (!Objects.equals(this.expiresOn, other.expiresOn)) {
            return false;
        }
        return Objects.equals(this.userInfo, other.userInfo);
    }
}

