/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.execution;

import co.elastic.logstash.api.TimerMetric;
import org.logstash.config.ir.CompiledPipeline;
import org.logstash.execution.ObservedExecution;
import org.logstash.execution.QueueBatch;
import org.logstash.instrument.metrics.AbstractMetricExt;
import org.logstash.instrument.metrics.AbstractNamespacedMetricExt;
import org.logstash.instrument.metrics.MetricKeys;
import org.logstash.instrument.metrics.counter.LongCounter;
import org.logstash.instrument.metrics.timer.TimerMetric;

public class WorkerObserver {
    private final transient LongCounter processEventsFilteredMetric;
    private final transient LongCounter processEventsOutMetric;
    private final transient TimerMetric processEventsDurationMetric;
    private final transient LongCounter pipelineEventsFilteredMetric;
    private final transient LongCounter pipelineEventsOutMetric;
    private final transient TimerMetric pipelineEventsDurationMetric;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerObserver(AbstractNamespacedMetricExt processEventsMetric, AbstractNamespacedMetricExt pipelineEventsMetric) {
        AbstractMetricExt abstractMetricExt = processEventsMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.processEventsOutMetric = LongCounter.fromRubyBase(processEventsMetric, MetricKeys.OUT_KEY);
            this.processEventsFilteredMetric = LongCounter.fromRubyBase(processEventsMetric, MetricKeys.FILTERED_KEY);
            this.processEventsDurationMetric = TimerMetric.fromRubyBase(processEventsMetric, MetricKeys.DURATION_IN_MILLIS_KEY);
        }
        abstractMetricExt = pipelineEventsMetric.getMetric();
        synchronized (abstractMetricExt) {
            this.pipelineEventsOutMetric = LongCounter.fromRubyBase(pipelineEventsMetric, MetricKeys.OUT_KEY);
            this.pipelineEventsFilteredMetric = LongCounter.fromRubyBase(pipelineEventsMetric, MetricKeys.FILTERED_KEY);
            this.pipelineEventsDurationMetric = TimerMetric.fromRubyBase(pipelineEventsMetric, MetricKeys.DURATION_IN_MILLIS_KEY);
        }
    }

    public <QB extends QueueBatch> ObservedExecution<QB> ofExecution(CompiledPipeline.Execution<QB> execution) {
        return new ObservedExecution<QB>(this, execution);
    }

    <E extends Exception> int observeExecutionComputation(QueueBatch batch, TimerMetric.ExceptionalSupplier<Integer, E> supplier) throws E {
        return this.executeWithTimers(() -> {
            int outputCount = (Integer)supplier.get();
            int filteredCount = batch.filteredSize();
            this.incrementFilteredMetrics(filteredCount);
            this.incrementOutMetrics(outputCount);
            return outputCount;
        });
    }

    public <V, E extends Exception> V executeWithTimers(TimerMetric.ExceptionalSupplier<V, E> supplier) throws E {
        return (V)this.processEventsDurationMetric.time(() -> this.pipelineEventsDurationMetric.time(supplier));
    }

    private void incrementOutMetrics(long amount) {
        this.processEventsOutMetric.increment(amount);
        this.pipelineEventsOutMetric.increment(amount);
    }

    private void incrementFilteredMetrics(long amount) {
        this.processEventsFilteredMetric.increment(amount);
        this.pipelineEventsFilteredMetric.increment(amount);
    }
}

