/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.ingest;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.geo.GeometryParserFormat;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.ShapeType;
import org.elasticsearch.geometry.utils.CircleUtils;
import org.elasticsearch.geometry.utils.StandardValidator;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.support.MapXContentParser;

public final class CircleProcessor
extends AbstractProcessor {
    public static final String TYPE = "circle";
    private final String field;
    private final String targetField;
    private final boolean ignoreMissing;
    private final double errorDistance;
    private final CircleShapeFieldType circleShapeFieldType;

    CircleProcessor(String tag, String description, String field, String targetField, boolean ignoreMissing, double errorDistance, CircleShapeFieldType circleShapeFieldType) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.ignoreMissing = ignoreMissing;
        this.errorDistance = errorDistance;
        this.circleShapeFieldType = circleShapeFieldType;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) {
        Object obj = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
        if (obj == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (obj == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot process it.");
        }
        if (!(obj instanceof Map) && !(obj instanceof String)) {
            throw new IllegalArgumentException("field [" + this.field + "] must be a WKT Circle or a GeoJSON Circle value");
        }
        Map<String, Object> valueWrapper = Map.of("shape", obj);
        MapXContentParser parser = new MapXContentParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, valueWrapper, XContentType.JSON);
        try {
            Polygon polygon;
            parser.nextToken();
            parser.nextToken();
            parser.nextToken();
            GeometryParserFormat geometryFormat = GeometryParserFormat.geometryFormat(parser);
            Geometry geometry = geometryFormat.fromXContent(StandardValidator.instance(true), true, true, parser);
            if (ShapeType.CIRCLE.equals((Object)geometry.type())) {
                Circle circle = (Circle)geometry;
                int numSides = CircleUtils.circleToPolygonNumSides(circle.getRadiusMeters(), this.errorDistance);
                switch (this.circleShapeFieldType.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 1: {
                        polygon = CircleUtils.createRegularGeoShapePolygon(circle, numSides);
                        break;
                    }
                    case 0: {
                        polygon = CircleUtils.createRegularShapePolygon(circle, numSides);
                    }
                }
            } else {
                throw new IllegalArgumentException("found [" + String.valueOf((Object)geometry.type()) + "] instead of circle");
            }
            Polygon polygonizedCircle = polygon;
            XContentBuilder newValueBuilder = XContentFactory.jsonBuilder().startObject().field("val");
            geometryFormat.toXContent(polygonizedCircle, newValueBuilder, ToXContent.EMPTY_PARAMS);
            newValueBuilder.endObject();
            Map<String, Object> newObj = XContentHelper.convertToMap(BytesReference.bytes(newValueBuilder), true, XContentType.JSON).v2();
            ingestDocument.setFieldValue(this.targetField, newObj.get("val"));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid circle definition", e);
        }
        return ingestDocument;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String field() {
        return this.field;
    }

    String targetField() {
        return this.targetField;
    }

    double errorDistance() {
        return this.errorDistance;
    }

    CircleShapeFieldType shapeType() {
        return this.circleShapeFieldType;
    }

    static enum CircleShapeFieldType {
        SHAPE,
        GEO_SHAPE;


        public static CircleShapeFieldType parse(String value) {
            EnumSet<CircleShapeFieldType> validValues = EnumSet.allOf(CircleShapeFieldType.class);
            try {
                return CircleShapeFieldType.valueOf(value.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal [shape_type] value [" + value + "]. valid values are " + Arrays.toString(validValues.toArray()));
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        @Override
        public CircleProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) {
            String field = ConfigurationUtils.readStringProperty(CircleProcessor.TYPE, processorTag, config, "field");
            String targetField = ConfigurationUtils.readStringProperty(CircleProcessor.TYPE, processorTag, config, "target_field", field);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(CircleProcessor.TYPE, processorTag, config, "ignore_missing", false);
            double radiusDistance = Math.abs(ConfigurationUtils.readDoubleProperty(CircleProcessor.TYPE, processorTag, config, "error_distance"));
            CircleShapeFieldType circleFieldType = CircleShapeFieldType.parse(ConfigurationUtils.readStringProperty(CircleProcessor.TYPE, processorTag, config, "shape_type"));
            return new CircleProcessor(processorTag, description, field, targetField, ignoreMissing, radiusDistance, circleFieldType);
        }
    }
}

