/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xpack.core.ilm.OperationMode;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;

public class SnapshotLifecycleMetadata
implements Metadata.Custom {
    public static final String TYPE = "snapshot_lifecycle";
    private static final ParseField OPERATION_MODE_FIELD = new ParseField("operation_mode", new String[0]);
    private static final ParseField POLICIES_FIELD = new ParseField("policies", new String[0]);
    private static final ParseField STATS_FIELD = new ParseField("stats", new String[0]);
    public static final SnapshotLifecycleMetadata EMPTY = new SnapshotLifecycleMetadata(Collections.emptyMap(), OperationMode.RUNNING, new SnapshotLifecycleStats());
    public static final ConstructingObjectParser<SnapshotLifecycleMetadata, Void> PARSER = new ConstructingObjectParser("snapshot_lifecycle", a -> new SnapshotLifecycleMetadata(((List)a[0]).stream().collect(Collectors.toMap(m -> m.getPolicy().getId(), Function.identity())), OperationMode.valueOf((String)a[1]), (SnapshotLifecycleStats)a[2]));
    private final Map<String, SnapshotLifecyclePolicyMetadata> snapshotConfigurations;
    private final OperationMode operationMode;
    private final SnapshotLifecycleStats slmStats;

    public SnapshotLifecycleMetadata(Map<String, SnapshotLifecyclePolicyMetadata> snapshotConfigurations, OperationMode operationMode, SnapshotLifecycleStats slmStats) {
        this.snapshotConfigurations = new HashMap<String, SnapshotLifecyclePolicyMetadata>(snapshotConfigurations);
        this.operationMode = operationMode;
        this.slmStats = slmStats != null ? slmStats : new SnapshotLifecycleStats();
    }

    public SnapshotLifecycleMetadata(StreamInput in) throws IOException {
        this.snapshotConfigurations = in.readMap(SnapshotLifecyclePolicyMetadata::new);
        this.operationMode = in.readEnum(OperationMode.class);
        this.slmStats = new SnapshotLifecycleStats(in);
    }

    public Map<String, SnapshotLifecyclePolicyMetadata> getSnapshotConfigurations() {
        return Collections.unmodifiableMap(this.snapshotConfigurations);
    }

    @Deprecated(since="8.7.0")
    public OperationMode getOperationMode() {
        return this.operationMode;
    }

    public SnapshotLifecycleStats getStats() {
        return this.slmStats;
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new SnapshotLifecycleMetadataDiff((SnapshotLifecycleMetadata)previousState, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.snapshotConfigurations, StreamOutput::writeWriteable);
        out.writeEnum(this.operationMode);
        this.slmStats.writeTo(out);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.xContentObjectFields(POLICIES_FIELD.getPreferredName(), this.snapshotConfigurations), Iterators.single((builder, p) -> builder.field(OPERATION_MODE_FIELD.getPreferredName(), this.operationMode).field(STATS_FIELD.getPreferredName(), this.slmStats)));
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshotConfigurations, this.operationMode, this.slmStats});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SnapshotLifecycleMetadata other = (SnapshotLifecycleMetadata)obj;
        return this.snapshotConfigurations.equals(other.snapshotConfigurations) && this.operationMode.equals((Object)other.operationMode) && this.slmStats.equals(other.slmStats);
    }

    static {
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, n) -> SnapshotLifecyclePolicyMetadata.parse(p, n), v -> {
            throw new IllegalArgumentException("ordered " + POLICIES_FIELD.getPreferredName() + " are not supported");
        }, POLICIES_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), OPERATION_MODE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (v, o) -> SnapshotLifecycleStats.parse(v), STATS_FIELD);
    }

    public static class SnapshotLifecycleMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final Diff<Map<String, SnapshotLifecyclePolicyMetadata>> lifecycles;
        final OperationMode operationMode;
        final SnapshotLifecycleStats slmStats;

        SnapshotLifecycleMetadataDiff(SnapshotLifecycleMetadata before, SnapshotLifecycleMetadata after) {
            this.lifecycles = DiffableUtils.diff(before.snapshotConfigurations, after.snapshotConfigurations, DiffableUtils.getStringKeySerializer());
            this.operationMode = after.operationMode;
            this.slmStats = after.slmStats;
        }

        public SnapshotLifecycleMetadataDiff(StreamInput in) throws IOException {
            this.lifecycles = DiffableUtils.readJdkMapDiff(in, DiffableUtils.getStringKeySerializer(), SnapshotLifecyclePolicyMetadata::new, SnapshotLifecycleMetadataDiff::readLifecyclePolicyDiffFrom);
            this.operationMode = in.readEnum(OperationMode.class);
            this.slmStats = new SnapshotLifecycleStats(in);
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            TreeMap<String, SnapshotLifecyclePolicyMetadata> newLifecycles = new TreeMap<String, SnapshotLifecyclePolicyMetadata>(this.lifecycles.apply(((SnapshotLifecycleMetadata)part).snapshotConfigurations));
            return new SnapshotLifecycleMetadata(newLifecycles, this.operationMode, this.slmStats);
        }

        @Override
        public String getWriteableName() {
            return SnapshotLifecycleMetadata.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.lifecycles.writeTo(out);
            out.writeEnum(this.operationMode);
            this.slmStats.writeTo(out);
        }

        static Diff<SnapshotLifecyclePolicyMetadata> readLifecyclePolicyDiffFrom(StreamInput in) throws IOException {
            return SimpleDiffable.readDiffFrom(SnapshotLifecyclePolicyMetadata::new, in);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.ZERO;
        }
    }
}

