/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.PoolingSessionFactorySettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;

public final class ActiveDirectorySessionFactorySettings {
    private static final String AD_DOMAIN_NAME_SETTING_KEY = "domain_name";
    public static final Function<String, Setting.AffixSetting<String>> AD_DOMAIN_NAME_SETTING = RealmSettings.affixSetting("domain_name", key -> Setting.simpleString(key, v -> {
        if (Strings.isNullOrEmpty(v)) {
            throw new IllegalArgumentException("missing [" + key + "] setting for active directory");
        }
    }, Setting.Property.NodeScope));
    public static final String AD_GROUP_SEARCH_BASEDN_SETTING = "group_search.base_dn";
    public static final String AD_GROUP_SEARCH_SCOPE_SETTING = "group_search.scope";
    private static final String AD_USER_SEARCH_BASEDN_SETTING_KEY = "user_search.base_dn";
    public static final Setting.AffixSetting<String> AD_USER_SEARCH_BASEDN_SETTING = RealmSettings.simpleString("active_directory", "user_search.base_dn", Setting.Property.NodeScope);
    private static final String AD_USER_SEARCH_FILTER_SETTING_KEY = "user_search.filter";
    public static final Setting.AffixSetting<String> AD_USER_SEARCH_FILTER_SETTING = RealmSettings.simpleString("active_directory", "user_search.filter", Setting.Property.NodeScope);
    private static final String AD_UPN_USER_SEARCH_FILTER_SETTING_KEY = "user_search.upn_filter";
    public static final Setting.AffixSetting<String> AD_UPN_USER_SEARCH_FILTER_SETTING = RealmSettings.simpleString("active_directory", "user_search.upn_filter", Setting.Property.NodeScope);
    private static final String AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING_KEY = "user_search.down_level_filter";
    public static final Setting.AffixSetting<String> AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING = RealmSettings.simpleString("active_directory", "user_search.down_level_filter", Setting.Property.NodeScope);
    private static final String AD_USER_SEARCH_SCOPE_SETTING_KEY = "user_search.scope";
    public static final Setting.AffixSetting<String> AD_USER_SEARCH_SCOPE_SETTING = RealmSettings.simpleString("active_directory", "user_search.scope", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Integer> AD_LDAP_PORT_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("active_directory"), "port.ldap", key -> Setting.intSetting(key, 389, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> AD_LDAPS_PORT_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("active_directory"), "port.ldaps", key -> Setting.intSetting(key, 636, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> AD_GC_LDAP_PORT_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("active_directory"), "port.gc_ldap", key -> Setting.intSetting(key, 3268, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> AD_GC_LDAPS_PORT_SETTING = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("active_directory"), "port.gc_ldaps", key -> Setting.intSetting(key, 3269, Setting.Property.NodeScope), new Setting.AffixSettingDependency[0]);
    public static final String POOL_ENABLED_SUFFIX = "user_search.pool.enabled";
    public static final Setting.AffixSetting<Boolean> POOL_ENABLED = Setting.affixKeySetting(RealmSettings.realmSettingPrefix("active_directory"), "user_search.pool.enabled", key -> {
        if (key.endsWith(POOL_ENABLED_SUFFIX)) {
            String bindDnKey = key.substring(0, key.length() - POOL_ENABLED_SUFFIX.length()) + "bind_dn";
            return Setting.boolSetting(key, settings -> Boolean.toString(settings.keySet().contains(bindDnKey)), Setting.Property.NodeScope);
        }
        return Setting.boolSetting(key, false, Setting.Property.NodeScope);
    }, new Setting.AffixSettingDependency[0]);

    private ActiveDirectorySessionFactorySettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactorySettings.getSettings("active_directory"));
        settings.add(AD_DOMAIN_NAME_SETTING.apply("active_directory"));
        settings.add(RealmSettings.simpleString("active_directory", AD_GROUP_SEARCH_BASEDN_SETTING, Setting.Property.NodeScope));
        settings.add(RealmSettings.simpleString("active_directory", AD_GROUP_SEARCH_SCOPE_SETTING, Setting.Property.NodeScope));
        settings.add(AD_USER_SEARCH_BASEDN_SETTING);
        settings.add(AD_USER_SEARCH_FILTER_SETTING);
        settings.add(AD_UPN_USER_SEARCH_FILTER_SETTING);
        settings.add(AD_DOWN_LEVEL_USER_SEARCH_FILTER_SETTING);
        settings.add(AD_USER_SEARCH_SCOPE_SETTING);
        settings.add(AD_LDAP_PORT_SETTING);
        settings.add(AD_LDAPS_PORT_SETTING);
        settings.add(AD_GC_LDAP_PORT_SETTING);
        settings.add(AD_GC_LDAPS_PORT_SETTING);
        settings.add(POOL_ENABLED);
        settings.addAll(PoolingSessionFactorySettings.getSettings("active_directory"));
        return settings;
    }
}

