/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.CharArrays;
import org.elasticsearch.xpack.core.security.action.user.UserRequest;

public class ChangePasswordRequest
extends ActionRequest
implements UserRequest,
WriteRequest<ChangePasswordRequest> {
    private String username;
    private char[] passwordHash;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;

    public ChangePasswordRequest() {
    }

    public ChangePasswordRequest(StreamInput in) throws IOException {
        super(in);
        this.username = in.readString();
        this.passwordHash = CharArrays.utf8BytesToChars(BytesReference.toBytes(in.readSlicedBytesReference()));
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.username == null) {
            validationException = ValidateActions.addValidationError("username is missing", validationException);
        }
        if (this.passwordHash == null) {
            validationException = ValidateActions.addValidationError("password is missing", validationException);
        }
        return validationException;
    }

    public String username() {
        return this.username;
    }

    public void username(String username) {
        this.username = username;
    }

    public char[] passwordHash() {
        return this.passwordHash;
    }

    public void passwordHash(char[] passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    @Override
    public ChangePasswordRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public String[] usernames() {
        return new String[]{this.username};
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.username);
        out.writeBytesReference(new BytesArray(CharArrays.toUtf8Bytes(this.passwordHash)));
        this.refreshPolicy.writeTo(out);
    }
}

