/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action;

import java.io.IOException;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class ClearSecurityCacheRequest
extends BaseNodesRequest {
    private String cacheName;
    private String[] keys;

    public ClearSecurityCacheRequest() {
        super((String[])null);
    }

    public ClearSecurityCacheRequest cacheName(String cacheName) {
        this.cacheName = cacheName;
        return this;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public ClearSecurityCacheRequest keys(String ... keys) {
        this.keys = keys;
        return this;
    }

    public String[] keys() {
        return this.keys;
    }

    public static class Node
    extends TransportRequest {
        private String cacheName;
        private String[] keys;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.cacheName = in.readString();
            this.keys = in.readOptionalStringArray();
        }

        public Node(ClearSecurityCacheRequest request) {
            this.cacheName = request.cacheName();
            this.keys = request.keys();
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public String[] getKeys() {
            return this.keys;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.cacheName);
            out.writeOptionalStringArray(this.keys);
        }
    }
}

