/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;

public class SparseVectorQueryWrapper
extends Query {
    private final String fieldName;
    private final Query termsQuery;

    public SparseVectorQueryWrapper(String fieldName, Query termsQuery) {
        this.fieldName = fieldName;
        this.termsQuery = termsQuery;
    }

    public Query getTermsQuery() {
        return this.termsQuery;
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query rewrite = this.termsQuery.rewrite(indexSearcher);
        if (rewrite != this.termsQuery) {
            return new SparseVectorQueryWrapper(this.fieldName, rewrite);
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.termsQuery.createWeight(searcher, scoreMode, boost);
    }

    @Override
    public String toString(String field) {
        return this.termsQuery.toString(field);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.fieldName)) {
            this.termsQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        SparseVectorQueryWrapper that = (SparseVectorQueryWrapper)obj;
        return this.fieldName.equals(that.fieldName) && this.termsQuery.equals(that.termsQuery);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldName, this.termsQuery);
    }
}

