/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.EmptyInfo;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitUntilReplicateForTimePassesStep
extends AsyncWaitStep {
    public static final String NAME = "check-replicate-for-time-passed";
    private final TimeValue replicateFor;
    private final Supplier<Instant> nowSupplier;
    private static final TimeValue TWENTY_FOUR_HOURS = TimeValue.timeValueHours(24L);

    WaitUntilReplicateForTimePassesStep(Step.StepKey key, Step.StepKey nextStepKey, TimeValue replicateFor, Supplier<Instant> nowSupplier) {
        super(key, nextStepKey, null);
        this.replicateFor = replicateFor;
        this.nowSupplier = nowSupplier;
    }

    WaitUntilReplicateForTimePassesStep(Step.StepKey key, Step.StepKey nextStepKey, TimeValue replicateFor) {
        this(key, nextStepKey, replicateFor, Instant::now);
    }

    public TimeValue getReplicateFor() {
        return this.replicateFor;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.replicateFor);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        WaitUntilReplicateForTimePassesStep other = (WaitUntilReplicateForTimePassesStep)obj;
        return super.equals(obj) && Objects.equals(this.replicateFor, other.replicateFor);
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        IndexMetadata indexMetadata = metadata.index(index);
        assert (indexMetadata != null) : "the index metadata for index [" + index.getName() + "] must exist in the cluster state for step [check-replicate-for-time-passed]";
        LifecycleExecutionState executionState = metadata.index(index.getName()).getLifecycleExecutionState();
        assert (executionState != null) : "the lifecycle execution state for index [" + index.getName() + "] must exist in the cluster state for step [check-replicate-for-time-passed]";
        if (this.replicateFor == null) {
            assert (false) : "the replicate_for time value for index [" + index.getName() + "] must not be null for step [check-replicate-for-time-passed]";
            listener.onResponse(true, EmptyInfo.INSTANCE);
            return;
        }
        Instant endTime = Instant.ofEpochMilli(executionState.phaseTime() + this.replicateFor.millis());
        Instant nowTime = this.nowSupplier.get();
        if (nowTime.isBefore(endTime)) {
            TimeValue remaining = TimeValue.timeValueMillis(endTime.toEpochMilli() - nowTime.toEpochMilli());
            listener.onResponse(false, new SingleMessageFieldInfo(Strings.format("Waiting [%s] until the replicate_for time [%s] has elapsed for index [%s] before removing replicas.", WaitUntilReplicateForTimePassesStep.approximateTimeRemaining(remaining), this.replicateFor, index.getName())));
            return;
        }
        listener.onResponse(true, EmptyInfo.INSTANCE);
    }

    static String approximateTimeRemaining(TimeValue remaining) {
        if (remaining.compareTo(TWENTY_FOUR_HOURS) >= 0) {
            return "approximately " + Math.round(remaining.daysFrac()) + "d";
        }
        return "less than 1d";
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

