/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-snapshot";

    public CleanupSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(final IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Void> listener) {
        final String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        final String repositoryName = lifecycleState.snapshotRepository();
        if (!Strings.hasText(repositoryName)) {
            listener.onResponse(null);
            return;
        }
        String snapshotName = lifecycleState.snapshotName();
        if (!Strings.hasText(snapshotName)) {
            listener.onResponse(null);
            return;
        }
        this.getClient().admin().cluster().prepareDeleteSnapshot(TimeValue.MAX_VALUE, repositoryName, snapshotName).execute(new ActionListener<AcknowledgedResponse>(this){

            @Override
            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                assert (acknowledgedResponse.isAcknowledged());
                listener.onResponse(null);
            }

            @Override
            public void onFailure(Exception e) {
                if (e instanceof SnapshotMissingException) {
                    listener.onResponse(null);
                } else if (e instanceof RepositoryMissingException) {
                    String policyName = indexMetadata.getLifecyclePolicyName();
                    listener.onFailure(new IllegalStateException("repository [" + repositoryName + "] is missing. [" + policyName + "] policy for index [" + indexName + "] cannot continue until the repository is created", e));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }
}

