/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.health.stats.HealthApiStatsAction;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.HealthApiFeatureSetUsage;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;

public class HealthApiUsageTransportAction
extends XPackUsageFeatureTransportAction {
    private final Client client;

    @Inject
    public HealthApiUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client) {
        super(XPackUsageFeatureAction.HEALTH.name(), transportService, clusterService, threadPool, actionFilters);
        this.client = client;
    }

    @Override
    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        ContextPreservingActionListener<XPackUsageFeatureResponse> preservingListener = ContextPreservingActionListener.wrapPreservingContext(listener, this.client.threadPool().getThreadContext());
        if (state.clusterRecovered()) {
            HealthApiStatsAction.Request statsRequest = new HealthApiStatsAction.Request();
            statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
            this.client.execute(HealthApiStatsAction.INSTANCE, statsRequest, preservingListener.delegateFailureAndWrap((l, r) -> {
                HealthApiFeatureSetUsage usage = new HealthApiFeatureSetUsage(true, true, r.getStats());
                l.onResponse(new XPackUsageFeatureResponse(usage));
            }));
        } else {
            HealthApiFeatureSetUsage usage = new HealthApiFeatureSetUsage(false, true, null);
            preservingListener.onResponse(new XPackUsageFeatureResponse(usage));
        }
    }
}

