/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiTerms;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.SearchSortValuesAndFormats;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.MinAndMax;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.ShardDocSortField;
import org.elasticsearch.search.sort.SortAndFormats;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class FieldSortBuilder
extends SortBuilder<FieldSortBuilder> {
    public static final String NAME = "field_sort";
    public static final ParseField MISSING = new ParseField("missing", new String[0]);
    public static final ParseField SORT_MODE = new ParseField("mode", new String[0]);
    public static final ParseField UNMAPPED_TYPE = new ParseField("unmapped_type", new String[0]);
    public static final ParseField NUMERIC_TYPE = new ParseField("numeric_type", new String[0]);
    public static final ParseField FORMAT = new ParseField("format", new String[0]);
    public static final String DOC_FIELD_NAME = "_doc";
    public static final String SHARD_DOC_FIELD_NAME = "_shard_doc";
    private static final SortFieldAndFormat SORT_DOC = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC), DocValueFormat.RAW);
    private static final SortFieldAndFormat SORT_DOC_REVERSE = new SortFieldAndFormat(new SortField(null, SortField.Type.DOC, true), DocValueFormat.RAW);
    private final String fieldName;
    private Object missing;
    private String unmappedType;
    private String numericType;
    private SortMode sortMode;
    private NestedSortBuilder nestedSort;
    private String format;
    private static final ObjectParser<FieldSortBuilder, Void> PARSER = new ObjectParser("field_sort");

    public FieldSortBuilder(FieldSortBuilder template) {
        this(template.fieldName);
        this.order(template.order());
        this.missing(template.missing());
        this.unmappedType(template.unmappedType());
        if (template.sortMode != null) {
            this.sortMode(template.sortMode());
        }
        if (template.getNestedSort() != null) {
            this.setNestedSort(template.getNestedSort());
        }
        this.numericType = template.numericType;
    }

    public FieldSortBuilder(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        this.fieldName = fieldName;
    }

    public FieldSortBuilder(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0) && (in.readOptionalNamedWriteable(QueryBuilder.class) != null || in.readOptionalString() != null)) {
            throw new IOException("the [sort] options [nested_path] and [nested_filter] are removed in 8.x, please use [nested] instead");
        }
        this.missing = in.readGenericValue();
        this.order = in.readOptionalWriteable(SortOrder::readFromStream);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.unmappedType = in.readOptionalString();
        this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
        this.numericType = in.readOptionalString();
        this.format = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalNamedWriteable(null);
            out.writeOptionalString(null);
        }
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.order);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.unmappedType);
        out.writeOptionalWriteable(this.nestedSort);
        out.writeOptionalString(this.numericType);
        out.writeOptionalString(this.format);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public FieldSortBuilder missing(Object missing) {
        this.missing = missing;
        return this;
    }

    public Object missing() {
        return this.missing;
    }

    public FieldSortBuilder unmappedType(String type) {
        this.unmappedType = type;
        return this;
    }

    public String unmappedType() {
        return this.unmappedType;
    }

    public FieldSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null");
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public FieldSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        this.nestedSort = nestedSort;
        return this;
    }

    public String getNumericType() {
        return this.numericType;
    }

    public FieldSortBuilder setNumericType(String numericType) {
        String lowerCase;
        switch (lowerCase = numericType.toLowerCase(Locale.ENGLISH)) {
            case "long": 
            case "double": 
            case "date": 
            case "date_nanos": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for [numeric_type], must be [long, double, date, date_nanos], got " + lowerCase);
            }
        }
        this.numericType = lowerCase;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public FieldSortBuilder setFormat(String format) {
        this.format = format;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.fieldName);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.missing != null) {
            builder.field(MISSING.getPreferredName(), this.missing);
        }
        if (this.unmappedType != null) {
            builder.field(UNMAPPED_TYPE.getPreferredName(), this.unmappedType);
        }
        if (this.sortMode != null) {
            builder.field(SORT_MODE.getPreferredName(), this.sortMode);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), this.nestedSort);
        }
        if (this.numericType != null) {
            builder.field(NUMERIC_TYPE.getPreferredName(), this.numericType);
        }
        if (this.format != null) {
            builder.field(FORMAT.getPreferredName(), this.format);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    private static IndexNumericFieldData.NumericType resolveNumericType(String value) {
        return switch (value) {
            case "long" -> IndexNumericFieldData.NumericType.LONG;
            case "double" -> IndexNumericFieldData.NumericType.DOUBLE;
            case "date" -> IndexNumericFieldData.NumericType.DATE;
            case "date_nanos" -> IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
            default -> throw new IllegalArgumentException("invalid value for [numeric_type], must be [long, double, date, date_nanos], got " + value);
        };
    }

    @Override
    public SortFieldAndFormat build(SearchExecutionContext context) throws IOException {
        SortField field;
        Object fieldData;
        boolean reverse;
        boolean bl = reverse = this.order == SortOrder.DESC;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            return reverse ? SORT_DOC_REVERSE : SORT_DOC;
        }
        if (SHARD_DOC_FIELD_NAME.equals(this.fieldName)) {
            return new SortFieldAndFormat(new ShardDocSortField(context.getShardRequestIndex(), reverse), DocValueFormat.RAW);
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context, fieldType);
        if (fieldType == null) {
            fieldType = this.resolveUnmappedType(context);
        }
        if (!((fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH)) instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException((QueryRewriteContext)context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        boolean isNanosecond = false;
        if (this.numericType != null) {
            if (!(fieldData instanceof IndexNumericFieldData)) {
                throw new QueryShardException((QueryRewriteContext)context, "[numeric_type] option cannot be set on a non-numeric field, got " + fieldType.typeName(), new Object[0]);
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)fieldData;
            IndexNumericFieldData.NumericType resolvedType = FieldSortBuilder.resolveNumericType(this.numericType);
            field = numericFieldData.sortField(resolvedType, this.missing, this.localSortMode(), nested, reverse);
            isNanosecond = resolvedType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
        } else {
            field = fieldData.sortField(this.missing, this.localSortMode(), nested, reverse);
            if (fieldData instanceof IndexNumericFieldData) {
                isNanosecond = ((IndexNumericFieldData)fieldData).getNumericType() == IndexNumericFieldData.NumericType.DATE_NANOSECONDS;
            }
        }
        DocValueFormat formatter = fieldType.docValueFormat(this.format, null);
        if (this.format != null) {
            formatter = DocValueFormat.enableFormatSortValues(formatter);
        }
        if (isNanosecond) {
            formatter = DocValueFormat.withNanosecondResolution(formatter);
        }
        return new SortFieldAndFormat(field, formatter);
    }

    public boolean canRewriteToMatchNone() {
        return this.nestedSort == null && (this.missing == null || "_last".equals(this.missing));
    }

    public boolean isBottomSortShardDisjoint(SearchExecutionContext context, SearchSortValuesAndFormats bottomSortValues) throws IOException {
        if (bottomSortValues == null || bottomSortValues.getRawSortValues().length == 0) {
            return false;
        }
        if (!this.canRewriteToMatchNone()) {
            return false;
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType == null) {
            return false;
        }
        if (!fieldType.isIndexed()) {
            return false;
        }
        DocValueFormat docValueFormat = bottomSortValues.getSortValueFormats()[0];
        DateMathParser dateMathParser = docValueFormat instanceof DocValueFormat.DateTime ? ((DocValueFormat.DateTime)docValueFormat).getDateMathParser() : null;
        Object bottomSortValue = bottomSortValues.getFormattedSortValues()[0];
        Object minValue = this.order() == SortOrder.DESC ? bottomSortValue : null;
        Object maxValue = this.order() == SortOrder.DESC ? null : bottomSortValue;
        try {
            MappedFieldType.Relation relation = fieldType.isFieldWithinQuery(context.getIndexReader(), minValue, maxValue, true, true, null, dateMathParser, context);
            return relation == MappedFieldType.Relation.DISJOINT;
        }
        catch (ElasticsearchParseException exc) {
            return false;
        }
    }

    @Override
    public BucketedSort buildBucketedSort(SearchExecutionContext context, BigArrays bigArrays, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        Object fieldData;
        if (DOC_FIELD_NAME.equals(this.fieldName)) {
            throw new IllegalArgumentException("sorting by _doc is not supported");
        }
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        IndexFieldData.XFieldComparatorSource.Nested nested = this.nested(context, fieldType);
        if (fieldType == null) {
            fieldType = this.resolveUnmappedType(context);
        }
        if (!((fieldData = context.getForField(fieldType, MappedFieldType.FielddataOperation.SEARCH)) instanceof IndexNumericFieldData || this.sortMode != SortMode.SUM && this.sortMode != SortMode.AVG && this.sortMode != SortMode.MEDIAN)) {
            throw new QueryShardException((QueryRewriteContext)context, "we only support AVG, MEDIAN and SUM on number based fields", new Object[0]);
        }
        if (this.numericType != null) {
            if (!(fieldData instanceof IndexNumericFieldData)) {
                throw new QueryShardException((QueryRewriteContext)context, "[numeric_type] option cannot be set on a non-numeric field, got " + fieldType.typeName(), new Object[0]);
            }
            IndexNumericFieldData numericFieldData = (IndexNumericFieldData)fieldData;
            IndexNumericFieldData.NumericType resolvedType = FieldSortBuilder.resolveNumericType(this.numericType);
            return numericFieldData.newBucketedSort(resolvedType, bigArrays, this.missing, this.localSortMode(), nested, this.order, fieldType.docValueFormat(null, null), bucketSize, extra);
        }
        try {
            return fieldData.newBucketedSort(bigArrays, this.missing, this.localSortMode(), nested, this.order, fieldType.docValueFormat(null, null), bucketSize, extra);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("error building sort for field [" + this.fieldName + "] of type [" + fieldType.typeName() + "] in index [" + context.index().getName() + "]: " + e.getMessage(), e);
        }
    }

    private MappedFieldType resolveUnmappedType(SearchExecutionContext context) {
        if (this.unmappedType == null) {
            throw new QueryShardException((QueryRewriteContext)context, "No mapping found for [" + this.fieldName + "] in order to sort on", new Object[0]);
        }
        return context.buildAnonymousFieldType(this.unmappedType);
    }

    private MultiValueMode localSortMode() {
        if (this.sortMode != null) {
            return MultiValueMode.fromString(this.sortMode.toString());
        }
        return this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
    }

    private IndexFieldData.XFieldComparatorSource.Nested nested(SearchExecutionContext context, MappedFieldType fieldType) throws IOException {
        if (fieldType == null) {
            return null;
        }
        if (this.nestedSort == null) {
            FieldSortBuilder.validateMissingNestedPath(context, this.fieldName);
            return null;
        }
        FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
        return FieldSortBuilder.resolveNested(context, this.nestedSort);
    }

    public static boolean hasPrimaryFieldSort(SearchSourceBuilder source) {
        return FieldSortBuilder.getPrimaryFieldSortOrNull(source) != null;
    }

    public static FieldSortBuilder getPrimaryFieldSortOrNull(SearchSourceBuilder source) {
        FieldSortBuilder fieldSortBuilder;
        List<SortBuilder<?>> sorts;
        if (source == null || (sorts = source.sorts()) == null || sorts.isEmpty()) {
            return null;
        }
        SortBuilder<?> sortBuilder = sorts.get(0);
        return sortBuilder instanceof FieldSortBuilder ? (fieldSortBuilder = (FieldSortBuilder)sortBuilder) : null;
    }

    public static MinAndMax<?> getMinMaxOrNull(SearchExecutionContext context, FieldSortBuilder sortBuilder) throws IOException {
        SortAndFormats sort = SortBuilder.buildSort(Collections.singletonList(sortBuilder), context).get();
        SortField sortField = sort.sort.getSort()[0];
        if (sortField.getField() == null) {
            return null;
        }
        IndexReader reader = context.getIndexReader();
        MappedFieldType fieldType = context.getFieldType(sortField.getField());
        if (reader == null || fieldType == null || !fieldType.isIndexed()) {
            return null;
        }
        switch (IndexSortConfig.getSortFieldType(sortField)) {
            case LONG: 
            case INT: 
            case DOUBLE: 
            case FLOAT: {
                return FieldSortBuilder.extractNumericMinAndMax(reader, sortField, fieldType, sortBuilder);
            }
            case STRING: 
            case STRING_VAL: {
                if (!(fieldType instanceof KeywordFieldMapper.KeywordFieldType)) break;
                Terms terms = MultiTerms.getTerms(reader, fieldType.name());
                if (terms == null) {
                    return null;
                }
                return terms.getMin() != null ? new MinAndMax<BytesRef>(terms.getMin(), terms.getMax()) : null;
            }
        }
        return null;
    }

    private static MinAndMax<?> extractNumericMinAndMax(IndexReader reader, SortField sortField, MappedFieldType fieldType, FieldSortBuilder sortBuilder) throws IOException {
        String fieldName = fieldType.name();
        byte[] minPackedValue = PointValues.getMinPackedValue(reader, fieldName);
        if (minPackedValue == null) {
            return null;
        }
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            NumberFieldMapper.NumberFieldType numberFieldType = (NumberFieldMapper.NumberFieldType)fieldType;
            Number minPoint = numberFieldType.parsePoint(minPackedValue);
            Number maxPoint = numberFieldType.parsePoint(PointValues.getMaxPackedValue(reader, fieldName));
            return switch (IndexSortConfig.getSortFieldType(sortField)) {
                case SortField.Type.LONG -> new MinAndMax<Long>(minPoint.longValue(), maxPoint.longValue());
                case SortField.Type.INT -> new MinAndMax<Integer>(minPoint.intValue(), maxPoint.intValue());
                case SortField.Type.DOUBLE -> new MinAndMax<Double>(minPoint.doubleValue(), maxPoint.doubleValue());
                case SortField.Type.FLOAT -> new MinAndMax<Float>(Float.valueOf(minPoint.floatValue()), Float.valueOf(maxPoint.floatValue()));
                default -> null;
            };
        }
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            DateFieldMapper.DateFieldType dateFieldType = (DateFieldMapper.DateFieldType)fieldType;
            Function<byte[], Long> dateConverter = FieldSortBuilder.createDateConverter(sortBuilder, dateFieldType);
            Long min = dateConverter.apply(minPackedValue);
            Long max = dateConverter.apply(PointValues.getMaxPackedValue(reader, fieldName));
            return new MinAndMax<Long>(min, max);
        }
        return null;
    }

    private static Function<byte[], Long> createDateConverter(FieldSortBuilder sortBuilder, DateFieldMapper.DateFieldType dateFieldType) {
        String numericTypeStr = sortBuilder.getNumericType();
        if (numericTypeStr != null) {
            IndexNumericFieldData.NumericType numericType = FieldSortBuilder.resolveNumericType(numericTypeStr);
            if (dateFieldType.resolution() == DateFieldMapper.Resolution.MILLISECONDS && numericType == IndexNumericFieldData.NumericType.DATE_NANOSECONDS) {
                return v -> DateUtils.toNanoSeconds(LongPoint.decodeDimension(v, 0));
            }
            if (dateFieldType.resolution() == DateFieldMapper.Resolution.NANOSECONDS && numericType == IndexNumericFieldData.NumericType.DATE) {
                return v -> DateUtils.toMilliSeconds(LongPoint.decodeDimension(v, 0));
            }
        }
        return v -> LongPoint.decodeDimension(v, 0);
    }

    static void validateMaxChildrenExistOnlyInTopLevelNestedSort(SearchExecutionContext context, NestedSortBuilder nestedSort) {
        for (NestedSortBuilder child = nestedSort.getNestedSort(); child != null; child = child.getNestedSort()) {
            if (child.getMaxChildren() == Integer.MAX_VALUE) continue;
            throw new QueryShardException((QueryRewriteContext)context, "max_children is only supported on top level of nested sort", new Object[0]);
        }
    }

    static void validateMissingNestedPath(SearchExecutionContext context, String field) {
        NestedObjectMapper contextMapper = context.nestedScope().getObjectMapper();
        if (contextMapper != null) {
            return;
        }
        NestedLookup nestedLookup = context.nestedLookup();
        String nestedParent = nestedLookup.getNestedParent(field);
        if (nestedParent != null && !nestedLookup.getNestedMappers().get(nestedParent).isIncludeInRoot()) {
            throw new QueryShardException((QueryRewriteContext)context, "it is mandatory to set the [nested] context on the nested sort field: [" + field + "].", new Object[0]);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FieldSortBuilder builder = (FieldSortBuilder)other;
        return Objects.equals(this.fieldName, builder.fieldName) && Objects.equals(this.missing, builder.missing) && Objects.equals(this.order, builder.order) && Objects.equals(this.sortMode, builder.sortMode) && Objects.equals(this.unmappedType, builder.unmappedType) && Objects.equals(this.nestedSort, builder.nestedSort) && Objects.equals(this.numericType, builder.numericType) && Objects.equals(this.format, builder.format);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.nestedSort, this.missing, this.order, this.sortMode, this.unmappedType, this.numericType, this.format);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ZERO;
    }

    public static FieldSortBuilder fromXContent(XContentParser parser, String fieldName) throws IOException {
        return PARSER.parse(parser, new FieldSortBuilder(fieldName), null);
    }

    @Override
    public FieldSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedSort == null) {
            return this;
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new FieldSortBuilder(this).setNestedSort(rewrite);
    }

    @Override
    public boolean supportsParallelCollection() {
        return false;
    }

    static {
        PARSER.declareField(FieldSortBuilder::missing, XContentParser::objectText, MISSING, ObjectParser.ValueType.VALUE);
        PARSER.declareString(FieldSortBuilder::unmappedType, UNMAPPED_TYPE);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORT_MODE);
        PARSER.declareObject(FieldSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
        PARSER.declareString(FieldSortBuilder::setNumericType, NUMERIC_TYPE);
        PARSER.declareString(FieldSortBuilder::setFormat, FORMAT);
    }
}

