/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceFilter;
import org.elasticsearch.search.lookup.StoredFieldSourceProvider;
import org.elasticsearch.search.lookup.SyntheticSourceProvider;

public interface SourceProvider {
    public Source getSource(LeafReaderContext var1, int var2) throws IOException;

    public static SourceProvider fromStoredFields() {
        StoredFieldLoader storedFieldLoader = StoredFieldLoader.sequentialSource();
        return new StoredFieldSourceProvider(storedFieldLoader);
    }

    public static SourceProvider fromSyntheticSource(Mapping mapping, SourceFilter filter, SourceFieldMetrics metrics) {
        return new SyntheticSourceProvider(new SourceLoader.Synthetic(filter, () -> mapping.syntheticFieldLoader(filter), metrics));
    }
}

