/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public record StoredFieldsSpec(boolean requiresSource, boolean requiresMetadata, Set<String> requiredStoredFields) {
    public static final StoredFieldsSpec NO_REQUIREMENTS = new StoredFieldsSpec(false, false, Set.of());
    public static final StoredFieldsSpec NEEDS_SOURCE = new StoredFieldsSpec(true, false, Set.of());

    public boolean noRequirements() {
        return !this.requiresSource && !this.requiresMetadata && this.requiredStoredFields.isEmpty();
    }

    public StoredFieldsSpec merge(StoredFieldsSpec other) {
        Set<String> mergedFields;
        if (this == other) {
            return this;
        }
        if (other.requiredStoredFields.isEmpty()) {
            mergedFields = this.requiredStoredFields;
        } else {
            mergedFields = new HashSet<String>(this.requiredStoredFields);
            mergedFields.addAll(other.requiredStoredFields);
        }
        return new StoredFieldsSpec(this.requiresSource || other.requiresSource, this.requiresMetadata || other.requiresMetadata, mergedFields);
    }

    public static <T> StoredFieldsSpec build(Collection<T> sources, Function<T, StoredFieldsSpec> converter) {
        StoredFieldsSpec storedFieldsSpec = NO_REQUIREMENTS;
        for (T source : sources) {
            storedFieldsSpec = storedFieldsSpec.merge(converter.apply(source));
        }
        return storedFieldsSpec;
    }
}

