/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.common.util.ObjectArrayPriorityQueue;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.BucketAndOrd;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.elasticsearch.search.aggregations.bucket.terms.SignificanceLookup;
import org.elasticsearch.search.aggregations.bucket.terms.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.xcontent.XContentBuilder;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ResultStrategy<?, ?, ?> resultStrategy;
    protected final ValuesSource.Bytes.WithOrdinals valuesSource;
    private final LongPredicate acceptedGlobalOrdinals;
    private final CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier;
    private final long valueCount;
    protected final CollectionStrategy collectionStrategy;
    protected int segmentsWithSingleValuedOrds = 0;
    protected int segmentsWithMultiValuedOrds = 0;
    static final LongPredicate ALWAYS_TRUE = l -> true;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, Function<GlobalOrdinalsStringTermsAggregator, ResultStrategy<?, ?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, LongPredicate acceptedOrds, AggregationContext context, Aggregator parent, boolean remapGlobalOrds, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, metadata);
        this.resultStrategy = resultStrategy.apply(this);
        this.valuesSource = valuesSource;
        this.valuesSupplier = valuesSupplier;
        this.valueCount = valuesSupplier.get().getValueCount();
        this.acceptedGlobalOrdinals = acceptedOrds;
        this.collectionStrategy = remapGlobalOrds ? new RemapGlobalOrds(this.resultStrategy, cardinality, excludeDeletedDocs) : (CollectionStrategy)cardinality.map(estimate -> {
            if (estimate > 1) {
                throw new AggregationExecutionException("Dense ords don't know how to collect from many buckets");
            }
            return new DenseGlobalOrds(this.resultStrategy, excludeDeletedDocs);
        });
    }

    String descriptCollectionStrategy() {
        return this.collectionStrategy.describe();
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, final LeafBucketCollector sub) throws IOException {
        final SortedSetDocValues globalOrds = this.valuesSource.globalOrdinalsValues(aggCtx.getLeafReaderContext());
        this.collectionStrategy.globalOrdsReady(globalOrds);
        final SortedDocValues singleValues = DocValues.unwrapSingleton(globalOrds);
        if (singleValues != null) {
            ++this.segmentsWithSingleValuedOrds;
            if (this.acceptedGlobalOrdinals == ALWAYS_TRUE) {
                return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                    @Override
                    public void collect(int doc, long owningBucketOrd) throws IOException {
                        if (!singleValues.advanceExact(doc)) {
                            return;
                        }
                        int globalOrd = singleValues.ordValue();
                        GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                    }
                });
            }
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!singleValues.advanceExact(doc)) {
                        return;
                    }
                    int globalOrd = singleValues.ordValue();
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) {
                        return;
                    }
                    GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                }
            });
        }
        ++this.segmentsWithMultiValuedOrds;
        if (this.acceptedGlobalOrdinals == ALWAYS_TRUE) {
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!globalOrds.advanceExact(doc)) {
                        return;
                    }
                    for (int i = 0; i < globalOrds.docValueCount(); ++i) {
                        long globalOrd = globalOrds.nextOrd();
                        GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                    }
                }
            });
        }
        return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, globalOrds){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                if (!globalOrds.advanceExact(doc)) {
                    return;
                }
                for (int i = 0; i < globalOrds.docValueCount(); ++i) {
                    long globalOrd = globalOrds.nextOrd();
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                    GlobalOrdinalsStringTermsAggregator.this.collectionStrategy.collectGlobalOrd(owningBucketOrd, doc, globalOrd, sub);
                }
            }
        });
    }

    @Override
    public InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
        if (this.valueCount == 0L) {
            return this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.resultStrategy.buildNoValuesResult(owningBucketOrds.get(ordIdx)));
        }
        return this.collectionStrategy.buildAggregations(owningBucketOrds);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return this.resultStrategy.buildEmptyResult();
    }

    @Override
    public void collectDebugInfo(BiConsumer<String, Object> add) {
        super.collectDebugInfo(add);
        add.accept("collection_strategy", this.collectionStrategy.describe());
        add.accept("total_buckets", this.collectionStrategy.totalBuckets());
        add.accept("result_strategy", this.resultStrategy.describe());
        add.accept("segments_with_single_valued_ords", this.segmentsWithSingleValuedOrds);
        add.accept("segments_with_multi_valued_ords", this.segmentsWithMultiValuedOrds);
        add.accept("has_filter", this.acceptedGlobalOrdinals != ALWAYS_TRUE);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.resultStrategy, this.collectionStrategy);
    }

    abstract class ResultStrategy<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket, TB extends InternalMultiBucketAggregation.InternalBucket>
    implements Releasable {
        ResultStrategy(GlobalOrdinalsStringTermsAggregator this$0) {
        }

        abstract String describe();

        abstract LeafBucketCollector wrapCollector(LeafBucketCollector var1);

        abstract TB buildEmptyTemporaryBucket();

        abstract BucketUpdater<TB> bucketUpdater(long var1, GlobalOrdLookupFunction var3);

        abstract ObjectArrayPriorityQueue<BucketAndOrd<TB>> buildPriorityQueue(int var1);

        abstract ObjectArray<B[]> buildTopBucketsPerOrd(long var1);

        abstract B[] buildBuckets(int var1);

        abstract B convertTempBucketToRealBucket(TB var1, GlobalOrdLookupFunction var2) throws IOException;

        abstract void buildSubAggs(ObjectArray<B[]> var1, LongArray var2) throws IOException;

        abstract R buildResult(long var1, long var3, B[] var5);

        abstract R buildEmptyResult();

        abstract R buildNoValuesResult(long var1);
    }

    private class RemapGlobalOrds<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket, TB extends InternalMultiBucketAggregation.InternalBucket>
    extends CollectionStrategy {
        private final LongKeyedBucketOrds bucketOrds;
        private final boolean excludeDeletedDocs;
        private final ResultStrategy<R, B, TB> collectionStrategy;

        private RemapGlobalOrds(ResultStrategy<R, B, TB> collectionStrategy, CardinalityUpperBound cardinality, boolean excludeDeletedDocs) {
            this.bucketOrds = LongKeyedBucketOrds.buildForValueRange(GlobalOrdinalsStringTermsAggregator.this.bigArrays(), cardinality, 0L, GlobalOrdinalsStringTermsAggregator.this.valueCount - 1L);
            this.excludeDeletedDocs = excludeDeletedDocs;
            this.collectionStrategy = collectionStrategy;
        }

        @Override
        String describe() {
            return "remap using " + this.bucketOrds.decribe();
        }

        @Override
        long totalBuckets() {
            return this.bucketOrds.size();
        }

        @Override
        void globalOrdsReady(SortedSetDocValues globalOrds) {
        }

        @Override
        void collectGlobalOrd(long owningBucketOrd, int doc, long globalOrd, LeafBucketCollector sub) throws IOException {
            long bucketOrd = this.bucketOrds.add(owningBucketOrd, globalOrd);
            if (bucketOrd < 0L) {
                bucketOrd = -1L - bucketOrd;
                GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
            } else {
                GlobalOrdinalsStringTermsAggregator.this.collectBucket(sub, doc, bucketOrd);
            }
        }

        @Override
        long globalOrdToBucketOrd(long owningBucketOrd, long globalOrd) {
            return this.bucketOrds.find(owningBucketOrd, globalOrd);
        }

        private void collectZeroDocEntriesIfNeeded(long owningBucketOrd) throws IOException {
            if (this.excludeDeletedDocs) {
                this.forEachExcludeDeletedDocs(owningBucketOrd);
            } else if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L) {
                for (long globalOrd = 0L; globalOrd < GlobalOrdinalsStringTermsAggregator.this.valueCount; ++globalOrd) {
                    if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                    this.bucketOrds.add(owningBucketOrd, globalOrd);
                }
            }
        }

        private void forEachExcludeDeletedDocs(long owningBucketOrd) throws IOException {
            assert (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() == 0L);
            try (LongHash accepted = new LongHash(20L, GlobalOrdinalsStringTermsAggregator.this.bigArrays());){
                for (LeafReaderContext ctx : GlobalOrdinalsStringTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                    LeafReader reader = ctx.reader();
                    Bits liveDocs = reader.getLiveDocs();
                    SortedSetDocValues globalOrds = null;
                    for (int docId = 0; docId < reader.maxDoc(); ++docId) {
                        if (liveDocs != null && !liveDocs.get(docId)) continue;
                        SortedSetDocValues sortedSetDocValues = globalOrds = globalOrds == null ? GlobalOrdinalsStringTermsAggregator.this.valuesSource.globalOrdinalsValues(ctx) : globalOrds;
                        if (!globalOrds.advanceExact(docId)) continue;
                        for (int i = 0; i < globalOrds.docValueCount(); ++i) {
                            long globalOrd = globalOrds.nextOrd();
                            if (accepted.find(globalOrd) >= 0L || !GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                            this.bucketOrds.add(owningBucketOrd, globalOrd);
                            accepted.add(globalOrd);
                        }
                    }
                }
            }
        }

        @Override
        public void close() {
            this.bucketOrds.close();
        }

        @Override
        InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
            try (LongArray otherDocCount = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(owningBucketOrds.size(), true);){
                InternalAggregation[] internalAggregationArray;
                block37: {
                    ObjectArray<B[]> topBucketsPreOrd = this.collectionStrategy.buildTopBucketsPerOrd(owningBucketOrds.size());
                    try {
                        try (IntArray bucketsToCollect = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newIntArray(owningBucketOrds.size());){
                            long ordsToCollect = 0L;
                            for (long ordIdx2 = 0L; ordIdx2 < owningBucketOrds.size(); ++ordIdx2) {
                                long owningBucketOrd = owningBucketOrds.get(ordIdx2);
                                this.collectZeroDocEntriesIfNeeded(owningBucketOrd);
                                int size = (int)Math.min(this.bucketOrds.bucketsInOrd(owningBucketOrd), (long)GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize());
                                ordsToCollect += (long)size;
                                bucketsToCollect.set(ordIdx2, size);
                            }
                            try (LongArray ordsArray = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(ordsToCollect);){
                                long ordsCollected = 0L;
                                GlobalOrdLookupFunction lookupGlobalOrd = GlobalOrdinalsStringTermsAggregator.this.valuesSupplier.get()::lookupOrd;
                                for (long ordIdx3 = 0L; ordIdx3 < topBucketsPreOrd.size(); ++ordIdx3) {
                                    long owningBucketOrd = owningBucketOrds.get(ordIdx3);
                                    try (ObjectArrayPriorityQueue<BucketAndOrd<TB>> ordered = this.collectionStrategy.buildPriorityQueue(bucketsToCollect.get(ordIdx3));){
                                        BucketUpdater<InternalMultiBucketAggregation.InternalBucket> updater = this.collectionStrategy.bucketUpdater(owningBucketOrd, lookupGlobalOrd);
                                        LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = this.bucketOrds.ordsEnum(owningBucketOrd);
                                        BucketAndOrd<TB> spare = null;
                                        while (ordsEnum.next()) {
                                            long docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(ordsEnum.ord());
                                            otherDocCount.increment(ordIdx3, docCount);
                                            if (docCount < GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) continue;
                                            if (spare == null) {
                                                GlobalOrdinalsStringTermsAggregator.this.checkRealMemoryCBForInternalBucket();
                                                spare = new BucketAndOrd<TB>(this.collectionStrategy.buildEmptyTemporaryBucket());
                                            }
                                            updater.updateBucket((InternalMultiBucketAggregation.InternalBucket)spare.bucket, ordsEnum.value(), docCount);
                                            spare.ord = ordsEnum.ord();
                                            spare = ordered.insertWithOverflow(spare);
                                        }
                                        int orderedSize = (int)ordered.size();
                                        InternalMultiBucketAggregation.InternalBucket[] buckets = this.collectionStrategy.buildBuckets(orderedSize);
                                        for (int i = orderedSize - 1; i >= 0; --i) {
                                            GlobalOrdinalsStringTermsAggregator.this.checkRealMemoryCBForInternalBucket();
                                            BucketAndOrd<TB> bucketAndOrd = ordered.pop();
                                            B bucket = this.collectionStrategy.convertTempBucketToRealBucket((InternalMultiBucketAggregation.InternalBucket)bucketAndOrd.bucket, lookupGlobalOrd);
                                            ordsArray.set(ordsCollected + (long)i, bucketAndOrd.ord);
                                            buckets[i] = bucket;
                                            otherDocCount.increment(ordIdx3, -bucket.getDocCount());
                                        }
                                        topBucketsPreOrd.set(ordIdx3, buckets);
                                        ordsCollected += (long)orderedSize;
                                        continue;
                                    }
                                }
                                assert (ordsCollected == ordsArray.size());
                                this.collectionStrategy.buildSubAggs(topBucketsPreOrd, ordsArray);
                            }
                        }
                        internalAggregationArray = GlobalOrdinalsStringTermsAggregator.this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.collectionStrategy.buildResult(owningBucketOrds.get(ordIdx), otherDocCount.get(ordIdx), (InternalMultiBucketAggregation.InternalBucket[])topBucketsPreOrd.get(ordIdx)));
                        if (topBucketsPreOrd == null) break block37;
                    }
                    catch (Throwable throwable) {
                        if (topBucketsPreOrd != null) {
                            try {
                                topBucketsPreOrd.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    topBucketsPreOrd.close();
                }
                return internalAggregationArray;
            }
        }
    }

    static abstract class CollectionStrategy
    implements Releasable {
        CollectionStrategy() {
        }

        abstract String describe();

        abstract long totalBuckets();

        abstract void globalOrdsReady(SortedSetDocValues var1);

        abstract void collectGlobalOrd(long var1, int var3, long var4, LeafBucketCollector var6) throws IOException;

        abstract long globalOrdToBucketOrd(long var1, long var3);

        abstract InternalAggregation[] buildAggregations(LongArray var1) throws IOException;
    }

    class DenseGlobalOrds<R extends InternalAggregation, B extends InternalMultiBucketAggregation.InternalBucket, TB extends InternalMultiBucketAggregation.InternalBucket>
    extends CollectionStrategy {
        private final boolean excludeDeletedDocs;
        private final ResultStrategy<R, B, TB> collectionStrategy;

        DenseGlobalOrds(ResultStrategy<R, B, TB> collectionStrategy, boolean excludeDeletedDocs) {
            this.excludeDeletedDocs = excludeDeletedDocs;
            this.collectionStrategy = collectionStrategy;
        }

        @Override
        String describe() {
            return "dense";
        }

        @Override
        long totalBuckets() {
            return GlobalOrdinalsStringTermsAggregator.this.valueCount;
        }

        @Override
        void globalOrdsReady(SortedSetDocValues globalOrds) {
            GlobalOrdinalsStringTermsAggregator.this.grow(globalOrds.getValueCount());
        }

        @Override
        void collectGlobalOrd(long owningBucketOrd, int doc, long globalOrd, LeafBucketCollector sub) throws IOException {
            assert (owningBucketOrd == 0L);
            GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(sub, doc, globalOrd);
        }

        @Override
        long globalOrdToBucketOrd(long owningBucketOrd, long globalOrd) {
            assert (owningBucketOrd == 0L);
            return globalOrd;
        }

        private void collect(BucketInfoConsumer consumer) throws IOException {
            if (this.excludeDeletedDocs) {
                this.forEachExcludeDeletedDocs(consumer);
            } else {
                this.forEachAllowDeletedDocs(consumer);
            }
        }

        private void forEachAllowDeletedDocs(BucketInfoConsumer consumer) throws IOException {
            for (long globalOrd = 0L; globalOrd < GlobalOrdinalsStringTermsAggregator.this.valueCount; ++globalOrd) {
                if (!GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                long docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(globalOrd);
                if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L && docCount <= 0L) continue;
                consumer.accept(globalOrd, globalOrd, docCount);
            }
        }

        private void forEachExcludeDeletedDocs(BucketInfoConsumer consumer) throws IOException {
            try (LongHash accepted = new LongHash(20L, GlobalOrdinalsStringTermsAggregator.this.bigArrays());){
                for (LeafReaderContext ctx : GlobalOrdinalsStringTermsAggregator.this.searcher().getTopReaderContext().leaves()) {
                    LeafReader reader = ctx.reader();
                    Bits liveDocs = reader.getLiveDocs();
                    SortedSetDocValues globalOrds = null;
                    for (int docId = 0; docId < reader.maxDoc(); ++docId) {
                        if (liveDocs != null && !liveDocs.get(docId)) continue;
                        SortedSetDocValues sortedSetDocValues = globalOrds = globalOrds == null ? GlobalOrdinalsStringTermsAggregator.this.valuesSource.globalOrdinalsValues(ctx) : globalOrds;
                        if (!globalOrds.advanceExact(docId)) continue;
                        for (int i = 0; i < globalOrds.docValueCount(); ++i) {
                            long globalOrd = globalOrds.nextOrd();
                            if (accepted.find(globalOrd) >= 0L || !GlobalOrdinalsStringTermsAggregator.this.acceptedGlobalOrdinals.test(globalOrd)) continue;
                            long docCount = GlobalOrdinalsStringTermsAggregator.this.bucketDocCount(globalOrd);
                            if (GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount() != 0L && docCount <= 0L) continue;
                            consumer.accept(globalOrd, globalOrd, docCount);
                            accepted.add(globalOrd);
                        }
                    }
                }
            }
        }

        @Override
        public void close() {
        }

        @Override
        InternalAggregation[] buildAggregations(LongArray owningBucketOrds) throws IOException {
            assert (owningBucketOrds.size() == 1L && owningBucketOrds.get(0L) == 0L);
            try (final LongArray otherDocCount = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(1L, true);){
                InternalAggregation[] internalAggregationArray;
                block27: {
                    ObjectArray<B[]> topBucketsPreOrd = this.collectionStrategy.buildTopBucketsPerOrd(1L);
                    try {
                        GlobalOrdLookupFunction lookupGlobalOrd = GlobalOrdinalsStringTermsAggregator.this.valuesSupplier.get()::lookupOrd;
                        int size = (int)Math.min(GlobalOrdinalsStringTermsAggregator.this.valueCount, (long)GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize());
                        try (final ObjectArrayPriorityQueue<BucketAndOrd<TB>> ordered = this.collectionStrategy.buildPriorityQueue(size);){
                            final BucketUpdater<TB> updater = this.collectionStrategy.bucketUpdater(0L, lookupGlobalOrd);
                            this.collect(new BucketInfoConsumer(){
                                BucketAndOrd<TB> spare = null;

                                @Override
                                public void accept(long globalOrd, long bucketOrd, long docCount) throws IOException {
                                    otherDocCount.increment(0L, docCount);
                                    if (docCount >= GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardMinDocCount()) {
                                        if (this.spare == null) {
                                            GlobalOrdinalsStringTermsAggregator.this.checkRealMemoryCBForInternalBucket();
                                            this.spare = new BucketAndOrd(DenseGlobalOrds.this.collectionStrategy.buildEmptyTemporaryBucket());
                                        }
                                        this.spare.ord = bucketOrd;
                                        updater.updateBucket((InternalMultiBucketAggregation.InternalBucket)this.spare.bucket, globalOrd, docCount);
                                        this.spare = ordered.insertWithOverflow(this.spare);
                                    }
                                }
                            });
                            int orderedSize = (int)ordered.size();
                            try (LongArray ordsArray = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(orderedSize);){
                                InternalMultiBucketAggregation.InternalBucket[] buckets = this.collectionStrategy.buildBuckets(orderedSize);
                                for (int i = orderedSize - 1; i >= 0; --i) {
                                    GlobalOrdinalsStringTermsAggregator.this.checkRealMemoryCBForInternalBucket();
                                    BucketAndOrd<TB> bucketAndOrd = ordered.pop();
                                    B bucket = this.collectionStrategy.convertTempBucketToRealBucket((InternalMultiBucketAggregation.InternalBucket)bucketAndOrd.bucket, lookupGlobalOrd);
                                    ordsArray.set(i, bucketAndOrd.ord);
                                    buckets[i] = bucket;
                                    otherDocCount.increment(0L, -bucket.getDocCount());
                                }
                                topBucketsPreOrd.set(0L, buckets);
                                this.collectionStrategy.buildSubAggs(topBucketsPreOrd, ordsArray);
                            }
                        }
                        internalAggregationArray = GlobalOrdinalsStringTermsAggregator.this.buildAggregations(Math.toIntExact(owningBucketOrds.size()), ordIdx -> this.collectionStrategy.buildResult(owningBucketOrds.get(ordIdx), otherDocCount.get(ordIdx), (InternalMultiBucketAggregation.InternalBucket[])topBucketsPreOrd.get(ordIdx)));
                        if (topBucketsPreOrd == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (topBucketsPreOrd != null) {
                            try {
                                topBucketsPreOrd.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    topBucketsPreOrd.close();
                }
                return internalAggregationArray;
            }
        }
    }

    class SignificantTermsResults
    extends ResultStrategy<SignificantStringTerms, SignificantStringTerms.Bucket, SignificantStringTerms.Bucket> {
        private final SignificanceLookup.BackgroundFrequencyForBytes backgroundFrequencies;
        private final long supersetSize;
        private final SignificanceHeuristic significanceHeuristic;
        private LongArray subsetSizes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SignificantTermsResults(SignificanceLookup significanceLookup, SignificanceHeuristic significanceHeuristic, CardinalityUpperBound cardinality) {
            super(GlobalOrdinalsStringTermsAggregator.this);
            this.backgroundFrequencies = significanceLookup.bytesLookup(GlobalOrdinalsStringTermsAggregator.this.bigArrays(), cardinality);
            this.supersetSize = significanceLookup.supersetSize();
            this.significanceHeuristic = significanceHeuristic;
            boolean success = false;
            try {
                this.subsetSizes = GlobalOrdinalsStringTermsAggregator.this.bigArrays().newLongArray(1L, true);
                success = true;
            }
            finally {
                if (!success) {
                    this.close();
                }
            }
        }

        @Override
        String describe() {
            return "significant_terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return new LeafBucketCollectorBase(primary, null){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    super.collect(doc, owningBucketOrd);
                    SignificantTermsResults.this.subsetSizes = GlobalOrdinalsStringTermsAggregator.this.bigArrays().grow(SignificantTermsResults.this.subsetSizes, owningBucketOrd + 1L);
                    SignificantTermsResults.this.subsetSizes.increment(owningBucketOrd, 1L);
                }
            };
        }

        @Override
        ObjectArray<SignificantStringTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return GlobalOrdinalsStringTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        SignificantStringTerms.Bucket[] buildBuckets(int size) {
            return new SignificantStringTerms.Bucket[size];
        }

        @Override
        SignificantStringTerms.Bucket buildEmptyTemporaryBucket() {
            return new SignificantStringTerms.Bucket(new BytesRef(), 0L, 0L, null, GlobalOrdinalsStringTermsAggregator.this.format, 0.0);
        }

        private long subsetSize(long owningBucketOrd) {
            return owningBucketOrd < this.subsetSizes.size() ? this.subsetSizes.get(owningBucketOrd) : 0L;
        }

        @Override
        BucketUpdater<SignificantStringTerms.Bucket> bucketUpdater(long owningBucketOrd, GlobalOrdLookupFunction lookupGlobalOrd) {
            long subsetSize = this.subsetSize(owningBucketOrd);
            return (spare, globalOrd, docCount) -> {
                SignificantTermsResults.oversizedCopy(lookupGlobalOrd.apply(globalOrd), spare.termBytes);
                spare.subsetDf = docCount;
                spare.supersetDf = this.backgroundFrequencies.freq(spare.termBytes);
                spare.updateScore(this.significanceHeuristic, subsetSize, this.supersetSize);
            };
        }

        @Override
        ObjectArrayPriorityQueue<BucketAndOrd<SignificantStringTerms.Bucket>> buildPriorityQueue(int size) {
            return new BucketSignificancePriorityQueue<SignificantStringTerms.Bucket>(size, GlobalOrdinalsStringTermsAggregator.this.bigArrays());
        }

        @Override
        SignificantStringTerms.Bucket convertTempBucketToRealBucket(SignificantStringTerms.Bucket temp, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            return temp;
        }

        @Override
        void buildSubAggs(ObjectArray<SignificantStringTerms.Bucket[]> topBucketsPreOrd, LongArray ordsArray) throws IOException {
            GlobalOrdinalsStringTermsAggregator.this.buildSubAggsForAllBuckets((ObjectArray<B[]>)topBucketsPreOrd, ordsArray, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        SignificantStringTerms buildResult(long owningBucketOrd, long otherDocCount, SignificantStringTerms.Bucket[] topBuckets) {
            return new SignificantStringTerms(GlobalOrdinalsStringTermsAggregator.this.name, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), GlobalOrdinalsStringTermsAggregator.this.metadata(), GlobalOrdinalsStringTermsAggregator.this.format, this.subsetSize(owningBucketOrd), this.supersetSize, this.significanceHeuristic, Arrays.asList(topBuckets));
        }

        @Override
        SignificantStringTerms buildEmptyResult() {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptySignificantTermsAggregation(0L, this.supersetSize, this.significanceHeuristic);
        }

        @Override
        SignificantStringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptySignificantTermsAggregation(this.subsetSizes.get(owningBucketOrdinal), this.supersetSize, this.significanceHeuristic);
        }

        @Override
        public void close() {
            Releasables.close(this.backgroundFrequencies, this.subsetSizes);
        }

        private static void oversizedCopy(BytesRef from, BytesRef to) {
            if (to.bytes.length < from.length) {
                to.bytes = new byte[ArrayUtil.oversize(from.length, 1)];
            }
            to.offset = 0;
            to.length = from.length;
            System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
        }
    }

    class StandardTermsResults
    extends ResultStrategy<StringTerms, StringTerms.Bucket, OrdBucket> {
        StandardTermsResults() {
            super(GlobalOrdinalsStringTermsAggregator.this);
        }

        @Override
        String describe() {
            return "terms";
        }

        @Override
        LeafBucketCollector wrapCollector(LeafBucketCollector primary) {
            return primary;
        }

        @Override
        ObjectArray<StringTerms.Bucket[]> buildTopBucketsPerOrd(long size) {
            return GlobalOrdinalsStringTermsAggregator.this.bigArrays().newObjectArray(size);
        }

        StringTerms.Bucket[] buildBuckets(int size) {
            return new StringTerms.Bucket[size];
        }

        @Override
        OrdBucket buildEmptyTemporaryBucket() {
            return new OrdBucket(GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, GlobalOrdinalsStringTermsAggregator.this.format);
        }

        @Override
        BucketUpdater<OrdBucket> bucketUpdater(long owningBucketOrd, GlobalOrdLookupFunction lookupGlobalOrd) {
            return (spare, globalOrd, docCount) -> {
                spare.globalOrd = globalOrd;
                spare.docCount = docCount;
            };
        }

        @Override
        ObjectArrayPriorityQueue<BucketAndOrd<OrdBucket>> buildPriorityQueue(int size) {
            return new BucketPriorityQueue<OrdBucket>(size, GlobalOrdinalsStringTermsAggregator.this.bigArrays(), GlobalOrdinalsStringTermsAggregator.this.order.partiallyBuiltBucketComparator(GlobalOrdinalsStringTermsAggregator.this));
        }

        @Override
        StringTerms.Bucket convertTempBucketToRealBucket(OrdBucket temp, GlobalOrdLookupFunction lookupGlobalOrd) throws IOException {
            BytesRef term = BytesRef.deepCopyOf(lookupGlobalOrd.apply(temp.globalOrd));
            return new StringTerms.Bucket(term, temp.docCount, null, GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, 0L, GlobalOrdinalsStringTermsAggregator.this.format);
        }

        @Override
        void buildSubAggs(ObjectArray<StringTerms.Bucket[]> topBucketsPreOrd, LongArray ordsArray) throws IOException {
            GlobalOrdinalsStringTermsAggregator.this.buildSubAggsForAllBuckets((ObjectArray<B[]>)topBucketsPreOrd, ordsArray, (b, aggs) -> {
                b.aggregations = aggs;
            });
        }

        StringTerms buildResult(long owningBucketOrd, long otherDocCount, StringTerms.Bucket[] topBuckets) {
            BucketOrder reduceOrder;
            if (!InternalOrder.isKeyOrder(GlobalOrdinalsStringTermsAggregator.this.order)) {
                reduceOrder = InternalOrder.key(true);
                Arrays.sort(topBuckets, reduceOrder.comparator());
            } else {
                reduceOrder = GlobalOrdinalsStringTermsAggregator.this.order;
            }
            return new StringTerms(GlobalOrdinalsStringTermsAggregator.this.name, reduceOrder, GlobalOrdinalsStringTermsAggregator.this.order, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getRequiredSize(), GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getMinDocCount(), GlobalOrdinalsStringTermsAggregator.this.metadata(), GlobalOrdinalsStringTermsAggregator.this.format, GlobalOrdinalsStringTermsAggregator.this.bucketCountThresholds.getShardSize(), GlobalOrdinalsStringTermsAggregator.this.showTermDocCountError, otherDocCount, Arrays.asList(topBuckets), null);
        }

        @Override
        StringTerms buildEmptyResult() {
            return GlobalOrdinalsStringTermsAggregator.this.buildEmptyTermsAggregation();
        }

        @Override
        StringTerms buildNoValuesResult(long owningBucketOrdinal) {
            return this.buildEmptyResult();
        }

        @Override
        public void close() {
        }
    }

    static interface BucketUpdater<TB extends InternalMultiBucketAggregation.InternalBucket> {
        public void updateBucket(TB var1, long var2, long var4) throws IOException;
    }

    static interface BucketInfoConsumer {
        public void accept(long var1, long var3, long var5) throws IOException;
    }

    static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private LongUnaryOperator mapping;
        private LongArray segmentDocCounts;
        protected int segmentsWithoutValues = 0;

        LowCardinality(String name, AggregatorFactories factories, Function<GlobalOrdinalsStringTermsAggregator, ResultStrategy<?, ?, ?>> resultStrategy, ValuesSource.Bytes.WithOrdinals valuesSource, CheckedSupplier<SortedSetDocValues, IOException> valuesSupplier, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext context, Aggregator parent, boolean remapGlobalOrds, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, Map<String, Object> metadata, boolean excludeDeletedDocs) throws IOException {
            super(name, factories, resultStrategy, valuesSource, valuesSupplier, order, format, bucketCountThresholds, ALWAYS_TRUE, context, parent, remapGlobalOrds, collectionMode, showTermDocCountError, CardinalityUpperBound.ONE, metadata, excludeDeletedDocs);
            assert (factories == null || factories.countAggregators() == 0);
            this.segmentDocCounts = context.bigArrays().newLongArray(1L, true);
        }

        @Override
        public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
            }
            final SortedSetDocValues segmentOrds = this.valuesSource.ordinalsValues(aggCtx.getLeafReaderContext());
            this.mapping = this.valuesSource.globalOrdinalsMapping(aggCtx.getLeafReaderContext());
            if (segmentOrds.getValueCount() == 0L) {
                ++this.segmentsWithoutValues;
                return LeafBucketCollector.NO_OP_COLLECTOR;
            }
            this.segmentDocCounts = this.bigArrays().grow(this.segmentDocCounts, 1L + segmentOrds.getValueCount());
            assert (sub.isNoop());
            final SortedDocValues singleValues = DocValues.unwrapSingleton(segmentOrds);
            if (singleValues != null) {
                ++this.segmentsWithSingleValuedOrds;
                return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, segmentOrds){

                    @Override
                    public void collect(int doc, long owningBucketOrd) throws IOException {
                        assert (owningBucketOrd == 0L);
                        if (!singleValues.advanceExact(doc)) {
                            return;
                        }
                        int ord = singleValues.ordValue();
                        int docCount = docCountProvider.getDocCount(doc);
                        segmentDocCounts.increment(ord + 1, docCount);
                    }
                });
            }
            ++this.segmentsWithMultiValuedOrds;
            return this.resultStrategy.wrapCollector(new LeafBucketCollectorBase(sub, segmentOrds){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (!segmentOrds.advanceExact(doc)) {
                        return;
                    }
                    for (int i = 0; i < segmentOrds.docValueCount(); ++i) {
                        long segmentOrd = segmentOrds.nextOrd();
                        int docCount = docCountProvider.getDocCount(doc);
                        segmentDocCounts.increment(segmentOrd + 1L, docCount);
                    }
                }
            });
        }

        @Override
        protected void doPostCollection() throws IOException {
            if (this.mapping != null) {
                this.mapSegmentCountsToGlobalCounts(this.mapping);
                this.mapping = null;
            }
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("segments_without_values", this.segmentsWithoutValues);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.resultStrategy, this.segmentDocCounts, this.collectionStrategy);
        }

        private void mapSegmentCountsToGlobalCounts(LongUnaryOperator mapping) throws IOException {
            for (long i = 1L; i < this.segmentDocCounts.size(); ++i) {
                long inc = this.segmentDocCounts.getAndSet(i, 0L);
                if (inc == 0L) continue;
                long ord = i - 1L;
                long globalOrd = mapping.applyAsLong(ord);
                this.incrementBucketDocCount(this.collectionStrategy.globalOrdToBucketOrd(0L, globalOrd), inc);
            }
        }
    }

    static class OrdBucket
    extends InternalTerms.Bucket<OrdBucket> {
        long globalOrd;

        OrdBucket(boolean showDocCountError, DocValueFormat format) {
            super(0L, null, showDocCountError, 0L, format);
        }

        @Override
        public int compareKey(OrdBucket other) {
            return Long.compare(this.globalOrd, other.globalOrd);
        }

        @Override
        public String getKeyAsString() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void writeTermTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected final XContentBuilder keyToXContent(XContentBuilder builder) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface GlobalOrdLookupFunction {
        public BytesRef apply(long var1) throws IOException;
    }
}

