/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler.random;

import java.util.Arrays;
import java.util.function.IntSupplier;

public class FastGeometric {
    private static final float[] LOOKUP_TABLE_FOR_FAST_LOG_2;
    private static final int BITS = 13;
    private static final int SHIFT = 10;
    private static final float[] BIASES;
    private static final int[] PERMITTED_BITS_PER_SAMPLE;
    private static final float[] PERMITTED_SAMPLE_RANGES;
    private final IntSupplier rng;
    private int currentSample;
    private final int[] currentSamples;
    private final float norm;
    private final float rngRange;
    private final float log2RngRange;
    private final float bias;
    private final int mask;
    private final int bitsPerSample;
    private final int needToGenerate;

    private static float fastLog2(float x) {
        assert (x >= 0.0f) : "Error generating fast log as provided value was less than 0";
        int xBits = Float.floatToIntBits(x);
        int log2x = (xBits >>> 23 & 0xFF) - 127;
        int xMantissa = xBits & 0x7FFFFF;
        return LOOKUP_TABLE_FOR_FAST_LOG_2[xMantissa >>> 10] + (float)log2x;
    }

    public FastGeometric(IntSupplier randomGen, double p) {
        if (p <= 0.0 || p >= 1.0) {
            throw new IllegalArgumentException("[p] must be between 0.0 and 1.0, exclusive, was [" + p + "]");
        }
        this.rng = randomGen;
        int bits = (int)(1.5 * Math.log(Math.log(0.01) / Math.log(1.0 - p) - 1.0) / Math.log(2.0));
        int pos = Arrays.binarySearch(PERMITTED_BITS_PER_SAMPLE, bits);
        pos = pos < 0 ? Math.min(-pos - 1, PERMITTED_BITS_PER_SAMPLE.length - 1) : pos;
        this.bitsPerSample = PERMITTED_BITS_PER_SAMPLE[pos];
        this.needToGenerate = 32 / this.bitsPerSample;
        this.mask = Integer.MAX_VALUE >>> 32 - this.bitsPerSample - 1;
        this.currentSample = this.needToGenerate - 1;
        this.currentSamples = new int[this.needToGenerate];
        this.norm = (float)(Math.log(2.0) / Math.log(1.0 - p));
        this.rngRange = PERMITTED_SAMPLE_RANGES[pos];
        this.log2RngRange = FastGeometric.fastLog2(PERMITTED_SAMPLE_RANGES[pos]);
        this.bias = BIASES[pos];
    }

    public int next() {
        ++this.currentSample;
        if (this.currentSample == this.needToGenerate) {
            this.generate();
            this.currentSample = 0;
        }
        return this.currentSamples[this.currentSample] + 1;
    }

    private void generate() {
        int rn = this.rng.getAsInt();
        if (this.needToGenerate == 1) {
            float u = 0.5f * this.rngRange + (float)rn + 0.5f;
            this.currentSamples[0] = (int)(this.norm * (FastGeometric.fastLog2(u) - this.log2RngRange));
        } else {
            int i = 0;
            for (int shift = this.bitsPerSample; shift <= 32; shift += this.bitsPerSample) {
                float u = (float)(rn >>> shift & this.mask) + 0.5f;
                this.currentSamples[i] = (int)(this.norm * (FastGeometric.fastLog2(u) - this.log2RngRange + this.bias));
                ++i;
            }
        }
    }

    static {
        BIASES = new float[]{-0.0019255826f, 7.2481555E-5f, 7.3475075E-9f};
        PERMITTED_BITS_PER_SAMPLE = new int[]{8, 16, 32};
        PERMITTED_SAMPLE_RANGES = new float[]{256.0f, 65536.0f, 4.2949673E9f};
        LOOKUP_TABLE_FOR_FAST_LOG_2 = new float[16384];
        int dx = 1024;
        int x = 1065353216 + dx / 2;
        float log2 = (float)Math.log(2.0);
        for (int i = 0; i < LOOKUP_TABLE_FOR_FAST_LOG_2.length; ++i) {
            FastGeometric.LOOKUP_TABLE_FOR_FAST_LOG_2[i] = (float)Math.log(Float.intBitsToFloat(x)) / log2;
            x += dx;
        }
    }
}

