/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.io.stream.BytesStream;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Streams;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public interface ChunkedRestResponseBodyPart {
    public static final Logger logger = LogManager.getLogger(ChunkedRestResponseBodyPart.class);

    public boolean isPartComplete();

    public boolean isLastPart();

    public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> var1);

    public ReleasableBytesReference encodeChunk(int var1, Recycler<BytesRef> var2) throws IOException;

    public String getResponseContentTypeString();

    public static ChunkedRestResponseBodyPart fromXContent(final ChunkedToXContent chunkedToXContent, final ToXContent.Params params, final RestChannel channel) throws IOException {
        return new ChunkedRestResponseBodyPart(){
            private final OutputStream out = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    target.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    target.write(b, off, len);
                }
            };
            private final XContentBuilder builder = channel.newBuilder(channel.request().getXContentType(), null, true, Streams.noCloseStream(this.out));
            private final Iterator<? extends ToXContent> serialization = chunkedToXContent.toXContentChunked(this.builder.getRestApiVersion(), params);
            private BytesStream target;

            @Override
            public boolean isPartComplete() {
                return !this.serialization.hasNext();
            }

            @Override
            public boolean isLastPart() {
                return true;
            }

            @Override
            public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
                assert (false) : "no continuations";
                listener.onFailure(new IllegalStateException("no continuations available"));
            }

            @Override
            public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
                try {
                    RecyclerBytesStreamOutput chunkStream = new RecyclerBytesStreamOutput(recycler);
                    assert (this.target == null);
                    this.target = chunkStream;
                    while (this.serialization.hasNext()) {
                        this.serialization.next().toXContent(this.builder, params);
                        if (chunkStream.size() < sizeHint) continue;
                    }
                    if (!this.serialization.hasNext()) {
                        this.builder.close();
                    }
                    ReleasableBytesReference result = new ReleasableBytesReference(chunkStream.bytes(), () -> Releasables.closeExpectNoException((Releasable)chunkStream));
                    this.target = null;
                    ReleasableBytesReference releasableBytesReference = result;
                    return releasableBytesReference;
                }
                catch (Exception e) {
                    logger.error("failure encoding chunk", (Throwable)e);
                    throw e;
                }
                finally {
                    if (this.target != null) {
                        assert (false) : "failure encoding chunk";
                        IOUtils.closeWhileHandlingException((Closeable)this.target);
                        this.target = null;
                    }
                }
            }

            @Override
            public String getResponseContentTypeString() {
                return this.builder.getResponseContentTypeString();
            }
        };
    }

    public static ChunkedRestResponseBodyPart fromTextChunks(final String contentType, final Iterator<CheckedConsumer<Writer, IOException>> chunkIterator) {
        return new ChunkedRestResponseBodyPart(){
            private RecyclerBytesStreamOutput currentOutput;
            private final Writer writer = new OutputStreamWriter(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    assert (currentOutput != null);
                    currentOutput.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    assert (currentOutput != null);
                    currentOutput.write(b, off, len);
                }

                @Override
                public void flush() {
                    assert (currentOutput != null);
                    currentOutput.flush();
                }

                @Override
                public void close() {
                    assert (currentOutput != null);
                    currentOutput.flush();
                }
            }, StandardCharsets.UTF_8);

            @Override
            public boolean isPartComplete() {
                return !chunkIterator.hasNext();
            }

            @Override
            public boolean isLastPart() {
                return true;
            }

            @Override
            public void getNextPart(ActionListener<ChunkedRestResponseBodyPart> listener) {
                assert (false) : "no continuations";
                listener.onFailure(new IllegalStateException("no continuations available"));
            }

            @Override
            public ReleasableBytesReference encodeChunk(int sizeHint, Recycler<BytesRef> recycler) throws IOException {
                try {
                    assert (this.currentOutput == null);
                    this.currentOutput = new RecyclerBytesStreamOutput(recycler);
                    while (chunkIterator.hasNext() && this.currentOutput.size() < sizeHint) {
                        ((CheckedConsumer)chunkIterator.next()).accept(this.writer);
                    }
                    if (chunkIterator.hasNext()) {
                        this.writer.flush();
                    } else {
                        this.writer.close();
                    }
                    RecyclerBytesStreamOutput chunkOutput = this.currentOutput;
                    ReleasableBytesReference result = new ReleasableBytesReference(chunkOutput.bytes(), () -> Releasables.closeExpectNoException((Releasable)chunkOutput));
                    this.currentOutput = null;
                    ReleasableBytesReference releasableBytesReference = result;
                    return releasableBytesReference;
                }
                catch (Exception e) {
                    logger.error("failure encoding text chunk", (Throwable)e);
                    throw e;
                }
                finally {
                    if (this.currentOutput != null) {
                        assert (false) : "failure encoding text chunk";
                        Releasables.closeExpectNoException((Releasable)this.currentOutput);
                        this.currentOutput = null;
                    }
                }
            }

            @Override
            public String getResponseContentTypeString() {
                return contentType;
            }
        };
    }
}

