/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.protocol.xpack.XPackInfoRequest;
import org.elasticsearch.protocol.xpack.license.LicenseStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class XPackInfoResponse
extends ActionResponse
implements ToXContentObject {
    public static final long BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS = Long.MAX_VALUE - TimeUnit.HOURS.toMillis(8760L);
    @Nullable
    private final BuildInfo buildInfo;
    @Nullable
    private final LicenseInfo licenseInfo;
    @Nullable
    private final FeatureSetsInfo featureSetsInfo;

    public XPackInfoResponse(StreamInput in) throws IOException {
        super(in);
        this.buildInfo = in.readOptionalWriteable(BuildInfo::new);
        this.licenseInfo = in.readOptionalWriteable(LicenseInfo::new);
        this.featureSetsInfo = in.readOptionalWriteable(FeatureSetsInfo::new);
    }

    public XPackInfoResponse(@Nullable BuildInfo buildInfo, @Nullable LicenseInfo licenseInfo, @Nullable FeatureSetsInfo featureSetsInfo) {
        this.buildInfo = buildInfo;
        this.licenseInfo = licenseInfo;
        this.featureSetsInfo = featureSetsInfo;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public LicenseInfo getLicenseInfo() {
        return this.licenseInfo;
    }

    public FeatureSetsInfo getFeatureSetsInfo() {
        return this.featureSetsInfo;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.buildInfo);
        out.writeOptionalWriteable(this.licenseInfo);
        out.writeOptionalWriteable(this.featureSetsInfo);
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this == other) {
            return true;
        }
        XPackInfoResponse rhs = (XPackInfoResponse)other;
        return Objects.equals(this.buildInfo, rhs.buildInfo) && Objects.equals(this.licenseInfo, rhs.licenseInfo) && Objects.equals(this.featureSetsInfo, rhs.featureSetsInfo);
    }

    public int hashCode() {
        return Objects.hash(this.buildInfo, this.licenseInfo, this.featureSetsInfo);
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.buildInfo != null) {
            builder.field("build", this.buildInfo, params);
        }
        EnumSet<XPackInfoRequest.Category> categories = XPackInfoRequest.Category.toSet(Strings.splitStringByCommaToArray(params.param("categories", "_all")));
        if (this.licenseInfo != null) {
            builder.field("license", this.licenseInfo, params);
        } else if (categories.contains((Object)XPackInfoRequest.Category.LICENSE)) {
            builder.nullField("license");
        }
        if (this.featureSetsInfo != null) {
            builder.field("features", this.featureSetsInfo, params);
        }
        if (params.paramAsBoolean("human", true)) {
            builder.field("tagline", "You know, for X");
        }
        return builder.endObject();
    }

    public static class BuildInfo
    implements ToXContentObject,
    Writeable {
        private final String hash;
        private final String timestamp;

        public BuildInfo(String hash, String timestamp) {
            this.hash = hash;
            this.timestamp = timestamp;
        }

        public BuildInfo(StreamInput input) throws IOException {
            this(input.readString(), input.readString());
        }

        @Override
        public void writeTo(StreamOutput output) throws IOException {
            output.writeString(this.hash);
            output.writeString(this.timestamp);
        }

        public String getHash() {
            return this.hash;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            BuildInfo rhs = (BuildInfo)other;
            return Objects.equals(this.hash, rhs.hash) && Objects.equals(this.timestamp, rhs.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.hash, this.timestamp);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("hash", this.hash).field("date", this.timestamp).endObject();
        }
    }

    public static class LicenseInfo
    implements ToXContentObject,
    Writeable {
        private final String uid;
        private final String type;
        private final String mode;
        private final LicenseStatus status;
        private final long expiryDate;

        public LicenseInfo(String uid, String type, String mode, LicenseStatus status, long expiryDate) {
            this.uid = uid;
            this.type = type;
            this.mode = mode;
            this.status = status;
            this.expiryDate = expiryDate;
        }

        public LicenseInfo(StreamInput in) throws IOException {
            this(in.readString(), in.readString(), in.readString(), LicenseStatus.readFrom(in), in.readLong());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.uid);
            out.writeString(this.type);
            out.writeString(this.mode);
            this.status.writeTo(out);
            out.writeLong(this.expiryDate);
        }

        public String getUid() {
            return this.uid;
        }

        public String getType() {
            return this.type;
        }

        public String getMode() {
            return this.mode;
        }

        public long getExpiryDate() {
            return this.expiryDate;
        }

        public LicenseStatus getStatus() {
            return this.status;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            LicenseInfo rhs = (LicenseInfo)other;
            return Objects.equals(this.uid, rhs.uid) && Objects.equals(this.type, rhs.type) && Objects.equals(this.mode, rhs.mode) && Objects.equals(this.status, rhs.status) && this.expiryDate == rhs.expiryDate;
        }

        public int hashCode() {
            return Objects.hash(this.uid, this.type, this.mode, this.status, this.expiryDate);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("uid", this.uid);
            builder.field("type", this.type);
            builder.field("mode", this.mode);
            builder.field("status", this.status.label());
            if (this.expiryDate != BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS) {
                builder.timestampFieldsFromUnixEpochMillis("expiry_date_in_millis", "expiry_date", this.expiryDate);
            }
            return builder.endObject();
        }
    }

    public static class FeatureSetsInfo
    implements ToXContentObject,
    Writeable {
        private final Map<String, FeatureSet> featureSets;

        public FeatureSetsInfo(Set<FeatureSet> featureSets) {
            Map<String, FeatureSet> map = Maps.newMapWithExpectedSize(featureSets.size());
            for (FeatureSet featureSet : featureSets) {
                map.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(map);
        }

        public FeatureSetsInfo(StreamInput in) throws IOException {
            int size = in.readVInt();
            Map<String, FeatureSet> featureSets = Maps.newMapWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                FeatureSet featureSet = new FeatureSet(in);
                featureSets.put(featureSet.name, featureSet);
            }
            this.featureSets = Collections.unmodifiableMap(featureSets);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.featureSets.size());
            for (FeatureSet featureSet : this.featureSets.values()) {
                featureSet.writeTo(out);
            }
        }

        public Map<String, FeatureSet> getFeatureSets() {
            return this.featureSets;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            if (this == other) {
                return true;
            }
            FeatureSetsInfo rhs = (FeatureSetsInfo)other;
            return Objects.equals(this.featureSets, rhs.featureSets);
        }

        public int hashCode() {
            return Objects.hash(this.featureSets);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            List names = new ArrayList<String>(this.featureSets.keySet()).stream().sorted().toList();
            for (String name : names) {
                builder.field(name, this.featureSets.get(name), params);
            }
            return builder.endObject();
        }

        public static class FeatureSet
        implements ToXContentObject,
        Writeable {
            private final String name;
            private final boolean available;
            private final boolean enabled;

            public FeatureSet(String name, boolean available, boolean enabled) {
                this.name = name;
                this.available = available;
                this.enabled = enabled;
            }

            public FeatureSet(StreamInput in) throws IOException {
                this(in.readString(), in.readBoolean(), in.readBoolean());
                if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                    in.readGenericMap();
                }
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.name);
                out.writeBoolean(this.available);
                out.writeBoolean(this.enabled);
                if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                    out.writeGenericMap(Collections.emptyMap());
                }
            }

            public String name() {
                return this.name;
            }

            public boolean available() {
                return this.available;
            }

            public boolean enabled() {
                return this.enabled;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                if (this == other) {
                    return true;
                }
                FeatureSet rhs = (FeatureSet)other;
                return Objects.equals(this.name, rhs.name) && this.available == rhs.available && this.enabled == rhs.enabled;
            }

            public int hashCode() {
                return Objects.hash(this.name, this.available, this.enabled);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("available", this.available);
                builder.field("enabled", this.enabled);
                return builder.endObject();
            }
        }
    }
}

