/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.useragent;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.ingest.useragent.UserAgentParser;

public class UserAgentProcessor
extends AbstractProcessor {
    public static final String TYPE = "user_agent";
    private final String field;
    private final String targetField;
    private final Set<Property> properties;
    private final UserAgentParser parser;
    private final boolean extractDeviceType;
    private final boolean ignoreMissing;

    public UserAgentProcessor(String tag, String description, String field, String targetField, UserAgentParser parser, Set<Property> properties, boolean extractDeviceType, boolean ignoreMissing) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.parser = parser;
        this.properties = properties;
        this.extractDeviceType = extractDeviceType;
        this.ignoreMissing = ignoreMissing;
    }

    boolean isExtractDeviceType() {
        return this.extractDeviceType;
    }

    boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    public IngestDocument execute(IngestDocument ingestDocument) {
        String userAgent = ingestDocument.getFieldValue(this.field, String.class, this.ignoreMissing);
        if (userAgent == null && this.ignoreMissing) {
            return ingestDocument;
        }
        if (userAgent == null) {
            throw new IllegalArgumentException("field [" + this.field + "] is null, cannot parse user-agent.");
        }
        UserAgentParser.Details uaClient = this.parser.parse(userAgent, this.extractDeviceType);
        HashMap<String, Object> uaDetails = new HashMap<String, Object>();
        block7: for (Property property : this.properties) {
            switch (property.ordinal()) {
                case 3: {
                    uaDetails.put("original", userAgent);
                    break;
                }
                case 0: {
                    if (uaClient.userAgent() != null && uaClient.userAgent().name() != null) {
                        uaDetails.put("name", uaClient.userAgent().name());
                        break;
                    }
                    uaDetails.put("name", "Other");
                    break;
                }
                case 4: {
                    if (uaClient.userAgent() == null || uaClient.userAgent().major() == null) break;
                    uaDetails.put("version", UserAgentProcessor.versionToString(uaClient.userAgent()));
                    break;
                }
                case 1: {
                    if (uaClient.operatingSystem() == null) break;
                    Map<String, Object> osDetails = Maps.newMapWithExpectedSize(3);
                    if (uaClient.operatingSystem().name() == null) continue block7;
                    osDetails.put("name", uaClient.operatingSystem().name());
                    if (uaClient.operatingSystem().major() != null) {
                        String version = UserAgentProcessor.versionToString(uaClient.operatingSystem());
                        osDetails.put("version", version);
                        osDetails.put("full", uaClient.operatingSystem().name() + " " + version);
                    }
                    uaDetails.put("os", osDetails);
                    break;
                }
                case 2: {
                    Map<String, String> deviceDetails = Maps.newMapWithExpectedSize(1);
                    if (uaClient.device() != null && uaClient.device().name() != null) {
                        deviceDetails.put("name", uaClient.device().name());
                        if (this.extractDeviceType) {
                            deviceDetails.put("type", uaClient.deviceType());
                        }
                    } else {
                        deviceDetails.put("name", "Other");
                        if (this.extractDeviceType) {
                            if (uaClient.deviceType() != null) {
                                deviceDetails.put("type", uaClient.deviceType());
                            } else {
                                deviceDetails.put("type", "Other");
                            }
                        }
                    }
                    uaDetails.put("device", deviceDetails);
                }
            }
        }
        ingestDocument.setFieldValue(this.targetField, uaDetails);
        return ingestDocument;
    }

    private static String versionToString(UserAgentParser.VersionedName version) {
        StringBuilder versionString = new StringBuilder();
        if (Strings.hasLength(version.major())) {
            versionString.append(version.major());
            if (Strings.hasLength(version.minor())) {
                versionString.append(".").append(version.minor());
                if (Strings.hasLength(version.patch())) {
                    versionString.append(".").append(version.patch());
                    if (Strings.hasLength(version.build())) {
                        versionString.append(".").append(version.build());
                    }
                }
            }
        }
        return versionString.toString();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    String getField() {
        return this.field;
    }

    String getTargetField() {
        return this.targetField;
    }

    Set<Property> getProperties() {
        return this.properties;
    }

    UserAgentParser getUaParser() {
        return this.parser;
    }

    static boolean maybeUpgradeConfig(Map<String, Object> config) {
        return config.remove("ecs") != null;
    }

    static enum Property {
        NAME,
        OS,
        DEVICE,
        ORIGINAL,
        VERSION;


        public static Property parseProperty(String propertyName) {
            try {
                return Property.valueOf(propertyName.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("illegal property value [" + propertyName + "]. valid values are " + Arrays.toString(EnumSet.allOf(Property.class).toArray()));
            }
        }
    }

    public static final class Factory
    implements Processor.Factory {
        private final Map<String, UserAgentParser> userAgentParsers;

        public Factory(Map<String, UserAgentParser> userAgentParsers) {
            this.userAgentParsers = userAgentParsers;
        }

        @Override
        public UserAgentProcessor create(Map<String, Processor.Factory> factories, String processorTag, String description, Map<String, Object> config) {
            EnumSet<Property> properties;
            String field = ConfigurationUtils.readStringProperty(UserAgentProcessor.TYPE, processorTag, config, "field");
            String targetField = ConfigurationUtils.readStringProperty(UserAgentProcessor.TYPE, processorTag, config, "target_field", UserAgentProcessor.TYPE);
            String regexFilename = ConfigurationUtils.readStringProperty(UserAgentProcessor.TYPE, processorTag, config, "regex_file", "_default_");
            List<String> propertyNames = ConfigurationUtils.readOptionalList(UserAgentProcessor.TYPE, processorTag, config, "properties");
            boolean extractDeviceType = ConfigurationUtils.readBooleanProperty(UserAgentProcessor.TYPE, processorTag, config, "extract_device_type", false);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty(UserAgentProcessor.TYPE, processorTag, config, "ignore_missing", false);
            UserAgentParser parser = this.userAgentParsers.get(regexFilename);
            if (parser == null) {
                throw ConfigurationUtils.newConfigurationException(UserAgentProcessor.TYPE, processorTag, "regex_file", "regex file [" + regexFilename + "] doesn't exist (has to exist at node startup)");
            }
            if (propertyNames != null) {
                properties = EnumSet.noneOf(Property.class);
                for (String fieldName : propertyNames) {
                    try {
                        properties.add(Property.parseProperty(fieldName));
                    }
                    catch (IllegalArgumentException e) {
                        throw ConfigurationUtils.newConfigurationException(UserAgentProcessor.TYPE, processorTag, "properties", e.getMessage());
                    }
                }
            } else {
                properties = EnumSet.allOf(Property.class);
            }
            return new UserAgentProcessor(processorTag, description, field, targetField, parser, properties, extractDeviceType, ignoreMissing);
        }
    }
}

