/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.ingest.EnterpriseGeoIpTask;
import org.elasticsearch.ingest.geoip.EnterpriseGeoIpDownloader;
import org.elasticsearch.ingest.geoip.EnterpriseGeoIpTaskState;
import org.elasticsearch.ingest.geoip.GeoIpDownloaderTaskExecutor;
import org.elasticsearch.ingest.geoip.HttpClient;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;

public class EnterpriseGeoIpDownloaderTaskExecutor
extends PersistentTasksExecutor<EnterpriseGeoIpTask.EnterpriseGeoIpTaskParams>
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(EnterpriseGeoIpDownloader.class);
    static final String MAXMIND_SETTINGS_PREFIX = "ingest.geoip.downloader.maxmind.";
    static final String IPINFO_SETTINGS_PREFIX = "ingest.ip_location.downloader.ipinfo.";
    public static final Setting<SecureString> MAXMIND_LICENSE_KEY_SETTING = SecureSetting.secureString("ingest.geoip.downloader.maxmind.license_key", null, new Setting.Property[0]);
    public static final Setting<SecureString> IPINFO_TOKEN_SETTING = SecureSetting.secureString("ingest.ip_location.downloader.ipinfo.token", null, new Setting.Property[0]);
    private final Client client;
    private final HttpClient httpClient;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private final Settings settings;
    private volatile TimeValue pollInterval;
    private final AtomicReference<EnterpriseGeoIpDownloader> currentTask = new AtomicReference();
    private volatile SecureSettings cachedSecureSettings;

    EnterpriseGeoIpDownloaderTaskExecutor(Client client, HttpClient httpClient, ClusterService clusterService, ThreadPool threadPool) {
        super("enterprise-geoip-downloader", threadPool.generic());
        this.client = new OriginSettingClient(client, "ingest");
        this.httpClient = httpClient;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.settings = clusterService.getSettings();
        this.pollInterval = GeoIpDownloaderTaskExecutor.POLL_INTERVAL_SETTING.get(this.settings);
        this.reload(clusterService.getSettings());
    }

    public void init() {
        this.clusterService.addListener(this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(GeoIpDownloaderTaskExecutor.POLL_INTERVAL_SETTING, this::setPollInterval);
    }

    private void setPollInterval(TimeValue pollInterval) {
        if (!Objects.equals(this.pollInterval, pollInterval)) {
            this.pollInterval = pollInterval;
            EnterpriseGeoIpDownloader currentDownloader = this.getCurrentTask();
            if (currentDownloader != null) {
                currentDownloader.requestReschedule();
            }
        }
    }

    private char[] getSecureToken(String type) {
        char[] token = null;
        if (type.equals("maxmind")) {
            if (this.cachedSecureSettings.getSettingNames().contains(MAXMIND_LICENSE_KEY_SETTING.getKey())) {
                token = this.cachedSecureSettings.getString(MAXMIND_LICENSE_KEY_SETTING.getKey()).getChars();
            }
        } else if (type.equals("ipinfo") && this.cachedSecureSettings.getSettingNames().contains(IPINFO_TOKEN_SETTING.getKey())) {
            token = this.cachedSecureSettings.getString(IPINFO_TOKEN_SETTING.getKey()).getChars();
        }
        return token;
    }

    protected EnterpriseGeoIpDownloader createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<EnterpriseGeoIpTask.EnterpriseGeoIpTaskParams> taskInProgress, Map<String, String> headers) {
        return new EnterpriseGeoIpDownloader(this.client, this.httpClient, this.clusterService, this.threadPool, id, type, action, this.getDescription(taskInProgress), parentTaskId, headers, () -> this.pollInterval, this::getSecureToken);
    }

    @Override
    protected void nodeOperation(AllocatedPersistentTask task, EnterpriseGeoIpTask.EnterpriseGeoIpTaskParams params, PersistentTaskState state) {
        EnterpriseGeoIpDownloader downloader = (EnterpriseGeoIpDownloader)task;
        EnterpriseGeoIpTaskState geoIpTaskState = state == null ? EnterpriseGeoIpTaskState.EMPTY : (EnterpriseGeoIpTaskState)state;
        downloader.setState(geoIpTaskState);
        this.currentTask.set(downloader);
        if (GeoIpDownloaderTaskExecutor.ENABLED_SETTING.get(this.clusterService.state().metadata().settings(), this.settings).booleanValue()) {
            downloader.runDownloader();
        }
    }

    public EnterpriseGeoIpDownloader getCurrentTask() {
        return this.currentTask.get();
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        EnterpriseGeoIpDownloader currentDownloader = this.getCurrentTask();
        if (currentDownloader != null) {
            boolean hasGeoIpMetadataChanges;
            boolean bl = hasGeoIpMetadataChanges = event.metadataChanged() && event.changedCustomMetadataSet().contains("ingest_geoip");
            if (hasGeoIpMetadataChanges) {
                currentDownloader.requestReschedule();
            }
        }
    }

    public synchronized void reload(Settings settings) {
        try {
            this.cachedSecureSettings = EnterpriseGeoIpDownloaderTaskExecutor.extractSecureSettings(settings, List.of(MAXMIND_LICENSE_KEY_SETTING, IPINFO_TOKEN_SETTING));
        }
        catch (GeneralSecurityException e) {
            throw new ElasticsearchException("Exception while reloading enterprise geoip download task executor", (Throwable)e, new Object[0]);
        }
    }

    private static SecureSettings extractSecureSettings(Settings source, List<Setting<?>> securePluginSettings) throws GeneralSecurityException {
        SecureSettings sourceSecureSettings = Settings.builder().put(source, true).getSecureSettings();
        final HashMap<String, SecureSettingValue> innerMap = new HashMap<String, SecureSettingValue>();
        if (sourceSecureSettings != null && securePluginSettings != null) {
            for (String settingKey : sourceSecureSettings.getSettingNames()) {
                for (Setting<?> secureSetting : securePluginSettings) {
                    if (!secureSetting.match(settingKey)) continue;
                    innerMap.put(settingKey, new SecureSettingValue(sourceSecureSettings.getString(settingKey), sourceSecureSettings.getSHA256Digest(settingKey)));
                }
            }
        }
        return new SecureSettings(){

            @Override
            public boolean isLoaded() {
                return true;
            }

            @Override
            public SecureString getString(String setting) {
                return ((SecureSettingValue)innerMap.get(setting)).value();
            }

            @Override
            public Set<String> getSettingNames() {
                return innerMap.keySet();
            }

            @Override
            public InputStream getFile(String setting) {
                throw new UnsupportedOperationException("A cached SecureSetting cannot be a file");
            }

            @Override
            public byte[] getSHA256Digest(String setting) {
                return ((SecureSettingValue)innerMap.get(setting)).sha256Digest();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                throw new UnsupportedOperationException("A cached SecureSetting cannot be serialized");
            }
        };
    }

    private record SecureSettingValue(SecureString value, byte[] sha256Digest) {
    }
}

