/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.xcontent.ContextParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;

public final class PipelineConfiguration
implements SimpleDiffable<PipelineConfiguration>,
ToXContentObject {
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, Builder::new);
    private final String id;
    private final Map<String, Object> config;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> PARSER.apply(parser, null).build();
    }

    public PipelineConfiguration(String id, Map<String, Object> config) {
        this.id = Objects.requireNonNull(id);
        this.config = PipelineConfiguration.deepCopy(config, true);
    }

    public PipelineConfiguration(String id, BytesReference config, XContentType xContentType) {
        this(id, XContentHelper.convertToMap(config, true, xContentType).v2());
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfig() {
        return this.getConfig(true);
    }

    public Map<String, Object> getConfig(boolean unmodifiable) {
        if (unmodifiable) {
            return this.config;
        }
        return PipelineConfiguration.deepCopy(this.config, false);
    }

    private static <T> T deepCopy(T value, boolean unmodifiable) {
        return (T)PipelineConfiguration.innerDeepCopy(value, unmodifiable);
    }

    private static Object innerDeepCopy(Object value, boolean unmodifiable) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            LinkedHashMap<Object, Object> copy = Maps.newLinkedHashMapWithExpectedSize(mapValue.size());
            for (Map.Entry entry : mapValue.entrySet()) {
                copy.put(PipelineConfiguration.innerDeepCopy(entry.getKey(), unmodifiable), PipelineConfiguration.innerDeepCopy(entry.getValue(), unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableMap(copy) : copy;
        }
        if (value instanceof List) {
            List listValue = (List)value;
            ArrayList<Object> copy = new ArrayList<Object>(listValue.size());
            for (Object itemValue : listValue) {
                copy.add(PipelineConfiguration.innerDeepCopy(itemValue, unmodifiable));
            }
            return unmodifiable ? Collections.unmodifiableList(copy) : copy;
        }
        assert (value == null || value instanceof String || value instanceof Number || value instanceof Boolean) : "unexpected value type [" + String.valueOf(value.getClass()) + "]";
        return value;
    }

    public Integer getVersion() {
        Object o = this.config.get("version");
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.intValue();
        }
        throw new IllegalStateException("unexpected version type [" + o.getClass().getName() + "]");
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.config);
        builder.endObject();
        return builder;
    }

    public static PipelineConfiguration readFrom(StreamInput in) throws IOException {
        Map<String, Object> config;
        String id = in.readString();
        if (in.getTransportVersion().onOrAfter(TransportVersions.INGEST_PIPELINE_CONFIGURATION_AS_MAP)) {
            config = in.readGenericMap();
        } else {
            BytesReference bytes = in.readSlicedBytesReference();
            XContentType type = in.readEnum(XContentType.class);
            config = XContentHelper.convertToMap(bytes, true, type).v2();
        }
        return new PipelineConfiguration(id, config);
    }

    public static Diff<PipelineConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(PipelineConfiguration::readFrom, in);
    }

    public String toString() {
        return Strings.toString(this);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        if (out.getTransportVersion().onOrAfter(TransportVersions.INGEST_PIPELINE_CONFIGURATION_AS_MAP)) {
            out.writeGenericMap(this.config);
        } else {
            XContentBuilder builder = XContentBuilder.builder(JsonXContent.jsonXContent).prettyPrint();
            builder.map(this.config);
            out.writeBytesReference(BytesReference.bytes(builder));
            XContentHelper.writeTo(out, XContentType.JSON);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.config.equals(that.config);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.config.hashCode();
        return result;
    }

    PipelineConfiguration maybeUpgradeProcessors(String type, IngestMetadata.ProcessorConfigUpgrader upgrader) {
        Map<String, Object> mutableConfigMap = this.getConfig(false);
        boolean changed = false;
        Iterator iterator = mutableConfigMap.get("processors");
        if (iterator instanceof Iterable) {
            Iterable processors = (Iterable)((Object)iterator);
            for (Object processor : processors) {
                Map targetProcessor;
                Map processorConfigMap;
                Map processorMap;
                Object v;
                if (!(processor instanceof Map) || !((v = (processorMap = (Map)processor).get(type)) instanceof Map) || !upgrader.maybeUpgrade(processorConfigMap = (targetProcessor = (Map)v))) continue;
                changed = true;
            }
        }
        if (changed) {
            return new PipelineConfiguration(this.id, mutableConfigMap);
        }
        return this;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> builder.setConfig(parser.mapOrdered()), new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private Map<String, Object> config;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(Map<String, Object> config) {
            this.config = config;
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config);
        }
    }
}

