/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.index.reindex.AbstractBulkIndexByScrollRequestBuilder;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;

public class ReindexRequestBuilder
extends AbstractBulkIndexByScrollRequestBuilder<ReindexRequest, ReindexRequestBuilder> {
    private final IndexRequestBuilder destinationBuilder;
    private RemoteInfo remoteInfo;

    public ReindexRequestBuilder(ElasticsearchClient client) {
        this(client, new SearchRequestBuilder(client), new IndexRequestBuilder(client));
    }

    private ReindexRequestBuilder(ElasticsearchClient client, SearchRequestBuilder search, IndexRequestBuilder destination) {
        super(client, ReindexAction.INSTANCE, search);
        this.destinationBuilder = destination;
    }

    @Override
    protected ReindexRequestBuilder self() {
        return this;
    }

    public IndexRequestBuilder destination() {
        return this.destinationBuilder;
    }

    public ReindexRequestBuilder destination(String index) {
        this.destinationBuilder.setIndex(index);
        return this;
    }

    public ReindexRequestBuilder setRemoteInfo(RemoteInfo remoteInfo) {
        this.remoteInfo = remoteInfo;
        return this;
    }

    @Override
    public ReindexRequest request() {
        SearchRequest source = (SearchRequest)this.source().request();
        try {
            IndexRequest destination = this.destinationBuilder.request();
            try {
                ReindexRequest reindexRequest = new ReindexRequest(source, destination, false);
                try {
                    super.apply(reindexRequest);
                    if (this.remoteInfo != null) {
                        reindexRequest.setRemoteInfo(this.remoteInfo);
                    }
                    return reindexRequest;
                }
                catch (Exception e) {
                    reindexRequest.decRef();
                    throw e;
                }
            }
            catch (Exception e) {
                destination.decRef();
                throw e;
            }
        }
        catch (Exception e) {
            source.decRef();
            throw e;
        }
    }
}

