/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBooleanIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericIndexFieldData;
import org.elasticsearch.index.mapper.BlockDocValuesReader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IgnoreMalformedStoredValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.OnScriptError;
import org.elasticsearch.index.mapper.SortedNumericDocValuesSyntheticFieldLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TermBasedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TimeSeriesParams;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.BooleanFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptCompiler;
import org.elasticsearch.script.field.BooleanDocValuesField;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.FieldValues;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class BooleanFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "boolean";
    public static final FieldMapper.TypeParser PARSER = BooleanFieldMapper.createTypeParserWithLegacySupport((n, c) -> new Builder((String)n, c.scriptCompiler(), (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings()), c.indexVersionCreated()));
    private final Boolean nullValue;
    private final boolean indexed;
    private final boolean hasDocValues;
    private final boolean stored;
    private final Script script;
    private final FieldValues<Boolean> scriptValues;
    private final ScriptCompiler scriptCompiler;
    private final IndexVersion indexCreatedVersion;
    private final Explicit<Boolean> ignoreMalformed;
    private final boolean ignoreMalformedByDefault;
    private final boolean storeMalformedFields;

    private static BooleanFieldMapper toType(FieldMapper in) {
        return (BooleanFieldMapper)in;
    }

    protected BooleanFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean storeMalformedFields, Builder builder) {
        super(simpleName, mappedFieldType, builderParams);
        this.nullValue = builder.nullValue.getValue();
        this.stored = builder.stored.getValue();
        this.indexed = builder.indexed.getValue();
        this.hasDocValues = builder.docValues.getValue();
        this.script = builder.script.get();
        this.scriptValues = builder.scriptValues();
        this.scriptCompiler = builder.scriptCompiler;
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.ignoreMalformed = builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = builder.ignoreMalformed.getDefaultValue().value();
        this.storeMalformedFields = storeMalformedFields;
    }

    @Override
    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), Lucene.KEYWORD_ANALYZER);
    }

    @Override
    public BooleanFieldType fieldType() {
        return (BooleanFieldType)super.fieldType();
    }

    @Override
    protected void parseCreateField(DocumentParserContext context) throws IOException {
        if (!(this.indexed || this.stored || this.hasDocValues)) {
            return;
        }
        Boolean value = null;
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            if (this.nullValue != null) {
                value = this.nullValue;
            }
        } else {
            try {
                value = context.parser().booleanValue();
            }
            catch (IllegalArgumentException e) {
                if (this.ignoreMalformed.value().booleanValue() && context.parser().currentToken().isValue()) {
                    context.addIgnoredField(this.mappedFieldType.name());
                    if (this.storeMalformedFields) {
                        context.doc().add(IgnoreMalformedStoredValues.storedField(this.fullPath(), context.parser()));
                    }
                }
                throw e;
            }
        }
        this.indexValue(context, value);
    }

    private void indexValue(DocumentParserContext context, Boolean value) {
        if (value == null) {
            return;
        }
        if (this.fieldType().isDimension()) {
            context.getRoutingFields().addBoolean(this.fieldType().name(), value);
        }
        if (this.indexed) {
            context.doc().add(new StringField(this.fieldType().name(), value != false ? Values.TRUE : Values.FALSE, Field.Store.NO));
        }
        if (this.stored) {
            context.doc().add(new StoredField(this.fieldType().name(), value != false ? "T" : "F"));
        }
        if (this.hasDocValues) {
            context.doc().add(new SortedNumericDocValuesField(this.fieldType().name(), value != false ? 1L : 0L));
        } else {
            context.addToFieldNames(this.fieldType().name());
        }
    }

    @Override
    protected void indexScriptValues(SearchLookup searchLookup, LeafReaderContext readerContext, int doc, DocumentParserContext documentParserContext) {
        this.scriptValues.valuesForDoc(searchLookup, readerContext, doc, value -> this.indexValue(documentParserContext, (Boolean)value));
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.scriptCompiler, this.ignoreMalformedByDefault, this.indexCreatedVersion).dimension(this.fieldType().isDimension()).init(this);
    }

    @Override
    public void doValidate(MappingLookup lookup) {
        if (this.fieldType().isDimension() && null != lookup.nestedLookup().getNestedParent(this.fullPath())) {
            throw new IllegalArgumentException("time_series_dimension can't be configured in nested field [" + this.fullPath() + "]");
        }
    }

    @Override
    public boolean ignoreMalformed() {
        return this.ignoreMalformed.value();
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.hasDocValues) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new SortedNumericDocValuesSyntheticFieldLoader(this, this.fullPath(), this.leafName(), this.ignoreMalformed.value()){

                @Override
                protected void writeValue(XContentBuilder b, long value) throws IOException {
                    b.value(value == 1L);
                }
            });
        }
        return super.syntheticSourceSupport();
    }

    public static final class Builder
    extends FieldMapper.DimensionBuilder {
        private final FieldMapper.Parameter<Boolean> docValues = FieldMapper.Parameter.docValuesParam(m -> BooleanFieldMapper.toType((FieldMapper)m).hasDocValues, true);
        private final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> BooleanFieldMapper.toType((FieldMapper)m).indexed, true);
        private final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> BooleanFieldMapper.toType((FieldMapper)m).stored, false);
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        private final FieldMapper.Parameter<Boolean> nullValue = new FieldMapper.Parameter<Boolean>("null_value", false, () -> null, (n, c, o) -> o == null ? null : Boolean.valueOf(XContentMapValues.nodeBooleanValue(o)), m -> BooleanFieldMapper.toType((FieldMapper)m).nullValue, XContentBuilder::field, Objects::toString).acceptsNull();
        private final FieldMapper.Parameter<Script> script = FieldMapper.Parameter.scriptParam(m -> BooleanFieldMapper.toType((FieldMapper)m).script);
        private final FieldMapper.Parameter<OnScriptError> onScriptErrorParam = FieldMapper.Parameter.onScriptErrorParam(m -> BooleanFieldMapper.toType((FieldMapper)m).builderParams.onScriptError(), this.script);
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final ScriptCompiler scriptCompiler;
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<Boolean> dimension;

        public Builder(String name, ScriptCompiler scriptCompiler, boolean ignoreMalformedByDefault, IndexVersion indexCreatedVersion) {
            super(name);
            this.scriptCompiler = Objects.requireNonNull(scriptCompiler);
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam("ignore_malformed", true, m -> BooleanFieldMapper.toType((FieldMapper)m).ignoreMalformed, ignoreMalformedByDefault);
            this.script.precludesParameters(this.ignoreMalformed, this.nullValue);
            this.addScriptValidation(this.script, this.indexed, this.docValues);
            this.dimension = TimeSeriesParams.dimensionParam(m -> BooleanFieldMapper.toType(m).fieldType().isDimension()).addValidator(v -> {
                if (!(!v.booleanValue() || this.indexed.getValue().booleanValue() && this.docValues.getValue().booleanValue())) {
                    throw new IllegalArgumentException("Field [time_series_dimension] requires that [" + this.indexed.name + "] and [" + this.docValues.name + "] are true");
                }
            });
        }

        public Builder dimension(boolean dimension) {
            this.dimension.setValue(dimension);
            return this;
        }

        @Override
        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta, this.docValues, this.indexed, this.nullValue, this.stored, this.script, this.onScriptErrorParam, this.ignoreMalformed, this.dimension};
        }

        @Override
        public BooleanFieldMapper build(MapperBuilderContext context) {
            if (this.inheritDimensionParameterFromParentObject(context)) {
                this.dimension(true);
            }
            BooleanFieldType ft = new BooleanFieldType(context.buildFullName(this.leafName()), this.indexed.getValue() != false && !this.indexCreatedVersion.isLegacyIndexVersion(), this.stored.getValue(), this.docValues.getValue(), this.nullValue.getValue(), this.scriptValues(), this.meta.getValue(), this.dimension.getValue());
            this.hasScript = this.script.get() != null;
            this.onScriptError = this.onScriptErrorParam.getValue();
            return new BooleanFieldMapper(this.leafName(), ft, this.builderParams(this, context), context.isSourceSynthetic(), this);
        }

        private FieldValues<Boolean> scriptValues() {
            if (this.script.get() == null) {
                return null;
            }
            BooleanFieldScript.Factory scriptFactory = this.scriptCompiler.compile(this.script.get(), BooleanFieldScript.CONTEXT);
            return scriptFactory == null ? null : (lookup, ctx, doc, consumer) -> scriptFactory.newFactory(this.leafName(), this.script.get().getParams(), lookup, OnScriptError.FAIL).newInstance(ctx).runForDoc(doc, consumer);
        }
    }

    public static final class BooleanFieldType
    extends TermBasedFieldType {
        private final Boolean nullValue;
        private final FieldValues<Boolean> scriptValues;
        private final boolean isDimension;

        public BooleanFieldType(String name, boolean isIndexed, boolean isStored, boolean hasDocValues, Boolean nullValue, FieldValues<Boolean> scriptValues, Map<String, String> meta, boolean isDimension) {
            super(name, isIndexed, isStored, hasDocValues, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.nullValue = nullValue;
            this.scriptValues = scriptValues;
            this.isDimension = isDimension;
        }

        public BooleanFieldType(String name) {
            this(name, true);
        }

        public BooleanFieldType(String name, boolean isIndexed) {
            this(name, isIndexed, true);
        }

        public BooleanFieldType(String name, boolean isIndexed, boolean hasDocValues) {
            this(name, isIndexed, isIndexed, hasDocValues, false, null, Collections.emptyMap(), false);
        }

        @Override
        public String typeName() {
            return BooleanFieldMapper.CONTENT_TYPE;
        }

        @Override
        public boolean isSearchable() {
            return this.isIndexed() || this.hasDocValues();
        }

        @Override
        public boolean isDimension() {
            return this.isDimension;
        }

        @Override
        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
            }
            if (this.scriptValues != null) {
                return FieldValues.valueFetcher(this.scriptValues, context);
            }
            return this.sourceValueFetcher(context.isSourceEnabled() ? context.sourcePath(this.name()) : Collections.emptySet());
        }

        private SourceValueFetcher sourceValueFetcher(Set<String> sourcePaths) {
            return new SourceValueFetcher(this, sourcePaths, (Object)this.nullValue){

                @Override
                protected Boolean parseSourceValue(Object value) {
                    if (value instanceof Boolean) {
                        return (Boolean)value;
                    }
                    String textValue = value.toString();
                    return Booleans.parseBoolean(textValue.toCharArray(), 0, textValue.length(), false);
                }
            };
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            if (value == null) {
                return Values.FALSE;
            }
            if (value instanceof Boolean) {
                return (Boolean)value != false ? Values.TRUE : Values.FALSE;
            }
            String sValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            return switch (sValue) {
                case "true" -> Values.TRUE;
                case "false" -> Values.FALSE;
                default -> throw new IllegalArgumentException("Can't parse boolean value [" + sValue + "], expected [true] or [false]");
            };
        }

        private long docValueForSearch(Object value) {
            BytesRef ref = this.indexedValueForSearch(value);
            if (Values.TRUE.equals(ref)) {
                return 1L;
            }
            return 0L;
        }

        @Override
        public Boolean valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            return switch (value.toString()) {
                case "F" -> false;
                case "T" -> true;
                default -> throw new IllegalArgumentException("Expected [T] or [F] but got [" + String.valueOf(value) + "]");
            };
        }

        @Override
        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.hasDocValues()) {
                return new BlockDocValuesReader.BooleansBlockLoader(this.name());
            }
            SourceValueFetcher fetcher = this.sourceValueFetcher(blContext.sourcePaths(this.name()));
            BlockSourceReader.LeafIteratorLookup lookup = this.isIndexed() || this.isStored() ? BlockSourceReader.lookupFromFieldNames(blContext.fieldNames(), this.name()) : BlockSourceReader.lookupMatchingAll();
            return new BlockSourceReader.BooleansBlockLoader(fetcher, lookup);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            MappedFieldType.FielddataOperation operation = fieldDataContext.fielddataOperation();
            if (operation == MappedFieldType.FielddataOperation.SEARCH) {
                this.failIfNoDocValues();
            }
            if ((operation == MappedFieldType.FielddataOperation.SEARCH || operation == MappedFieldType.FielddataOperation.SCRIPT) && this.hasDocValues()) {
                boolean indexed = false;
                return new SortedNumericIndexFieldData.Builder(this.name(), IndexNumericFieldData.NumericType.BOOLEAN, BooleanDocValuesField::new, indexed);
            }
            if (operation == MappedFieldType.FielddataOperation.SCRIPT) {
                SearchLookup searchLookup = fieldDataContext.lookupSupplier().get();
                Set<String> sourcePaths = fieldDataContext.sourcePathsLookup().apply(this.name());
                return new SourceValueFetcherSortedBooleanIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BOOLEAN, (ValueFetcher)this.sourceValueFetcher(sourcePaths), (SourceProvider)searchLookup, BooleanDocValuesField::new);
            }
            throw new IllegalStateException("unknown field data type [" + operation.name() + "]");
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            this.checkNoFormat(format);
            this.checkNoTimeZone(timeZone);
            return DocValueFormat.BOOLEAN;
        }

        @Override
        public Query termQuery(Object value, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.termQuery(value, context);
            }
            return SortedNumericDocValuesField.newSlowExactQuery(this.name(), this.docValueForSearch(value));
        }

        @Override
        public Query termsQuery(Collection<?> values, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return super.termsQuery(values, context);
            }
            HashSet dedupe = new HashSet(values);
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Object value : dedupe) {
                builder.add(this.termQuery(value, context), BooleanClause.Occur.SHOULD);
            }
            return new ConstantScoreQuery(builder.build());
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            this.failIfNotIndexedNorDocValuesFallback(context);
            if (this.isIndexed()) {
                return new TermRangeQuery(this.name(), lowerTerm == null ? null : this.indexedValueForSearch(lowerTerm), upperTerm == null ? null : this.indexedValueForSearch(upperTerm), includeLower, includeUpper);
            }
            long l = 0L;
            long u = 1L;
            if (lowerTerm != null) {
                l = this.docValueForSearch(lowerTerm);
                if (!includeLower) {
                    l = Math.max(1L, l + 1L);
                }
            }
            if (upperTerm != null) {
                u = this.docValueForSearch(upperTerm);
                if (!includeUpper) {
                    l = Math.min(0L, l - 1L);
                }
            }
            if (l > u) {
                return new MatchNoDocsQuery();
            }
            return SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
        }
    }

    public static class Values {
        public static final BytesRef TRUE = new BytesRef("T");
        public static final BytesRef FALSE = new BytesRef("F");
    }
}

