/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.store.LuceneFilesExtensions;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public class SegmentsStats
implements Writeable,
ToXContentFragment {
    private long count;
    private long indexWriterMemoryInBytes;
    private long versionMapMemoryInBytes;
    private long maxUnsafeAutoIdTimestamp = Long.MIN_VALUE;
    private long bitsetMemoryInBytes;
    private final Map<String, FileStats> files;

    public SegmentsStats() {
        this.files = new HashMap<String, FileStats>();
    }

    public SegmentsStats(StreamInput in) throws IOException {
        this.count = in.readVLong();
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
            in.readLong();
        }
        this.indexWriterMemoryInBytes = in.readLong();
        this.versionMapMemoryInBytes = in.readLong();
        this.bitsetMemoryInBytes = in.readLong();
        this.maxUnsafeAutoIdTimestamp = in.readLong();
        this.files = in.readMapValues(FileStats::new, FileStats::getExt);
    }

    public void add(long count) {
        this.count += count;
    }

    public void addIndexWriterMemoryInBytes(long indexWriterMemoryInBytes) {
        this.indexWriterMemoryInBytes += indexWriterMemoryInBytes;
    }

    public void addVersionMapMemoryInBytes(long versionMapMemoryInBytes) {
        this.versionMapMemoryInBytes += versionMapMemoryInBytes;
    }

    void updateMaxUnsafeAutoIdTimestamp(long maxUnsafeAutoIdTimestamp) {
        this.maxUnsafeAutoIdTimestamp = Math.max(maxUnsafeAutoIdTimestamp, this.maxUnsafeAutoIdTimestamp);
    }

    public void addBitsetMemoryInBytes(long bitsetMemoryInBytes) {
        this.bitsetMemoryInBytes += bitsetMemoryInBytes;
    }

    public void addFiles(Map<String, FileStats> newFiles) {
        newFiles.forEach((k, v) -> this.files.merge((String)k, (FileStats)v, FileStats::merge));
    }

    public void add(SegmentsStats mergeStats) {
        if (mergeStats == null) {
            return;
        }
        this.updateMaxUnsafeAutoIdTimestamp(mergeStats.maxUnsafeAutoIdTimestamp);
        this.add(mergeStats.count);
        this.addIndexWriterMemoryInBytes(mergeStats.indexWriterMemoryInBytes);
        this.addVersionMapMemoryInBytes(mergeStats.versionMapMemoryInBytes);
        this.addBitsetMemoryInBytes(mergeStats.bitsetMemoryInBytes);
        this.addFiles(mergeStats.files);
    }

    public long getCount() {
        return this.count;
    }

    public long getIndexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public ByteSizeValue getIndexWriterMemory() {
        return ByteSizeValue.ofBytes(this.indexWriterMemoryInBytes);
    }

    public long getVersionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    public ByteSizeValue getVersionMapMemory() {
        return ByteSizeValue.ofBytes(this.versionMapMemoryInBytes);
    }

    public long getBitsetMemoryInBytes() {
        return this.bitsetMemoryInBytes;
    }

    public ByteSizeValue getBitsetMemory() {
        return ByteSizeValue.ofBytes(this.bitsetMemoryInBytes);
    }

    public Map<String, FileStats> getFiles() {
        return Collections.unmodifiableMap(this.files);
    }

    public long getMaxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segments");
        builder.field("count", this.count);
        builder.humanReadableField("memory_in_bytes", "memory", ByteSizeValue.ZERO);
        builder.humanReadableField("terms_memory_in_bytes", "terms_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("stored_fields_memory_in_bytes", "stored_fields_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("term_vectors_memory_in_bytes", "term_vectors_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("norms_memory_in_bytes", "norms_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("points_memory_in_bytes", "points_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("doc_values_memory_in_bytes", "doc_values_memory", ByteSizeValue.ZERO);
        builder.humanReadableField("index_writer_memory_in_bytes", "index_writer_memory", this.getIndexWriterMemory());
        builder.humanReadableField("version_map_memory_in_bytes", "version_map_memory", this.getVersionMapMemory());
        builder.humanReadableField("fixed_bit_set_memory_in_bytes", "fixed_bit_set", this.getBitsetMemory());
        builder.field("max_unsafe_auto_id_timestamp", this.maxUnsafeAutoIdTimestamp);
        builder.startObject("file_sizes");
        for (Map.Entry<String, FileStats> entry : this.files.entrySet()) {
            entry.getValue().toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsStats that = (SegmentsStats)o;
        return this.count == that.count && this.indexWriterMemoryInBytes == that.indexWriterMemoryInBytes && this.versionMapMemoryInBytes == that.versionMapMemoryInBytes && this.maxUnsafeAutoIdTimestamp == that.maxUnsafeAutoIdTimestamp && this.bitsetMemoryInBytes == that.bitsetMemoryInBytes && Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.indexWriterMemoryInBytes, this.versionMapMemoryInBytes, this.maxUnsafeAutoIdTimestamp, this.bitsetMemoryInBytes, this.files);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.count);
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
            out.writeLong(0L);
        }
        out.writeLong(this.indexWriterMemoryInBytes);
        out.writeLong(this.versionMapMemoryInBytes);
        out.writeLong(this.bitsetMemoryInBytes);
        out.writeLong(this.maxUnsafeAutoIdTimestamp);
        out.writeCollection(this.files.values());
    }

    public void clearFiles() {
        this.files.clear();
    }

    static final class Fields {
        static final String SEGMENTS = "segments";
        static final String COUNT = "count";
        static final String MEMORY = "memory";
        static final String MEMORY_IN_BYTES = "memory_in_bytes";
        static final String TERMS_MEMORY = "terms_memory";
        static final String TERMS_MEMORY_IN_BYTES = "terms_memory_in_bytes";
        static final String STORED_FIELDS_MEMORY = "stored_fields_memory";
        static final String STORED_FIELDS_MEMORY_IN_BYTES = "stored_fields_memory_in_bytes";
        static final String TERM_VECTORS_MEMORY = "term_vectors_memory";
        static final String TERM_VECTORS_MEMORY_IN_BYTES = "term_vectors_memory_in_bytes";
        static final String NORMS_MEMORY = "norms_memory";
        static final String NORMS_MEMORY_IN_BYTES = "norms_memory_in_bytes";
        static final String POINTS_MEMORY = "points_memory";
        static final String POINTS_MEMORY_IN_BYTES = "points_memory_in_bytes";
        static final String DOC_VALUES_MEMORY = "doc_values_memory";
        static final String DOC_VALUES_MEMORY_IN_BYTES = "doc_values_memory_in_bytes";
        static final String INDEX_WRITER_MEMORY = "index_writer_memory";
        static final String INDEX_WRITER_MEMORY_IN_BYTES = "index_writer_memory_in_bytes";
        static final String VERSION_MAP_MEMORY = "version_map_memory";
        static final String VERSION_MAP_MEMORY_IN_BYTES = "version_map_memory_in_bytes";
        static final String MAX_UNSAFE_AUTO_ID_TIMESTAMP = "max_unsafe_auto_id_timestamp";
        static final String FIXED_BIT_SET = "fixed_bit_set";
        static final String FIXED_BIT_SET_MEMORY_IN_BYTES = "fixed_bit_set_memory_in_bytes";
        static final String FILE_SIZES = "file_sizes";

        Fields() {
        }
    }

    public static class FileStats
    implements Writeable,
    ToXContentFragment {
        private final String ext;
        private final long total;
        private final long count;
        private final long min;
        private final long max;

        FileStats(StreamInput in) throws IOException {
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_7_13_0)) {
                this.ext = in.readString();
                this.total = in.readVLong();
                this.count = in.readVLong();
                this.min = in.readVLong();
                this.max = in.readVLong();
            } else {
                this.ext = in.readString();
                this.total = in.readLong();
                this.count = 0L;
                this.min = 0L;
                this.max = 0L;
            }
        }

        public FileStats(String ext, long total, long count, long min, long max) {
            this.ext = ext;
            this.total = total;
            this.count = count;
            this.min = min;
            this.max = max;
        }

        public String getExt() {
            return this.ext;
        }

        public long getCount() {
            return this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public long getMin() {
            return this.min;
        }

        public long getMax() {
            return this.max;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_7_13_0)) {
                out.writeString(this.ext);
                out.writeVLong(this.total);
                out.writeVLong(this.count);
                out.writeVLong(this.min);
                out.writeVLong(this.max);
            } else {
                out.writeString(this.ext);
                out.writeLong(this.total);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            long roundedAverage = this.count > 0L ? Math.round((double)this.total / (double)this.count) : 0L;
            LuceneFilesExtensions extension = LuceneFilesExtensions.fromExtension(this.ext);
            String name = extension != null ? extension.getExtension() : "others";
            String desc = extension != null ? extension.getDescription() : "Others";
            builder.startObject(name);
            builder.field("description", desc);
            builder.humanReadableField("size_in_bytes", "size", ByteSizeValue.ofBytes(this.total));
            builder.humanReadableField("min_size_in_bytes", "min_size", ByteSizeValue.ofBytes(this.min));
            builder.humanReadableField("max_size_in_bytes", "max_size", ByteSizeValue.ofBytes(this.max));
            builder.humanReadableField("average_size_in_bytes", "average_size", ByteSizeValue.ofBytes(roundedAverage));
            builder.field("count", this.count);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileStats that = (FileStats)o;
            return Objects.equals(this.ext, that.ext) && this.total == that.total && this.count == that.count && this.min == that.min && this.max == that.max;
        }

        public int hashCode() {
            return Objects.hash(this.ext, this.total, this.count, this.min, this.max);
        }

        public static FileStats merge(FileStats o1, FileStats o2) {
            assert (o1 != null && o1.ext != null) : o1;
            assert (o2 != null && o2.ext != null) : o2;
            assert (o1.ext.equals(o2.ext)) : String.valueOf(o1) + " vs " + String.valueOf(o2);
            return new FileStats(o1.ext, Math.addExact(o1.total, o2.total), Math.addExact(o1.count, o2.count), Math.min(o1.min, o2.min), Math.max(o1.max, o2.max));
        }

        public String toString() {
            return Strings.toString(this);
        }
    }
}

