/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PermissiveModifyRequestControl
extends Control {
    @NotNull
    public static final String PERMISSIVE_MODIFY_REQUEST_OID = "1.2.840.113556.1.4.1413";
    private static final long serialVersionUID = -2599039772002106760L;

    public PermissiveModifyRequestControl() {
        super(PERMISSIVE_MODIFY_REQUEST_OID, false, null);
    }

    public PermissiveModifyRequestControl(boolean isCritical) {
        super(PERMISSIVE_MODIFY_REQUEST_OID, isCritical, null);
    }

    public PermissiveModifyRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        if (control.hasValue()) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PERMISSIVE_MODIFY_HAS_VALUE.get());
        }
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PERMISSIVE_MODIFY_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PermissiveModifyRequestControl(isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

