/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ReferralConnector;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.MOSTLY_NOT_THREADSAFE)
public final class RetainConnectExceptionReferralConnector
implements ReferralConnector {
    @Nullable
    private final ReferralConnector wrappedReferralConnector;
    @Nullable
    private volatile LDAPException connectExceptionFromLastAttempt;

    public RetainConnectExceptionReferralConnector() {
        this(null);
    }

    public RetainConnectExceptionReferralConnector(@Nullable ReferralConnector wrappedReferralConnector) {
        this.wrappedReferralConnector = wrappedReferralConnector;
        this.connectExceptionFromLastAttempt = null;
    }

    @Nullable
    public LDAPException getExceptionFromLastConnectAttempt() {
        return this.connectExceptionFromLastAttempt;
    }

    @Override
    @NotNull
    public LDAPConnection getReferralConnection(@NotNull LDAPURL referralURL, @NotNull LDAPConnection connection) throws LDAPException {
        ReferralConnector connector = this.wrappedReferralConnector == null ? connection.getReferralConnector() : this.wrappedReferralConnector;
        LDAPException connectException = null;
        try {
            LDAPConnection lDAPConnection = connector.getReferralConnection(referralURL, connection);
            return lDAPConnection;
        }
        catch (LDAPException e) {
            Debug.debugException(e);
            connectException = e;
            throw e;
        }
        finally {
            this.connectExceptionFromLastAttempt = connectException;
        }
    }
}

