/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JvmThreads
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final Long peakCount;
    public static final JsonpDeserializer<JvmThreads> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmThreads::setupJvmThreadsDeserializer);

    private JvmThreads(Builder builder) {
        this.count = builder.count;
        this.peakCount = builder.peakCount;
    }

    public static JvmThreads of(Function<Builder, ObjectBuilder<JvmThreads>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final Long peakCount() {
        return this.peakCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count);
        }
        if (this.peakCount != null) {
            generator.writeKey("peak_count");
            generator.write(this.peakCount);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJvmThreadsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::peakCount, JsonpDeserializer.longDeserializer(), "peak_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JvmThreads> {
        @Nullable
        private Long count;
        @Nullable
        private Long peakCount;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder peakCount(@Nullable Long value) {
            this.peakCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JvmThreads build() {
            this._checkSingleUse();
            return new JvmThreads(this);
        }
    }
}

